/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentInterceptor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class AuthorizationInterceptor
implements IRuleApplier {
    public static final String REQUEST_ATTRIBUTE_BULK_DATA_EXPORT_OPTIONS = AuthorizationInterceptor.class.getName() + "_BulkDataExportOptions";
    private static final AtomicInteger ourInstanceCount = new AtomicInteger(0);
    private static final Logger ourLog = LoggerFactory.getLogger(AuthorizationInterceptor.class);
    private final int myInstanceIndex = ourInstanceCount.incrementAndGet();
    private final String myRequestSeenResourcesKey = AuthorizationInterceptor.class.getName() + "_" + this.myInstanceIndex + "_SEENRESOURCES";
    private final String myRequestRuleListKey = AuthorizationInterceptor.class.getName() + "_" + this.myInstanceIndex + "_RULELIST";
    private PolicyEnum myDefaultPolicy = PolicyEnum.DENY;
    private Set<AuthorizationFlagsEnum> myFlags = Collections.emptySet();

    public AuthorizationInterceptor() {
    }

    public AuthorizationInterceptor(PolicyEnum theDefaultPolicy) {
        this();
        this.setDefaultPolicy(theDefaultPolicy);
    }

    private void applyRulesAndFailIfDeny(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, Pointcut thePointcut) {
        Verdict decision = this.applyRulesAndReturnDecision(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, thePointcut);
        if (decision.getDecision() == PolicyEnum.ALLOW) {
            return;
        }
        this.handleDeny(theRequestDetails, decision);
    }

    @Override
    public Verdict applyRulesAndReturnDecision(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, Pointcut thePointcut) {
        List<IAuthRule> rules = (List<IAuthRule>)theRequestDetails.getUserData().get(this.myRequestRuleListKey);
        if (rules == null) {
            rules = this.buildRuleList(theRequestDetails);
            theRequestDetails.getUserData().put(this.myRequestRuleListKey, rules);
        }
        Set<AuthorizationFlagsEnum> flags = this.getFlags();
        ourLog.trace("Applying {} rules to render an auth decision for operation {}, theInputResource type={}, theOutputResource type={} ", new Object[]{rules.size(), theOperation, theInputResource != null && theInputResource.getIdElement() != null ? theInputResource.getIdElement().getResourceType() : "", theOutputResource != null && theOutputResource.getIdElement() != null ? theOutputResource.getIdElement().getResourceType() : ""});
        Verdict verdict = null;
        for (IAuthRule nextRule : rules) {
            ourLog.trace("Rule being applied - {}", (Object)nextRule);
            verdict = nextRule.applyRule(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, this, flags, thePointcut);
            if (verdict == null) continue;
            ourLog.trace("Rule {} returned decision {}", (Object)nextRule, (Object)verdict.getDecision());
            break;
        }
        if (verdict == null) {
            ourLog.trace("No rules returned a decision, applying default {}", (Object)this.myDefaultPolicy);
            return new Verdict(this.getDefaultPolicy(), null);
        }
        return verdict;
    }

    public List<IAuthRule> buildRuleList(RequestDetails theRequestDetails) {
        return new ArrayList<IAuthRule>();
    }

    private OperationExamineDirection determineOperationDirection(RestOperationTypeEnum theOperation, IBaseResource theRequestResource) {
        switch (theOperation) {
            case ADD_TAGS: 
            case DELETE_TAGS: 
            case GET_TAGS: {
                return OperationExamineDirection.NONE;
            }
            case EXTENDED_OPERATION_INSTANCE: 
            case EXTENDED_OPERATION_SERVER: 
            case EXTENDED_OPERATION_TYPE: {
                return OperationExamineDirection.BOTH;
            }
            case METADATA: {
                return OperationExamineDirection.IN;
            }
            case DELETE: {
                return OperationExamineDirection.IN;
            }
            case CREATE: 
            case UPDATE: 
            case PATCH: {
                return OperationExamineDirection.IN;
            }
            case META: 
            case META_ADD: 
            case META_DELETE: {
                return OperationExamineDirection.NONE;
            }
            case GET_PAGE: 
            case HISTORY_INSTANCE: 
            case HISTORY_SYSTEM: 
            case HISTORY_TYPE: 
            case READ: 
            case SEARCH_SYSTEM: 
            case SEARCH_TYPE: 
            case VREAD: {
                return OperationExamineDirection.OUT;
            }
            case TRANSACTION: {
                return OperationExamineDirection.BOTH;
            }
            case VALIDATE: {
                return OperationExamineDirection.NONE;
            }
            case GRAPHQL_REQUEST: {
                return OperationExamineDirection.BOTH;
            }
        }
        throw new IllegalStateException("Unable to apply security to event of type " + (Object)((Object)theOperation));
    }

    public PolicyEnum getDefaultPolicy() {
        return this.myDefaultPolicy;
    }

    public AuthorizationInterceptor setDefaultPolicy(PolicyEnum theDefaultPolicy) {
        Validate.notNull((Object)((Object)theDefaultPolicy), (String)"theDefaultPolicy must not be null", (Object[])new Object[0]);
        this.myDefaultPolicy = theDefaultPolicy;
        return this;
    }

    public Set<AuthorizationFlagsEnum> getFlags() {
        return Collections.unmodifiableSet(this.myFlags);
    }

    public AuthorizationInterceptor setFlags(Collection<AuthorizationFlagsEnum> theFlags) {
        Validate.notNull(theFlags, (String)"theFlags must not be null", (Object[])new Object[0]);
        this.myFlags = new HashSet<AuthorizationFlagsEnum>(theFlags);
        return this;
    }

    public AuthorizationInterceptor setFlags(AuthorizationFlagsEnum ... theFlags) {
        Validate.notNull((Object)theFlags, (String)"theFlags must not be null", (Object[])new Object[0]);
        return this.setFlags(Lists.newArrayList(theFlags));
    }

    protected void handleDeny(RequestDetails theRequestDetails, Verdict decision) {
        this.handleDeny(decision);
    }

    protected void handleDeny(Verdict decision) {
        if (decision.getDecidingRule() != null) {
            String ruleName = StringUtils.defaultString((String)decision.getDecidingRule().getName(), (String)"(unnamed rule)");
            throw new ForbiddenOperationException("Access denied by rule: " + ruleName);
        }
        throw new ForbiddenOperationException("Access denied by default policy (no applicable rules)");
    }

    private void handleUserOperation(RequestDetails theRequest, IBaseResource theResource, RestOperationTypeEnum theOperation, Pointcut thePointcut) {
        this.applyRulesAndFailIfDeny(theOperation, theRequest, theResource, theResource.getIdElement(), null, thePointcut);
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void incomingRequestPreHandled(RequestDetails theRequest, Pointcut thePointcut) {
        IBaseResource inputResource = null;
        IIdType inputResourceId = null;
        switch (this.determineOperationDirection(theRequest.getRestOperationType(), theRequest.getResource())) {
            case IN: 
            case BOTH: {
                inputResource = theRequest.getResource();
                inputResourceId = theRequest.getId();
                if (inputResourceId != null || !StringUtils.isNotBlank((CharSequence)theRequest.getResourceName())) break;
                inputResourceId = theRequest.getFhirContext().getVersion().newIdType();
                inputResourceId.setParts(null, theRequest.getResourceName(), null, null);
                break;
            }
            case OUT: {
                inputResourceId = theRequest.getId();
                break;
            }
            case NONE: {
                return;
            }
        }
        this.applyRulesAndFailIfDeny(theRequest.getRestOperationType(), theRequest, inputResource, inputResourceId, null, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void hookPreShow(RequestDetails theRequestDetails, IPreResourceShowDetails theDetails, Pointcut thePointcut) {
        for (int i2 = 0; i2 < theDetails.size(); ++i2) {
            IBaseResource next = theDetails.getResource(i2);
            this.checkOutgoingResourceAndFailIfDeny(theRequestDetails, next, thePointcut);
        }
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void hookOutgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, Pointcut thePointcut) {
        this.checkOutgoingResourceAndFailIfDeny(theRequestDetails, theResponseObject, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_CASCADE_DELETE)
    public void hookCascadeDeleteForConflict(RequestDetails theRequestDetails, Pointcut thePointcut, IBaseResource theResourceToDelete) {
        Validate.notNull((Object)theResourceToDelete);
        this.checkPointcutAndFailIfDeny(theRequestDetails, thePointcut, theResourceToDelete);
    }

    @Hook(value=Pointcut.STORAGE_PRE_DELETE_EXPUNGE)
    public void hookDeleteExpunge(RequestDetails theRequestDetails, Pointcut thePointcut) {
        this.applyRulesAndFailIfDeny(theRequestDetails.getRestOperationType(), theRequestDetails, null, null, null, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_INITIATE_BULK_EXPORT)
    public void initiateBulkExport(RequestDetails theRequestDetails, BulkDataExportOptions theBulkExportOptions, Pointcut thePointcut) {
        RestOperationTypeEnum restOperationType = RestOperationTypeEnum.EXTENDED_OPERATION_SERVER;
        if (theRequestDetails != null) {
            theRequestDetails.setAttribute(REQUEST_ATTRIBUTE_BULK_DATA_EXPORT_OPTIONS, theBulkExportOptions);
        }
        this.applyRulesAndFailIfDeny(restOperationType, theRequestDetails, null, null, null, thePointcut);
    }

    private void checkPointcutAndFailIfDeny(RequestDetails theRequestDetails, Pointcut thePointcut, @Nonnull IBaseResource theInputResource) {
        this.applyRulesAndFailIfDeny(theRequestDetails.getRestOperationType(), theRequestDetails, theInputResource, theInputResource.getIdElement(), null, thePointcut);
    }

    private void checkOutgoingResourceAndFailIfDeny(RequestDetails theRequestDetails, IBaseResource theResponseObject, Pointcut thePointcut) {
        switch (this.determineOperationDirection(theRequestDetails.getRestOperationType(), null)) {
            case IN: 
            case NONE: {
                return;
            }
        }
        IdentityHashMap<IBaseResource, Boolean> alreadySeenMap = ConsentInterceptor.getAlreadySeenResourcesMap(theRequestDetails, this.myRequestSeenResourcesKey);
        if (alreadySeenMap.putIfAbsent(theResponseObject, Boolean.TRUE) != null) {
            return;
        }
        FhirContext fhirContext = theRequestDetails.getServer().getFhirContext();
        List<Object> resources = Collections.emptyList();
        switch (theRequestDetails.getRestOperationType()) {
            case EXTENDED_OPERATION_INSTANCE: 
            case EXTENDED_OPERATION_SERVER: 
            case EXTENDED_OPERATION_TYPE: 
            case GET_PAGE: 
            case HISTORY_INSTANCE: 
            case HISTORY_SYSTEM: 
            case HISTORY_TYPE: 
            case SEARCH_SYSTEM: 
            case SEARCH_TYPE: 
            case TRANSACTION: {
                if (theResponseObject == null) break;
                resources = AuthorizationInterceptor.toListOfResourcesAndExcludeContainer(theResponseObject, fhirContext);
                break;
            }
            default: {
                if (theResponseObject == null) break;
                resources = Collections.singletonList(theResponseObject);
            }
        }
        for (IBaseResource nextResponse : resources) {
            this.applyRulesAndFailIfDeny(theRequestDetails.getRestOperationType(), theRequestDetails, null, null, nextResponse, thePointcut);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void hookResourcePreCreate(RequestDetails theRequest, IBaseResource theResource, Pointcut thePointcut) {
        this.handleUserOperation(theRequest, theResource, RestOperationTypeEnum.CREATE, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED)
    public void hookResourcePreDelete(RequestDetails theRequest, IBaseResource theResource, Pointcut thePointcut) {
        this.handleUserOperation(theRequest, theResource, RestOperationTypeEnum.DELETE, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void hookResourcePreUpdate(RequestDetails theRequest, IBaseResource theOldResource, IBaseResource theNewResource, Pointcut thePointcut) {
        if (theOldResource != null) {
            this.handleUserOperation(theRequest, theOldResource, RestOperationTypeEnum.UPDATE, thePointcut);
        }
        this.handleUserOperation(theRequest, theNewResource, RestOperationTypeEnum.UPDATE, thePointcut);
    }

    static List<IBaseResource> toListOfResourcesAndExcludeContainer(IBaseResource theResponseObject, FhirContext fhirContext) {
        if (theResponseObject == null) {
            return Collections.emptyList();
        }
        boolean isContainer = false;
        if (theResponseObject instanceof IBaseBundle) {
            isContainer = true;
        } else if (theResponseObject instanceof IBaseParameters) {
            isContainer = true;
        }
        if (!isContainer) {
            return Collections.singletonList(theResponseObject);
        }
        List<IBaseResource> retVal = fhirContext.newTerser().getAllPopulatedChildElementsOfType(theResponseObject, IBaseResource.class);
        if (retVal.size() > 0 && retVal.get(0) == theResponseObject) {
            retVal = retVal.subList(1, retVal.size());
        }
        return retVal;
    }

    public static class Verdict {
        private final IAuthRule myDecidingRule;
        private final PolicyEnum myDecision;

        public Verdict(PolicyEnum theDecision, IAuthRule theDecidingRule) {
            Validate.notNull((Object)((Object)theDecision));
            this.myDecision = theDecision;
            this.myDecidingRule = theDecidingRule;
        }

        IAuthRule getDecidingRule() {
            return this.myDecidingRule;
        }

        public PolicyEnum getDecision() {
            return this.myDecision;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            String ruleName = this.myDecidingRule != null ? this.myDecidingRule.getName() : "(none)";
            b.append("rule", (Object)ruleName);
            b.append("decision", (Object)this.myDecision.name());
            return b.build();
        }
    }

    private static enum OperationExamineDirection {
        BOTH,
        IN,
        NONE,
        OUT;

    }
}

