/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.rest.client.apache.ApacheHttpRequest;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipContentInterceptor
implements IClientInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(GZipContentInterceptor.class);

    @Override
    public void interceptRequest(IHttpRequest theRequestInterface) {
        Header[] encodingHeaders;
        HttpRequestBase theRequest = ((ApacheHttpRequest)theRequestInterface).getApacheRequest();
        if (theRequest instanceof HttpEntityEnclosingRequest && ((encodingHeaders = theRequest.getHeaders("Content-Encoding")) == null || encodingHeaders.length == 0)) {
            HttpEntityEnclosingRequest req = (HttpEntityEnclosingRequest)((Object)theRequest);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                req.getEntity().writeTo(gos);
                gos.finish();
            }
            catch (IOException e) {
                ourLog.warn("Failed to GZip outgoing content", (Throwable)e);
                return;
            }
            byte[] byteArray = bos.toByteArray();
            ByteArrayEntity newEntity = new ByteArrayEntity(byteArray);
            req.setEntity(newEntity);
            req.addHeader("Content-Encoding", "gzip");
        }
    }

    @Override
    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }
}

