/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.storage;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;

public class TransactionDetails {
    public static final ResourcePersistentId NOT_FOUND = new ResourcePersistentId(-1L);
    private final Date myTransactionDate;
    private Map<String, ResourcePersistentId> myResolvedResourceIds = Collections.emptyMap();
    private Map<String, ResourcePersistentId> myResolvedMatchUrls = Collections.emptyMap();
    private Map<String, Object> myUserData;
    private ListMultimap<Pointcut, HookParams> myDeferredInterceptorBroadcasts;
    private EnumSet<Pointcut> myDeferredInterceptorBroadcastPointcuts;
    private boolean myIsPointcutDeferred;

    public TransactionDetails() {
        this(new Date());
    }

    public TransactionDetails(Date theTransactionDate) {
        this.myTransactionDate = theTransactionDate;
    }

    @Nullable
    public ResourcePersistentId getResolvedResourceId(IIdType theId) {
        String idValue = theId.toVersionless().getValue();
        return this.myResolvedResourceIds.get(idValue);
    }

    public boolean isResolvedResourceIdEmpty(IIdType theId) {
        if (this.myResolvedResourceIds != null && this.myResolvedResourceIds.containsKey(theId.toVersionless().getValue())) {
            return this.myResolvedResourceIds.get(theId.toVersionless().getValue()) == null;
        }
        return false;
    }

    public void addResolvedResourceId(IIdType theResourceId, @Nullable ResourcePersistentId thePersistentId) {
        assert (theResourceId != null);
        if (this.myResolvedResourceIds.isEmpty()) {
            this.myResolvedResourceIds = new HashMap<String, ResourcePersistentId>();
        }
        this.myResolvedResourceIds.put(theResourceId.toVersionless().getValue(), thePersistentId);
    }

    public Map<String, ResourcePersistentId> getResolvedMatchUrls() {
        return this.myResolvedMatchUrls;
    }

    public void addResolvedMatchUrl(String theConditionalUrl, @Nonnull ResourcePersistentId thePersistentId) {
        Validate.notBlank((CharSequence)theConditionalUrl);
        Validate.notNull((Object)thePersistentId);
        if (this.myResolvedMatchUrls.isEmpty()) {
            this.myResolvedMatchUrls = new HashMap<String, ResourcePersistentId>();
        }
        this.myResolvedMatchUrls.put(theConditionalUrl, thePersistentId);
    }

    public Date getTransactionDate() {
        return this.myTransactionDate;
    }

    public void putUserData(String theKey, Object theValue) {
        if (this.myUserData == null) {
            this.myUserData = new HashMap<String, Object>();
        }
        this.myUserData.put(theKey, theValue);
    }

    public <T> T getUserData(String theKey) {
        if (this.myUserData != null) {
            return (T)this.myUserData.get(theKey);
        }
        return null;
    }

    public <T> T getOrCreateUserData(String theKey, Supplier<T> theSupplier) {
        T retVal = this.getUserData(theKey);
        if (retVal == null) {
            retVal = theSupplier.get();
            this.putUserData(theKey, retVal);
        }
        return retVal;
    }

    public void beginAcceptingDeferredInterceptorBroadcasts(Pointcut ... thePointcuts) {
        Validate.isTrue((!this.isAcceptingDeferredInterceptorBroadcasts() ? 1 : 0) != 0);
        this.myDeferredInterceptorBroadcasts = ArrayListMultimap.create();
        this.myDeferredInterceptorBroadcastPointcuts = EnumSet.of(thePointcuts[0], thePointcuts);
    }

    public boolean isAcceptingDeferredInterceptorBroadcasts() {
        return this.myDeferredInterceptorBroadcasts != null;
    }

    public boolean isAcceptingDeferredInterceptorBroadcasts(Pointcut thePointcut) {
        return this.myDeferredInterceptorBroadcasts != null && this.myDeferredInterceptorBroadcastPointcuts.contains(thePointcut);
    }

    public ListMultimap<Pointcut, HookParams> endAcceptingDeferredInterceptorBroadcasts() {
        Validate.isTrue((boolean)this.isAcceptingDeferredInterceptorBroadcasts());
        ListMultimap<Pointcut, HookParams> retVal = this.myDeferredInterceptorBroadcasts;
        this.myDeferredInterceptorBroadcasts = null;
        this.myDeferredInterceptorBroadcastPointcuts = null;
        return retVal;
    }

    public void addDeferredInterceptorBroadcast(Pointcut thePointcut, HookParams theHookParams) {
        Validate.isTrue((boolean)this.isAcceptingDeferredInterceptorBroadcasts(thePointcut));
        this.myIsPointcutDeferred = true;
        this.myDeferredInterceptorBroadcasts.put(thePointcut, theHookParams);
    }

    public InterceptorInvocationTimingEnum getInvocationTiming(Pointcut thePointcut) {
        if (this.myDeferredInterceptorBroadcasts == null) {
            return InterceptorInvocationTimingEnum.ACTIVE;
        }
        Collection hookParams = this.myDeferredInterceptorBroadcasts.get((Object)thePointcut);
        return hookParams == null ? InterceptorInvocationTimingEnum.ACTIVE : InterceptorInvocationTimingEnum.DEFERRED;
    }

    public void deferredBroadcastProcessingFinished() {
        this.myIsPointcutDeferred = false;
    }
}

