/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class QualifiedParamList
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private String myQualifier;

    public QualifiedParamList() {
    }

    public QualifiedParamList(int theCapacity) {
        super(theCapacity);
    }

    public QualifiedParamList(IQueryParameterOr<?> theNextOr, FhirContext theContext) {
        for (IQueryParameterType next : theNextOr.getValuesAsQueryTokens()) {
            if (this.myQualifier == null) {
                this.myQualifier = next.getQueryParameterQualifier();
            }
            this.add(next.getValueAsQueryToken(theContext));
        }
    }

    public String getQualifier() {
        return this.myQualifier;
    }

    public void setQualifier(String theQualifier) {
        this.myQualifier = theQualifier;
    }

    public static QualifiedParamList singleton(String theParamValue) {
        return QualifiedParamList.singleton(null, theParamValue);
    }

    public static QualifiedParamList singleton(String theQualifier, String theParamValue) {
        QualifiedParamList retVal = new QualifiedParamList(1);
        retVal.setQualifier(theQualifier);
        retVal.add(theParamValue);
        return retVal;
    }

    public static QualifiedParamList splitQueryStringByCommasIgnoreEscape(String theQualifier, String theParams) {
        QualifiedParamList retVal = new QualifiedParamList();
        retVal.setQualifier(theQualifier);
        StringTokenizer tok = new StringTokenizer(theParams, ",", true);
        String prev = null;
        while (tok.hasMoreElements()) {
            String existing;
            int idx;
            String str = tok.nextToken();
            if (StringUtils.isBlank((CharSequence)str)) {
                prev = null;
                continue;
            }
            if (str.equals(",")) {
                if (QualifiedParamList.countTrailingSlashes(prev) % 2 == 1) {
                    idx = retVal.size() - 1;
                    existing = (String)retVal.get(idx);
                    prev = existing.substring(0, existing.length() - 1) + ',';
                    retVal.set(idx, prev);
                    continue;
                }
                prev = null;
                continue;
            }
            if (prev != null && prev.length() > 0 && prev.charAt(prev.length() - 1) == ',') {
                idx = retVal.size() - 1;
                existing = (String)retVal.get(idx);
                prev = existing + str;
                retVal.set(idx, prev);
                continue;
            }
            retVal.add(str);
            prev = str;
        }
        if (retVal.size() == 0) {
            retVal.add("");
        }
        return retVal;
    }

    private static int countTrailingSlashes(String theString) {
        char nextChar;
        if (theString == null) {
            return 0;
        }
        int retVal = 0;
        for (int i2 = theString.length() - 1; i2 >= 0 && (nextChar = theString.charAt(i2)) == '\\'; --i2) {
            ++retVal;
        }
        return retVal;
    }
}

