/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.importer.div.importers.GenericImporter;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericImporterBlatt
extends Composite {
    static final String FILENAME_KEY = "ImporterPage/" + GenericImporter.TITLE + "/filename";
    static final String LASTFIELDS_KEY = "ImporterPage/" + GenericImporter.TITLE + "/lastfields";
    static final String[] METHODS = new String[]{"XLS"};
    private static final int XLS = 0;
    int method = 0;
    String filename = "";
    Label lbFileName;
    Combo cbMethods;
    private Logger log = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    public GenericImporterBlatt(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this, 0).setText(Messages.Core_FileType);
        new Label((Composite)this, 0).setText(Messages.Core_File);
        this.cbMethods = new Combo((Composite)this, 4);
        this.cbMethods.setItems(METHODS);
        this.cbMethods.select(0);
        this.cbMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GenericImporterBlatt.this.method = GenericImporterBlatt.this.cbMethods.getSelectionIndex();
            }
        });
        Button bLoad = new Button((Composite)this, 8);
        bLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(GenericImporterBlatt.this.getShell(), 4096);
                String file = fd.open();
                GenericImporterBlatt.this.lbFileName.setText(StringTool.isNothing((Object)file) ? "" : file);
                GenericImporterBlatt.this.filename = GenericImporterBlatt.this.lbFileName.getText();
                CoreHub.localCfg.set(FILENAME_KEY, GenericImporterBlatt.this.filename);
            }
        });
        bLoad.setText(Messages.Core_Select_File);
        this.lbFileName = new Label((Composite)this, 0);
        this.lbFileName.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
        String file = CoreHub.localCfg.get(FILENAME_KEY, "");
        if (!StringTool.isNothing((Object)file)) {
            this.filename = file;
            this.lbFileName.setText(file);
        } else {
            this.filename = "";
            this.lbFileName.setText(Messages.Core_Please_Select_Type_and_File);
        }
    }

    public boolean doImport() {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GenericImporterWizard wizard = new GenericImporterWizard(GenericImporterBlatt.this.method, GenericImporterBlatt.this.filename);
                WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard){
                    {
                        int style = this.getShellStyle();
                        this.setShellStyle(style | 0x400);
                    }
                };
                dlg.open();
            }
        });
        return true;
    }

    class GenericImporterWizard
    extends Wizard {
        private int method;
        private String filename;
        MappingPage mappingPage;
        SyncPage syncPage;
        ExcelWrapper excel;
        PersistentObject template;

        GenericImporterWizard(int method, String filename) {
            this.method = method;
            this.filename = filename;
            this.mappingPage = new MappingPage();
            this.syncPage = new SyncPage();
            this.addPage((IWizardPage)this.mappingPage);
            this.addPage((IWizardPage)this.syncPage);
            this.setWindowTitle(Messages.GenericImporterBlatt_GeneralFileImport);
            this.initInput();
        }

        public boolean performFinish() {
            return true;
        }

        public boolean performCancel() {
            return this.performFinish();
        }

        private void initInput() {
            this.excel = null;
            if (!StringTool.isNothing((Object)this.filename) && this.method == 0) {
                this.excel = new ExcelWrapper();
                if (!this.excel.load(this.filename, 0)) {
                    this.excel = null;
                }
            }
        }

        class Field {
            String name;
            boolean isKey;

            Field(String name) {
                this(name, false);
            }

            Field(String name, boolean isKey) {
                this.name = name;
                this.isKey = isKey;
            }

            public String toString() {
                return this.name;
            }

            public boolean equals(Object o) {
                if (o instanceof Field) {
                    Field other = (Field)o;
                    if (other.name.equals(this.name) && other.isKey == this.isKey) {
                        return true;
                    }
                }
                return false;
            }
        }

        class KeyFields {
            String inputName;
            String dbName;

            KeyFields(String inputName, String dbName) {
                this.inputName = inputName;
                this.dbName = dbName;
            }
        }

        class MappingPage
        extends WizardPage {
            private ComboViewer typesViewer;
            private ComboViewer inputAvailableFieldsViewer;
            private TableViewer inputChosenFieldsViewer;
            private ComboViewer dbAvailableFieldsViewer;
            private TableViewer dbChosenFieldsViewer;
            private List<Field> inputAvailableFields;
            private List<Field> dbAvailableFields;
            private List<Field> inputChosenFields;
            private List<Field> dbChosenFields;
            private HashMap<String, Integer> inputFieldIndices;

            MappingPage() {
                super("Mapping", "Mapping", null);
                this.inputChosenFields = new ArrayList<Field>();
                this.dbChosenFields = new ArrayList<Field>();
                this.inputFieldIndices = new HashMap();
                String description = String.valueOf(Messages.GenericImporterBlatt_PleaseSelectType) + Messages.GenericImporterBlatt_LowerFieldSelectedAutoamtcally + Messages.GenericImporterBlatt_ChangeIfNeeded;
                this.setDescription(description);
            }

            private void setType() {
                PersistentObject type = this.getSelectedType();
                this.clearAllFields();
                this.loadAvailableFields();
                this.setChosenFields();
                this.inputAvailableFieldsViewer.setInput(this.inputAvailableFields);
                if (this.inputAvailableFields.size() > 0) {
                    this.inputAvailableFieldsViewer.setSelection((ISelection)new StructuredSelection(this.inputAvailableFieldsViewer.getElementAt(0)));
                }
                this.inputChosenFieldsViewer.setInput(this.inputChosenFields);
                this.dbAvailableFieldsViewer.setInput(this.dbAvailableFields);
                if (this.dbAvailableFields.size() > 0) {
                    this.dbAvailableFieldsViewer.setSelection((ISelection)new StructuredSelection(this.dbAvailableFieldsViewer.getElementAt(0)));
                }
                this.dbChosenFieldsViewer.setInput(this.dbChosenFields);
                this.checkCompleteness();
            }

            private void clearAllFields() {
                if (this.inputAvailableFields != null) {
                    this.inputAvailableFields.clear();
                }
                if (this.inputChosenFields != null) {
                    this.inputChosenFields.clear();
                }
                if (this.inputFieldIndices != null) {
                    this.inputFieldIndices.clear();
                }
                if (this.dbAvailableFields != null) {
                    this.dbAvailableFields.clear();
                }
                if (this.dbChosenFields != null) {
                    this.dbChosenFields.clear();
                }
            }

            private void loadAvailableFields() {
                int firstRowIndex;
                List excelFields;
                PersistentObject type = this.getSelectedType();
                StringBuilder excelFieldsStrings = new StringBuilder("");
                this.inputAvailableFields = new ArrayList<Field>();
                if (type != null && GenericImporterWizard.this.excel != null && (excelFields = GenericImporterWizard.this.excel.getRow(firstRowIndex = GenericImporterWizard.this.excel.getFirstRow())) != null) {
                    int i = 0;
                    while (i < excelFields.size()) {
                        String name = (String)excelFields.get(i);
                        if (excelFieldsStrings.toString().length() > 1) {
                            excelFieldsStrings.append(",");
                        }
                        excelFieldsStrings.append(name);
                        this.inputAvailableFields.add(new Field(name));
                        this.inputFieldIndices.put(name, new Integer(i));
                        ++i;
                    }
                }
                this.dbAvailableFields = this.getAvailableFields(this.getSelectedType());
                if (type == null) {
                    return;
                }
                StringBuilder fields = new StringBuilder("");
                int i = 0;
                while (i < this.dbAvailableFields.size()) {
                    if (fields.toString().length() >= 1) {
                        fields.append(",");
                    }
                    fields.append(this.dbAvailableFields.get((int)i).name);
                    ++i;
                }
                ((GenericImporterWizard)GenericImporterWizard.this).GenericImporterBlatt.this.log.info(String.format("dbAvailableFields for %s", type.getClass().getSimpleName()));
                ((GenericImporterWizard)GenericImporterWizard.this).GenericImporterBlatt.this.log.info(String.format("  are: %s", fields.toString()));
                ((GenericImporterWizard)GenericImporterWizard.this).GenericImporterBlatt.this.log.info("excel: " + excelFieldsStrings.toString());
            }

            private void setChosenFields() {
                if (this.inputAvailableFields != null && this.dbAvailableFields != null) {
                    ArrayList<Field> inputFields = new ArrayList<Field>();
                    ArrayList<Field> dbFields = new ArrayList<Field>();
                    for (Field inputField : this.inputAvailableFields) {
                        Field dbField = this.findDbField(inputField);
                        if (dbField == null) continue;
                        inputFields.add(inputField);
                        dbFields.add(dbField);
                        inputField.isKey = dbField.isKey;
                    }
                    this.inputAvailableFields.removeAll(inputFields);
                    this.inputChosenFields.addAll(inputFields);
                    this.dbAvailableFields.removeAll(dbFields);
                    this.dbChosenFields.addAll(dbFields);
                    this.inputAvailableFieldsViewer.refresh();
                    this.inputChosenFieldsViewer.refresh();
                    this.dbAvailableFieldsViewer.refresh();
                    this.dbChosenFieldsViewer.refresh();
                    this.checkCompleteness();
                }
            }

            private Field findDbField(Field excelField) {
                for (Field dbField : this.dbAvailableFields) {
                    if (!dbField.name.equals(excelField.name)) continue;
                    return dbField;
                }
                return null;
            }

            private void checkCompleteness() {
                boolean complete = false;
                PersistentObject type = this.getSelectedType();
                if (type != null) {
                    int inputSize = this.inputChosenFields.size();
                    int dbSize = this.dbChosenFields.size();
                    if (inputSize > 0 && dbSize > 0 && inputSize == dbSize) {
                        complete = true;
                        boolean hasKeys = false;
                        int i = 0;
                        while (i < inputSize) {
                            Field inputField = this.inputChosenFields.get(i);
                            Field dbField = this.dbChosenFields.get(i);
                            if (inputField.isKey) {
                                hasKeys = true;
                            }
                            if (inputField.isKey != dbField.isKey) {
                                complete = false;
                                break;
                            }
                            ++i;
                        }
                        complete &= hasKeys;
                    }
                }
                this.setPageComplete(complete);
            }

            private List<PersistentObject> getTypes() {
                ArrayList<PersistentObject> types = new ArrayList<PersistentObject>();
                PersistentObjectFactory factory = new PersistentObjectFactory();
                types.add(factory.createTemplate(Person.class));
                types.add(factory.createTemplate(Organisation.class));
                types.add(factory.createTemplate(Artikel.class));
                return types;
            }

            private List<Field> getAvailableFields(PersistentObject template) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (template instanceof Person) {
                    fields.add(new Field("Name", true));
                    fields.add(new Field("Vorname", true));
                    fields.add(new Field("Zusatz"));
                    fields.add(new Field("Geburtsdatum", true));
                    fields.add(new Field("Geschlecht"));
                    fields.add(new Field("Strasse"));
                    fields.add(new Field("Plz"));
                    fields.add(new Field("Ort"));
                    fields.add(new Field("Land"));
                    fields.add(new Field("Telefon1"));
                    fields.add(new Field("Telefon2"));
                    fields.add(new Field("NatelNr"));
                    fields.add(new Field("Fax"));
                    fields.add(new Field("E-Mail"));
                    fields.add(new Field("Website"));
                    fields.add(new Field("Titel"));
                    fields.add(new Field("Kuerzel"));
                    fields.add(new Field("Bemerkung"));
                } else if (template instanceof Organisation) {
                    fields.add(new Field("Bezeichnung1"));
                    fields.add(new Field("Zusatz1"));
                    fields.add(new Field("Ansprechperson"));
                    fields.add(new Field("Tel. direkt"));
                    fields.add(new Field("Kuerzel"));
                    fields.add(new Field("Strasse"));
                    fields.add(new Field("Plz"));
                    fields.add(new Field("Ort"));
                    fields.add(new Field("Land"));
                    fields.add(new Field("Telefon1"));
                    fields.add(new Field("Telefon2"));
                    fields.add(new Field("E-Mail"));
                    fields.add(new Field("Website"));
                    fields.add(new Field("Fax"));
                    fields.add(new Field("Bemerkung"));
                } else if (template instanceof Artikel) {
                    fields.add(new Field("SubID", true));
                    fields.add(new Field("Name"));
                    fields.add(new Field("Typ"));
                    fields.add(new Field("Codeclass"));
                }
                return fields;
            }

            private PersistentObject getSelectedType() {
                Object obj;
                IStructuredSelection sel = (IStructuredSelection)this.typesViewer.getSelection();
                if (sel != null && (obj = sel.getFirstElement()) instanceof PersistentObject) {
                    return (PersistentObject)obj;
                }
                return null;
            }

            private Field getViewerSelection(StructuredViewer viewer) {
                IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof Field) {
                    return (Field)obj;
                }
                return null;
            }

            private void addInputField() {
                Field field = this.getViewerSelection((StructuredViewer)this.inputAvailableFieldsViewer);
                this.inputAvailableFields.remove(field);
                this.inputChosenFields.add(field);
                this.inputAvailableFieldsViewer.refresh();
                this.inputChosenFieldsViewer.refresh();
                this.inputChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                this.checkCompleteness();
            }

            private void delInputField() {
                Field field = this.getViewerSelection((StructuredViewer)this.inputChosenFieldsViewer);
                field.isKey = false;
                this.inputChosenFields.remove(field);
                this.inputAvailableFields.add(field);
                this.inputAvailableFieldsViewer.refresh();
                this.inputChosenFieldsViewer.refresh();
                this.checkCompleteness();
            }

            private void upInputField() {
                Field field = this.getViewerSelection((StructuredViewer)this.inputChosenFieldsViewer);
                int index = this.inputChosenFields.indexOf(field);
                if (index > 0) {
                    int newIndex = index - 1;
                    Field other = this.inputChosenFields.get(newIndex);
                    this.inputChosenFields.set(newIndex, field);
                    this.inputChosenFields.set(index, other);
                    this.inputChosenFieldsViewer.refresh();
                    this.inputChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                }
                this.checkCompleteness();
            }

            private void downInputField() {
                Field field = this.getViewerSelection((StructuredViewer)this.inputChosenFieldsViewer);
                int index = this.inputChosenFields.indexOf(field);
                if (index < this.inputChosenFields.size() - 1) {
                    int newIndex = index + 1;
                    Field other = this.inputChosenFields.get(newIndex);
                    this.inputChosenFields.set(newIndex, field);
                    this.inputChosenFields.set(index, other);
                    this.inputChosenFieldsViewer.refresh();
                    this.inputChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                }
                this.checkCompleteness();
            }

            private void keyInputField() {
                int index;
                Field other;
                Field field = this.getViewerSelection((StructuredViewer)this.inputChosenFieldsViewer);
                boolean bl = field.isKey = !field.isKey;
                if (this.inputChosenFields.size() == this.dbChosenFields.size() && (other = this.dbChosenFields.get(index = this.inputChosenFields.indexOf(field))) != null) {
                    other.isKey = field.isKey;
                }
                this.inputChosenFieldsViewer.refresh();
                this.dbChosenFieldsViewer.refresh();
                this.checkCompleteness();
            }

            private void addDbField() {
                Field field = this.getViewerSelection((StructuredViewer)this.dbAvailableFieldsViewer);
                this.dbAvailableFields.remove(field);
                this.dbChosenFields.add(field);
                this.dbAvailableFieldsViewer.refresh();
                this.dbChosenFieldsViewer.refresh();
                this.dbChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                this.checkCompleteness();
            }

            private void delDbField() {
                Field field = this.getViewerSelection((StructuredViewer)this.dbChosenFieldsViewer);
                field.isKey = false;
                this.dbChosenFields.remove(field);
                this.dbAvailableFields.add(field);
                this.dbAvailableFieldsViewer.refresh();
                this.dbChosenFieldsViewer.refresh();
                this.checkCompleteness();
            }

            private void upDbField() {
                Field field = this.getViewerSelection((StructuredViewer)this.dbChosenFieldsViewer);
                int index = this.dbChosenFields.indexOf(field);
                if (index > 0) {
                    int newIndex = index - 1;
                    Field other = this.dbChosenFields.get(newIndex);
                    this.dbChosenFields.set(newIndex, field);
                    this.dbChosenFields.set(index, other);
                    this.dbChosenFieldsViewer.refresh();
                    this.dbChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                }
                this.checkCompleteness();
            }

            private void downDbField() {
                Field field = this.getViewerSelection((StructuredViewer)this.dbChosenFieldsViewer);
                int index = this.dbChosenFields.indexOf(field);
                if (index < this.dbChosenFields.size() - 1) {
                    int newIndex = index + 1;
                    Field other = this.dbChosenFields.get(newIndex);
                    this.dbChosenFields.set(newIndex, field);
                    this.dbChosenFields.set(index, other);
                    this.dbChosenFieldsViewer.refresh();
                    this.dbChosenFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)field));
                }
                this.checkCompleteness();
            }

            private void keyDbField() {
                int index;
                Field other;
                Field field = this.getViewerSelection((StructuredViewer)this.dbChosenFieldsViewer);
                boolean bl = field.isKey = !field.isKey;
                if (this.inputChosenFields.size() == this.dbChosenFields.size() && (other = this.inputChosenFields.get(index = this.dbChosenFields.indexOf(field))) != null) {
                    other.isKey = field.isKey;
                }
                this.inputChosenFieldsViewer.refresh();
                this.dbChosenFieldsViewer.refresh();
                this.checkCompleteness();
            }

            public void createControl(Composite parent) {
                ArrayContentProvider arrayContentProvider = new ArrayContentProvider();
                LabelProvider typeLabelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof PersistentObject) {
                            return ((PersistentObject)element).getClass().getSimpleName();
                        }
                        return element.toString();
                    }
                };
                LabelProvider fieldLabelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        String text = null;
                        if (element instanceof Field) {
                            Field field = (Field)element;
                            text = field.isKey ? String.valueOf(field.toString()) + "*" : field.toString();
                        }
                        return text;
                    }
                };
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(1, false));
                Composite topArea = new Composite(composite, 0);
                topArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                topArea.setLayout((Layout)new GridLayout(2, false));
                Label label = new Label(topArea, 0);
                label.setText("Typ:");
                this.typesViewer = new ComboViewer(topArea, 12);
                this.typesViewer.setContentProvider((IContentProvider)arrayContentProvider);
                this.typesViewer.setLabelProvider((IBaseLabelProvider)typeLabelProvider);
                ArrayList<String> types = new ArrayList<String>();
                types.add(Messages.GenericImporterBlatt_PleaseSelect);
                types.addAll(this.getTypes());
                this.typesViewer.setInput(types);
                this.typesViewer.setSelection((ISelection)new StructuredSelection(this.typesViewer.getElementAt(0)));
                this.typesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        MappingPage.this.setType();
                    }
                });
                Composite bottomArea = new Composite(composite, 0);
                bottomArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
                bottomArea.setLayout((Layout)new GridLayout(2, true));
                label = new Label(bottomArea, 0);
                label.setText(Messages.GenericImporterBlatt_FieldsExcel);
                label = new Label(bottomArea, 0);
                label.setText(Messages.GenericImporterBlatt_FieldsElexis);
                Composite leftArea = new Composite(bottomArea, 0);
                leftArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
                leftArea.setLayout((Layout)new FormLayout());
                Button addButton = new Button(leftArea, 8);
                addButton.setText("+");
                addButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.addInputField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button delButton = new Button(leftArea, 8);
                delButton.setText("-");
                delButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.delInputField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button upButton = new Button(leftArea, 8);
                upButton.setText("^");
                upButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.upInputField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button downButton = new Button(leftArea, 8);
                downButton.setText("v");
                downButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.downInputField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button keyButton = new Button(leftArea, 8);
                keyButton.setText("K");
                keyButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.keyInputField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.inputAvailableFieldsViewer = new ComboViewer(leftArea, 12);
                Control availableFieldsControl = this.inputAvailableFieldsViewer.getControl();
                this.inputChosenFieldsViewer = new TableViewer(leftArea, 2048);
                Control chosenFieldsControl = this.inputChosenFieldsViewer.getControl();
                FormData fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment(availableFieldsControl, 0, 0x1000000);
                addButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.top = new FormAttachment(0);
                fd.left = new FormAttachment((Control)addButton);
                fd.right = new FormAttachment(100);
                availableFieldsControl.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment(availableFieldsControl, 5);
                delButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)delButton, 5);
                upButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)upButton);
                downButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)downButton);
                keyButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(availableFieldsControl, 0, 16384);
                fd.top = new FormAttachment(availableFieldsControl, 5);
                fd.right = new FormAttachment(100);
                fd.bottom = new FormAttachment(100);
                chosenFieldsControl.setLayoutData((Object)fd);
                Composite rightArea = new Composite(bottomArea, 0);
                rightArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
                rightArea.setLayout((Layout)new FormLayout());
                addButton = new Button(rightArea, 8);
                addButton.setText("+");
                addButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.addDbField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                delButton = new Button(rightArea, 8);
                delButton.setText("-");
                delButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.delDbField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                upButton = new Button(rightArea, 8);
                upButton.setText("^");
                upButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.upDbField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                downButton = new Button(rightArea, 8);
                downButton.setText("v");
                downButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.downDbField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                keyButton = new Button(rightArea, 8);
                keyButton.setText("K");
                keyButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MappingPage.this.keyDbField();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.dbAvailableFieldsViewer = new ComboViewer(rightArea, 12);
                availableFieldsControl = this.dbAvailableFieldsViewer.getControl();
                this.dbChosenFieldsViewer = new TableViewer(rightArea, 2048);
                chosenFieldsControl = this.dbChosenFieldsViewer.getControl();
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment(availableFieldsControl, 0, 0x1000000);
                addButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.top = new FormAttachment(0);
                fd.left = new FormAttachment((Control)addButton);
                fd.right = new FormAttachment(100);
                availableFieldsControl.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment(availableFieldsControl, 5);
                delButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)delButton, 5);
                upButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)upButton);
                downButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(0);
                fd.top = new FormAttachment((Control)downButton);
                keyButton.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment(availableFieldsControl, 0, 16384);
                fd.top = new FormAttachment(availableFieldsControl, 5);
                fd.right = new FormAttachment(100);
                fd.bottom = new FormAttachment(100);
                chosenFieldsControl.setLayoutData((Object)fd);
                this.inputAvailableFieldsViewer.setContentProvider((IContentProvider)arrayContentProvider);
                this.inputAvailableFieldsViewer.setLabelProvider((IBaseLabelProvider)fieldLabelProvider);
                this.inputChosenFieldsViewer.setContentProvider((IContentProvider)arrayContentProvider);
                this.inputChosenFieldsViewer.setLabelProvider((IBaseLabelProvider)fieldLabelProvider);
                this.dbAvailableFieldsViewer.setContentProvider((IContentProvider)arrayContentProvider);
                this.dbAvailableFieldsViewer.setLabelProvider((IBaseLabelProvider)fieldLabelProvider);
                this.dbChosenFieldsViewer.setContentProvider((IContentProvider)arrayContentProvider);
                this.dbChosenFieldsViewer.setLabelProvider((IBaseLabelProvider)fieldLabelProvider);
                this.setType();
                this.setControl((Control)composite);
            }
        }

        class SyncPage
        extends WizardPage {
            private static final String PLUGIN_ID = "ch.elexis.importer.div";
            private static final int IMAGE_INPUT_ONLY = 1;
            private static final int IMAGE_DB_ONLY = 2;
            private static final int IMAGE_DIFF = 3;
            private static final int IMAGE_EQUAL = 4;
            private static final int IMAGE_COLUMN_WIDTH = 24;
            private TableViewer mainViewer;
            private TableViewer diff1Viewer;
            private TableViewer diff2Viewer;
            private Button importNewButton;
            private Button updateButton;
            private List<SyncElement> syncElements;
            private SyncElement currentSyncElement;

            SyncPage() {
                super("Synchronize", "Synchronize", null);
                this.syncElements = new ArrayList<SyncElement>();
                this.currentSyncElement = null;
                this.setDescription(Messages.GenericImporterBlatt_MatchData);
            }

            private Image getImage(int id) {
                switch (id) {
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                    case 2: {
                        return Images.IMG_DATABASE.getImage();
                    }
                    case 3: {
                        return Images.IMG_CONFLICT.getImage();
                    }
                    case 4: {
                        return Images.IMG_OK.getImage();
                    }
                }
                return null;
            }

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(1, false));
                Button refreshButton = new Button(composite, 8);
                refreshButton.setText(Messages.Core_Update);
                refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SyncPage.this.refresh();
                    }
                });
                this.mainViewer = new TableViewer(composite, 67586);
                Control mainControl = this.mainViewer.getControl();
                mainControl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
                this.mainViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        SyncPage.this.setSyncElement();
                    }
                });
                this.mainViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                    public Image getColumnImage(Object element, int columnIndex) {
                        Object image = null;
                        if (element instanceof SyncElement) {
                            SyncElement syncElement = (SyncElement)element;
                            if (columnIndex == 0) {
                                switch (syncElement.state) {
                                    case 3: {
                                        image = SyncPage.this.getImage(1);
                                        break;
                                    }
                                    case 4: {
                                        image = SyncPage.this.getImage(2);
                                        break;
                                    }
                                    case 2: {
                                        image = SyncPage.this.getImage(3);
                                        break;
                                    }
                                    case 1: {
                                        image = SyncPage.this.getImage(4);
                                    }
                                }
                            } else if (syncElement.state == 2) {
                                int fieldIndex = columnIndex - 1;
                                HashMap<String, String> inputObject = syncElement.inputObject;
                                PersistentObject dbObject = syncElement.dbObject;
                                String inputKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                String dbKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                String inputValue = PersistentObject.checkNull((Object)inputObject.get(inputKey)).trim();
                                String dbValue = PersistentObject.checkNull((Object)dbObject.get(dbKey)).trim();
                                image = inputValue != null ? (inputValue.equals(dbValue) ? null : SyncPage.this.getImage(3)) : (dbValue != null ? SyncPage.this.getImage(3) : null);
                            }
                        }
                        return image;
                    }

                    public String getColumnText(Object element, int columnIndex) {
                        String text = "";
                        if (columnIndex > 0 && element instanceof SyncElement) {
                            int fieldIndex = columnIndex - 1;
                            SyncElement syncElement = (SyncElement)element;
                            switch (syncElement.state) {
                                case 3: {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    text = inputObject.get(key);
                                    break;
                                }
                                case 4: {
                                    PersistentObject dbObject = syncElement.dbObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                    text = dbObject.get(key);
                                    break;
                                }
                                case 2: {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    PersistentObject dbObject = syncElement.dbObject;
                                    String inputKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    String dbKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                    String inputValue = PersistentObject.checkNull((Object)inputObject.get(inputKey)).trim();
                                    String dbValue = PersistentObject.checkNull((Object)dbObject.get(dbKey)).trim();
                                    if (inputValue != null) {
                                        if (inputValue.equals(dbValue)) {
                                            text = inputValue;
                                            break;
                                        }
                                        if (dbValue != null) {
                                            text = String.valueOf(inputValue) + "/" + dbValue;
                                            break;
                                        }
                                        text = String.valueOf(inputValue) + "/";
                                        break;
                                    }
                                    if (dbValue != null) {
                                        text = "/" + dbValue;
                                        break;
                                    }
                                    text = "/";
                                    break;
                                }
                                case 1: {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    text = inputObject.get(key);
                                }
                            }
                        }
                        return text;
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                });
                this.mainViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return SyncPage.this.syncElements.toArray();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                this.mainViewer.setInput((Object)this);
                this.diff1Viewer = new TableViewer(composite, 2048);
                Control diff1Control = this.diff1Viewer.getControl();
                GridData gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
                gd.heightHint = this.diff1Viewer.getTable().getItemHeight();
                diff1Control.setLayoutData((Object)gd);
                this.diff2Viewer = new TableViewer(composite, 2048);
                Control diff2Control = this.diff2Viewer.getControl();
                gd.heightHint = this.diff2Viewer.getTable().getItemHeight();
                diff2Control.setLayoutData((Object)gd);
                this.mainViewer.getTable().setHeaderVisible(true);
                this.mainViewer.getTable().setLinesVisible(true);
                this.diff1Viewer.getTable().setLinesVisible(true);
                this.diff2Viewer.getTable().setLinesVisible(true);
                DiffViewerContentProvider dvcp = new DiffViewerContentProvider();
                this.diff1Viewer.setContentProvider((IContentProvider)dvcp);
                this.diff2Viewer.setContentProvider((IContentProvider)dvcp);
                this.diff1Viewer.setLabelProvider((IBaseLabelProvider)new DiffViewerLabelProvider(1));
                this.diff2Viewer.setLabelProvider((IBaseLabelProvider)new DiffViewerLabelProvider(2));
                new Label(composite, 0).setText(Messages.GenericImporterBlatt_ImportAllDataNew);
                this.importNewButton = new Button(composite, 8);
                this.importNewButton.setText(Messages.GenericImporterBlatt_ImportAllDataNewCaption);
                this.importNewButton.setImage(this.getImage(1));
                this.importNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SyncPage.this.importNew();
                    }
                });
                this.importNewButton.setEnabled(true);
                new Label(composite, 0).setText(Messages.GenericImporterBlatt_UpdateSelectedData);
                this.updateButton = new Button(composite, 8);
                this.updateButton.setText(Messages.GenericImporterBlatt_ImportAllValues);
                this.updateButton.setImage(this.getImage(3));
                this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SyncPage.this.updateSelected();
                    }
                });
                this.updateButton.setEnabled(false);
                this.setControl((Control)composite);
            }

            private void refresh() {
                this.createColumns();
                this.sync();
            }

            private void createColumns() {
                this.createColumns(this.mainViewer);
                this.createColumns(this.diff1Viewer);
                this.createColumns(this.diff2Viewer);
            }

            private void createColumns(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn[] oldColumns = table.getColumns();
                if (oldColumns != null) {
                    TableColumn[] tableColumnArray = oldColumns;
                    int n = oldColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        column.dispose();
                        ++n2;
                    }
                }
                TableColumn imageColumn = new TableColumn(table, 16384);
                imageColumn.setWidth(24);
                imageColumn.setText("");
                if (GenericImporterWizard.this.mappingPage.isPageComplete()) {
                    int columnsCount = GenericImporterWizard.this.mappingPage.inputChosenFields.size();
                    int columnSize = (table.getBounds().width - imageColumn.getWidth()) / columnsCount;
                    TableColumn[] columns = new TableColumn[columnsCount];
                    int i = 0;
                    while (i < columnsCount) {
                        String dbName;
                        columns[i] = new TableColumn(table, 16384);
                        columns[i].setWidth(columnSize);
                        String inputName = GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)i).name;
                        String name = dbName = GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)i).name;
                        if (!inputName.equals(dbName)) {
                            name = String.valueOf(inputName) + "/" + name;
                        }
                        columns[i].setText(name);
                        ++i;
                    }
                    if (columnsCount > 0) {
                        int lastIndex = columnsCount - 1;
                        columns[lastIndex].setWidth(columns[lastIndex].getWidth() - 5);
                    }
                }
            }

            private void sync() {
                this.syncElements.clear();
                HashMap<String, String> dbFieldNames = new HashMap<String, String>();
                int i = 0;
                while (i < GenericImporterWizard.this.mappingPage.inputChosenFields.size()) {
                    String inputName = GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)i).name;
                    String dbName = GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)i).name;
                    dbFieldNames.put(inputName, dbName);
                    ++i;
                }
                ArrayList<HashMap> inputObjects = new ArrayList<HashMap>();
                int i2 = GenericImporterWizard.this.excel.getFirstRow() + 1;
                while (i2 <= GenericImporterWizard.this.excel.getLastRow()) {
                    List row = GenericImporterWizard.this.excel.getRow(i2);
                    if (row != null) {
                        HashMap rowMap = new HashMap();
                        for (Field field : GenericImporterWizard.this.mappingPage.inputChosenFields) {
                            int index = GenericImporterWizard.this.mappingPage.inputFieldIndices.get(field.name);
                            String key = field.name;
                            String value = row.size() > index ? ((String)row.get(index)).trim() : "";
                            rowMap.put(key, value);
                        }
                        inputObjects.add(rowMap);
                    }
                    ++i2;
                }
                ArrayList<KeyFields> keyFields = new ArrayList<KeyFields>();
                int i3 = 0;
                while (i3 < GenericImporterWizard.this.mappingPage.inputChosenFields.size()) {
                    Field inputField = GenericImporterWizard.this.mappingPage.inputChosenFields.get(i3);
                    Field dbField = GenericImporterWizard.this.mappingPage.dbChosenFields.get(i3);
                    if (inputField.isKey && dbField.isKey) {
                        keyFields.add(new KeyFields(inputField.name, dbField.name));
                    }
                    ++i3;
                }
                PersistentObject template = GenericImporterWizard.this.mappingPage.getSelectedType();
                for (HashMap rowMap : inputObjects) {
                    PersistentObject dbObject = this.findDbObject(rowMap, keyFields, template.getClass());
                    SyncElement syncElement = new SyncElement(rowMap, dbObject, dbFieldNames);
                    if (syncElement.state != 3 && syncElement.state != 2) continue;
                    this.syncElements.add(syncElement);
                }
                this.mainViewer.refresh();
                this.setSyncElement();
            }

            private PersistentObject findDbObject(HashMap<String, String> inputObject, List<KeyFields> keyFields, Class typ) {
                Query query = new Query(typ);
                for (KeyFields keyField : keyFields) {
                    String name = keyField.dbName;
                    String value = inputObject.get(keyField.inputName);
                    query.add(name, "=", value);
                }
                List dbObjects = query.execute();
                if (dbObjects != null && dbObjects.size() > 0) {
                    return (PersistentObject)dbObjects.get(0);
                }
                return null;
            }

            private void setSyncElement() {
                Object element;
                SyncElement UNKNOWN_SYNC_ELEMENT = new SyncElement();
                IStructuredSelection selection = (IStructuredSelection)this.mainViewer.getSelection();
                this.currentSyncElement = selection.size() == 0 ? null : (selection.size() == 1 ? ((element = selection.getFirstElement()) instanceof SyncElement ? (SyncElement)element : null) : UNKNOWN_SYNC_ELEMENT);
                this.diff1Viewer.setInput((Object)this.currentSyncElement);
                this.diff2Viewer.setInput((Object)this.currentSyncElement);
                this.updateButton.setEnabled(this.isSelectionUpdatable());
            }

            private boolean isSelectionUpdatable() {
                boolean updatable = false;
                IStructuredSelection selection = (IStructuredSelection)this.mainViewer.getSelection();
                if (selection.size() > 0) {
                    updatable = true;
                    for (Object element : selection.toList()) {
                        if (element instanceof SyncElement) {
                            SyncElement syncElement = (SyncElement)element;
                            if (syncElement != null && syncElement.state == 2) continue;
                            updatable = false;
                            continue;
                        }
                        updatable = false;
                    }
                }
                return updatable;
            }

            private void importNew() {
                ArrayList<SyncElement> imported = new ArrayList<SyncElement>();
                for (SyncElement syncElement : this.syncElements) {
                    HashMap<String, String> inputObject;
                    if (syncElement.state != 3 || (inputObject = syncElement.inputObject) == null) continue;
                    Class<?> typ = GenericImporterWizard.this.mappingPage.getSelectedType().getClass();
                    String[] fields = new String[GenericImporterWizard.this.mappingPage.dbChosenFields.size()];
                    int i = 0;
                    while (i < fields.length) {
                        fields[i] = GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)i).name;
                        ++i;
                    }
                    String[] values = new String[fields.length];
                    int i2 = 0;
                    while (i2 < fields.length) {
                        String key = GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)i2).name;
                        values[i2] = inputObject.get(key);
                        ++i2;
                    }
                    PersistentObject po = new PersistentObjectFactory().create(typ, fields, values);
                    ((GenericImporterWizard)GenericImporterWizard.this).GenericImporterBlatt.this.log.debug(String.format("Added %s %s", typ.getClass().getSimpleName(), po.getId()));
                    imported.add(syncElement);
                }
                this.syncElements.removeAll(imported);
                this.mainViewer.refresh();
                this.mainViewer.setSelection((ISelection)new StructuredSelection());
            }

            private void updateSelected() {
                IStructuredSelection selection = (IStructuredSelection)this.mainViewer.getSelection();
                for (Object element : selection.toList()) {
                    if (!(element instanceof SyncElement)) continue;
                    SyncElement syncElement = (SyncElement)element;
                    this.updateSyncElement(syncElement);
                }
                this.mainViewer.refresh();
                this.setSyncElement();
            }

            private void updateSyncElement(SyncElement syncElement) {
                if (syncElement == null || syncElement.state != 2) {
                    return;
                }
                HashMap<String, String> inputObject = syncElement.inputObject;
                PersistentObject dbObject = syncElement.dbObject;
                if (inputObject != null && dbObject != null) {
                    String[] fields = new String[GenericImporterWizard.this.mappingPage.dbChosenFields.size()];
                    int i = 0;
                    while (i < fields.length) {
                        fields[i] = GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)i).name;
                        ++i;
                    }
                    String[] values = new String[fields.length];
                    int i2 = 0;
                    while (i2 < fields.length) {
                        String key = GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)i2).name;
                        values[i2] = inputObject.get(key);
                        ++i2;
                    }
                    dbObject.set(fields, values);
                    this.syncElements.remove(syncElement);
                }
            }

            private class DiffViewerContentProvider
            implements IStructuredContentProvider {
                private DiffViewerContentProvider() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof SyncElement) {
                        return new Object[]{inputElement};
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            }

            private class DiffViewerLabelProvider
            implements ITableLabelProvider {
                static final int INPUT = 1;
                static final int DB = 2;
                private int type;

                public DiffViewerLabelProvider(int type) {
                    this.type = type;
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    Image image = null;
                    if (columnIndex > 0 && element instanceof SyncElement) {
                        int fieldIndex = columnIndex - 1;
                        SyncElement syncElement = (SyncElement)element;
                        switch (syncElement.state) {
                            case 2: {
                                HashMap<String, String> inputObject = syncElement.inputObject;
                                PersistentObject dbObject = syncElement.dbObject;
                                boolean equal = false;
                                if (inputObject != null && dbObject != null) {
                                    String dbValue;
                                    String inputKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    String dbKey = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                    String inputValue = inputObject.get(inputKey).trim();
                                    if (inputValue.equals(dbValue = dbObject.get(dbKey).trim())) {
                                        equal = true;
                                    }
                                }
                                if (equal) break;
                                image = SyncPage.this.getImage(3);
                            }
                        }
                    }
                    return image;
                }

                public String getColumnText(Object element, int columnIndex) {
                    String text = "";
                    if (columnIndex > 0 && element instanceof SyncElement) {
                        int fieldIndex = columnIndex - 1;
                        SyncElement syncElement = (SyncElement)element;
                        switch (syncElement.state) {
                            case 3: {
                                if (this.type == 1) {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    text = inputObject.get(key);
                                    break;
                                }
                                text = "";
                                break;
                            }
                            case 4: {
                                if (this.type == 2) {
                                    PersistentObject dbObject = syncElement.dbObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                    text = dbObject.get(key);
                                    break;
                                }
                                text = "";
                                break;
                            }
                            case 2: {
                                if (this.type == 1) {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    text = inputObject.get(key);
                                    break;
                                }
                                PersistentObject dbObject = syncElement.dbObject;
                                String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                text = dbObject.get(key);
                                break;
                            }
                            case 1: {
                                if (this.type == 1) {
                                    HashMap<String, String> inputObject = syncElement.inputObject;
                                    String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.inputChosenFields.get((int)fieldIndex).name;
                                    text = inputObject.get(key);
                                    break;
                                }
                                PersistentObject dbObject = syncElement.dbObject;
                                String key = ((SyncPage)SyncPage.this).GenericImporterWizard.this.mappingPage.dbChosenFields.get((int)fieldIndex).name;
                                text = dbObject.get(key);
                                break;
                            }
                            case 0: {
                                text = "?";
                            }
                        }
                    }
                    return text;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            }

            class SyncElement {
                static final int UNKNOWN = 0;
                static final int EQUAL = 1;
                static final int DIFF = 2;
                static final int INPUT_ONLY = 3;
                static final int DB_ONLY = 4;
                int state = 0;
                HashMap<String, String> inputObject;
                PersistentObject dbObject;
                HashMap<String, String> dbFieldNames;

                SyncElement(HashMap<String, String> inputObject, PersistentObject dbObject, HashMap<String, String> dbFieldNames) {
                    this.inputObject = inputObject;
                    this.dbObject = dbObject;
                    this.dbFieldNames = dbFieldNames;
                    this.sync();
                }

                SyncElement() {
                    this(null, null, null);
                }

                void sync() {
                    this.state = 0;
                    if (this.inputObject == null && this.dbObject == null) {
                        this.state = 0;
                        return;
                    }
                    if (this.dbObject == null) {
                        this.state = 3;
                        return;
                    }
                    if (this.inputObject == null) {
                        this.state = 4;
                        return;
                    }
                    boolean equal = true;
                    for (String inputName : this.inputObject.keySet()) {
                        String dbValue;
                        String dbName = this.dbFieldNames.get(inputName);
                        String inputValue = PersistentObject.checkNull((Object)this.inputObject.get(inputName)).trim();
                        if (inputValue.equals(dbValue = PersistentObject.checkNull((Object)this.dbObject.get(dbName)).trim())) continue;
                        equal = false;
                        break;
                    }
                    this.state = equal ? 1 : 2;
                }
            }
        }
    }
}

