/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.Person;
import ch.elexis.core.model.messages.Messages;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;

public class Patient
extends Person
implements IPatient {
    public Patient(Kontakt model) {
        super(model);
    }

    @Override
    public String getLabel() {
        return super.getLabel();
    }

    public String getDiagnosen() {
        return ((Kontakt)this.getEntity()).getDiagnosen();
    }

    public void setDiagnosen(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setDiagnosen(value);
    }

    public String getRisk() {
        return ((Kontakt)this.getEntity()).getRisk();
    }

    public void setRisk(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setRisk(value);
    }

    public String getFamilyAnamnese() {
        return ((Kontakt)this.getEntity()).getFamilyAnamnese();
    }

    public void setFamilyAnamnese(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setFamilyAnamnese(value);
    }

    public String getPersonalAnamnese() {
        return ((Kontakt)this.getEntity()).getPersonalAnamnese();
    }

    public void setPersonalAnamnese(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setPersonalAnamnese(value);
    }

    public String getAllergies() {
        return ((Kontakt)this.getEntity()).getAllergies();
    }

    public void setAllergies(String value) {
        ((Kontakt)this.getEntityMarkDirty()).setAllergies(value);
    }

    public String getPatientNr() {
        return this.getCode();
    }

    public void setPatientNr(String patientNr) {
        this.setCode(patientNr);
    }

    public List<ICoverage> getCoverages() {
        ch.elexis.core.services.holder.CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Kontakt)this.getEntity()).getFaelle().stream().filter(f -> !f.isDeleted()).map(f -> ModelUtil.getAdapter((EntityWithId)f, ICoverage.class)).collect(Collectors.toList());
    }

    public List<IPrescription> getMedication(List<EntryType> filterType) {
        IQuery query = ch.elexis.core.services.holder.CoreModelServiceHolder.get().getQuery(IPrescription.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this);
        query.startGroup();
        query.or((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__DATE_TO, IQuery.COMPARATOR.EQUALS, null);
        query.or((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__DATE_TO, IQuery.COMPARATOR.GREATER, (Object)LocalDateTime.now());
        query.andJoinGroups();
        List iPrescriptions = query.execute();
        if (filterType != null && !filterType.isEmpty()) {
            return iPrescriptions.parallelStream().filter(p -> filterType.contains(p.getEntryType())).collect(Collectors.toList());
        }
        return iPrescriptions;
    }

    public IContact getFamilyDoctor() {
        String doctorId = (String)this.getExtInfo("Stammarzt_");
        if (doctorId != null) {
            return CoreModelServiceHolder.get().load(doctorId, IContact.class).orElse(null);
        }
        return null;
    }

    public void setFamilyDoctor(IContact value) {
        if (value != null) {
            this.setExtInfo("Stammarzt_", value.getId());
        } else {
            this.setExtInfo("Stammarzt_", null);
        }
    }

    @Override
    public void setDeceased(boolean value) {
        super.setDeceased(value);
        String configSticker = ConfigServiceHolder.get().get("sticker/patient/deceased", "");
        if (configSticker == null || configSticker.isEmpty()) {
            configSticker = Messages.Patient_deceased;
        }
        ISticker sticker = this.getOrCreateSticker(configSticker, "ffffff", "000000");
        this.applyOrRemoveSticker(sticker, value);
    }

    private ISticker getOrCreateSticker(String stickername, String foreground, String background) {
        for (ISticker iSticker : StickerServiceHolder.get().getStickersForClass(IPatient.class)) {
            if (!iSticker.getName().equalsIgnoreCase(stickername)) continue;
            return iSticker;
        }
        ISticker ret = (ISticker)ch.elexis.core.services.holder.CoreModelServiceHolder.get().create(ISticker.class);
        ret.setName(stickername);
        ret.setForeground(foreground);
        ret.setBackground(background);
        ch.elexis.core.services.holder.CoreModelServiceHolder.get().save((Identifiable)ret);
        StickerServiceHolder.get().setStickerAddableToClass(IPatient.class, ret);
        return ret;
    }

    private void applyOrRemoveSticker(ISticker sticker, boolean apply) {
        if (apply) {
            ISticker existing = StickerServiceHolder.get().getSticker((Identifiable)this, sticker);
            if (existing == null) {
                StickerServiceHolder.get().addSticker(sticker, (Identifiable)this);
            }
        } else {
            StickerServiceHolder.get().removeSticker(sticker, (Identifiable)this);
        }
    }
}

