/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.dialogs.DateSelectorDialog;
import ch.elexis.core.ui.dialogs.FallSelectionDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.FallDetailBlatt2;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.core.ui.views.contribution.ViewContributionHelper;
import ch.elexis.core.ui.views.rechnung.InvoiceCorrectionWizard;
import ch.elexis.core.ui.views.rechnung.InvoiceCorrectionWizardDialog;
import ch.elexis.core.ui.views.rechnung.RnDialogs;
import ch.elexis.data.Anwender;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.dto.DiagnosesDTO;
import ch.elexis.data.dto.FallDTO;
import ch.elexis.data.dto.InvoiceCorrectionDTO;
import ch.elexis.data.dto.InvoiceHistoryEntryDTO;
import ch.elexis.data.dto.KonsultationDTO;
import ch.elexis.data.dto.LeistungDTO;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceCorrectionView
extends ViewPart
implements IUnlockable {
    public static final String ID = "ch.elexis.core.ui.views.rechnung.InvoiceCorrectionView";
    private InvoiceComposite invoiceComposite;
    private Rechnung actualInvoice;
    private InvoiceCorrectionDTO invoiceCorrectionDTO = new InvoiceCorrectionDTO();
    private InvoiceBottomComposite invoiceBottomComposite;
    private static final Logger log = LoggerFactory.getLogger(InvoiceCorrectionView.class);
    private boolean unlocked;
    private final List<IViewContribution> detailComposites = Extensions.getClasses((String)"ch.elexis.core.ui.ViewContribution", (String)"class", (String)"viewId", (String)"ch.elexis.RechnungsDetailView");
    private final ElexisEventListenerImpl eeli_rn = new ElexisUiEventListenerImpl(Rechnung.class, 20510){

        @Override
        public void runInUi(ElexisEvent ev) {
            switch (ev.getType()) {
                case 4: {
                    InvoiceCorrectionView.this.reloadSameInvoice((Rechnung)ev.getObject());
                    break;
                }
                case 2: {
                    InvoiceCorrectionView.this.reload(null);
                    break;
                }
                case 8: 
                case 16: {
                    if (InvoiceCorrectionView.this.actualInvoice != null) {
                        InvoiceCorrectionView.this.releaseAndRefreshLock((IPersistentObject)InvoiceCorrectionView.this.actualInvoice, "ch.elexis.core.ui.command.ToggleCurrentInvoiceLockCommand");
                        if (LocalLockServiceHolder.get().isLocked((Object)InvoiceCorrectionView.this.actualInvoice.getFall())) {
                            LocalLockServiceHolder.get().releaseLock((Object)InvoiceCorrectionView.this.actualInvoice.getFall());
                        }
                    }
                    InvoiceCorrectionView.this.reload((Rechnung)ev.getObject());
                    break;
                }
                case 4096: 
                case 16384: {
                    if (InvoiceCorrectionView.this.actualInvoice == null || !InvoiceCorrectionView.this.actualInvoice.equals((Object)((Rechnung)ev.getObject()))) break;
                    if (ev.getType() == 4096) {
                        if (LocalLockServiceHolder.get().acquireLock((Object)InvoiceCorrectionView.this.actualInvoice.getFall()).isOk()) {
                            InvoiceCorrectionView.this.setUnlocked(true);
                            break;
                        }
                        MessageDialog.openWarning((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Lock nicht erhalten", (String)"Lock nicht erhalten. Diese Operation ist derzeit nicht m\u00f6glich.");
                        break;
                    }
                    InvoiceCorrectionView.this.setUnlocked(false);
                }
            }
        }
    };
    private final ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (InvoiceCorrectionView.this.actualInvoice != null) {
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)InvoiceCorrectionView.this.actualInvoice, InvoiceCorrectionView.this.actualInvoice.getClass(), 8)});
            } else {
                InvoiceCorrectionView.this.reload(null);
            }
        }
    };

    private void reloadSameInvoice(Rechnung invoiceToReload) {
        if (this.actualInvoice != null && invoiceToReload != null && StringUtils.equals((CharSequence)this.actualInvoice.getId(), (CharSequence)invoiceToReload.getId())) {
            this.reload(invoiceToReload);
        }
    }

    private void reload(Rechnung rechnung) {
        if (this.invoiceComposite != null) {
            if (rechnung != null && rechnung.exists()) {
                this.actualInvoice = Rechnung.load((String)rechnung.getId());
                this.invoiceCorrectionDTO = new InvoiceCorrectionDTO(this.actualInvoice);
            } else if (this.actualInvoice != null && this.actualInvoice.exists()) {
                this.actualInvoice = Rechnung.load((String)this.actualInvoice.getId());
                this.invoiceCorrectionDTO = new InvoiceCorrectionDTO(this.actualInvoice);
            } else {
                this.actualInvoice = null;
                this.invoiceCorrectionDTO = new InvoiceCorrectionDTO();
            }
            Composite parent = this.invoiceComposite.getParent();
            this.invoiceComposite.dispose();
            this.invoiceComposite = new InvoiceComposite(parent);
            this.invoiceComposite.createComponents(this.invoiceCorrectionDTO);
            parent.layout(true, true);
            if (this.invoiceCorrectionDTO.getInvoiceNumber() != null && !this.invoiceCorrectionDTO.getErrors().isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (ElexisException e : this.invoiceCorrectionDTO.getErrors()) {
                    builder.append("\n" + e.getMessage());
                }
                MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Rechnungskorrektur", (String)("Die Rechnung " + this.invoiceCorrectionDTO.getInvoiceNumber() + " konnte nicht vollst\u00e4ndig geladen werden.\n\nDetails: " + builder.toString()));
            }
            this.setUnlocked(LocalLockServiceHolder.get().isLocked((Object)this.actualInvoice));
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.invoiceComposite = new InvoiceComposite(parent);
        this.invoiceComposite.createComponents(this.invoiceCorrectionDTO);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user});
        Rechnung selected = (Rechnung)ElexisEventDispatcher.getSelected(Rechnung.class);
        if (selected != null) {
            this.reload(selected);
        }
    }

    public void dispose() {
        if (this.actualInvoice != null && this.isUnlocked()) {
            this.releaseAndRefreshLock((IPersistentObject)this.actualInvoice, "ch.elexis.core.ui.command.ToggleCurrentInvoiceLockCommand");
            LocalLockServiceHolder.get().releaseLock((Object)this.actualInvoice.getFall());
        }
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user});
        super.dispose();
    }

    public void setFocus() {
        if (this.invoiceComposite != null) {
            this.invoiceComposite.updateScrollBars();
        }
    }

    private void openInvoiceNr(String invoiceNr) {
        Rechnung r = Rechnung.getFromNr((String)invoiceNr);
        if (r != null) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)r);
        } else {
            MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Fehler", (String)("Die Rechnung mit der Nummer: " + invoiceNr + " konnte nicht ge\u00f6ffnet werden.\nBitte versuchen Sie diesn manuell zu \u00f6ffnen."));
        }
    }

    private Result<String> doBillCorrection(Rechnung actualInvoice) {
        log.debug("invoice correction: start");
        if (actualInvoice != null && actualInvoice.isCorrectable() && actualInvoice.getFall() != null && this.invoiceCorrectionDTO != null && this.invoiceCorrectionDTO.getFallDTO() != null) {
            try {
                log.debug("invoice correction: invoice number [{}]", (Object)actualInvoice.getNr());
                this.invoiceCorrectionDTO.updateHistory();
                InvoiceCorrectionWizardDialog wizardDialog = new InvoiceCorrectionWizardDialog(this.getSite().getShell(), this.invoiceCorrectionDTO);
                wizardDialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        if (event.getSelectedPage() instanceof InvoiceCorrectionWizard.Page2) {
                            log.debug("invoice correction: processable changes {}", InvoiceCorrectionView.this.invoiceCorrectionDTO.getHistory().stream().map(item -> item.getOperationType()).collect(Collectors.toList()));
                            final InvoiceCorrectionWizard.Page2 page = (InvoiceCorrectionWizard.Page2)((Object)event.getSelectedPage());
                            InvoiceCorrectionDTO invoiceCorrectionDTO = page.getInvoiceCorrectionDTO();
                            BillingUtil.doBillCorrection((InvoiceCorrectionDTO)invoiceCorrectionDTO, (BillingUtil.BillCallback)new BillingUtil.BillCallback(){

                                public List<Konsultation> storno(Rechnung rechnung) {
                                    RnDialogs.StornoDialog stronoDlg = new RnDialogs.StornoDialog(UiDesk.getDisplay().getActiveShell(), rechnung, true);
                                    if (stronoDlg.openDialog() == 0) {
                                        return stronoDlg.getKonsultations();
                                    }
                                    page.getTxtOutput().setText("Die Rechnungskorrektur wurde durch den Benutzer abgebrochen.");
                                    return null;
                                }
                            });
                            page.updateProcess();
                            if (invoiceCorrectionDTO.getOutputText() != null) {
                                page.getTxtOutput().setText(invoiceCorrectionDTO.getOutputText());
                            }
                        }
                    }
                });
                wizardDialog.open();
                if (this.invoiceCorrectionDTO.getOutputText() != null) {
                    this.setInvoiceCorrectionInfo(actualInvoice);
                    if (this.invoiceCorrectionDTO.isCorrectionSuccess()) {
                        StringBuilder txtBemerkung = new StringBuilder();
                        if (txtBemerkung != null) {
                            txtBemerkung.append(actualInvoice.getBemerkung());
                        }
                        if (txtBemerkung.length() > 0) {
                            txtBemerkung.append("\n");
                        }
                        txtBemerkung.append(this.invoiceCorrectionDTO.getOutputText());
                        actualInvoice.setBemerkung(txtBemerkung.toString());
                        log.debug("invoice correction: successfully finished");
                        return new Result((Object)"ok");
                    }
                    log.debug("invoice correction: failed with warnings");
                    return new Result(Result.SEVERITY.WARNING, 2, "warn", null, false);
                }
            }
            catch (Exception e) {
                log.error("invoice correction: failed with errors [{}]", (Object)actualInvoice.getId(), (Object)e);
                this.setInvoiceCorrectionInfo(actualInvoice);
                return new Result(Result.SEVERITY.ERROR, 2, "error", (Object)"Die Rechnungskorrektur konnte nicht vollst\u00e4ndig durchgef\u00fchrt werden.\nF\u00fcr mehr Details, beachten Sie bitte das Log-File.", false);
            }
        }
        return null;
    }

    private void setInvoiceCorrectionInfo(Rechnung actualInvoice) {
        if (actualInvoice != null && this.invoiceCorrectionDTO != null) {
            actualInvoice.setExtInfoStoredObjectByKey((Object)"Rechnungskorrektur", (Object)(StringUtils.isEmpty((CharSequence)this.invoiceCorrectionDTO.getNewInvoiceNumber()) ? "" : this.invoiceCorrectionDTO.getNewInvoiceNumber()));
        }
    }

    private boolean changePriceDialog(LeistungDTO leistungDTO) {
        Money oldPrice = leistungDTO.getPrice();
        String p = oldPrice.getAmountAsString();
        InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changePriceForService, Messages.VerrechnungsDisplay_enterNewPrice, p, null);
        if (dlg.open() == 0) {
            try {
                Money customPrice;
                String val = dlg.getValue().trim();
                if (val.endsWith("%") && val.length() > 1) {
                    val = val.substring(0, val.length() - 1);
                    double percent = Double.parseDouble(val);
                    double scaleFactor = 1.0 + percent / 100.0;
                    leistungDTO.setScale2(scaleFactor);
                    customPrice = leistungDTO.getPrice();
                } else {
                    customPrice = new Money(val);
                    leistungDTO.setScale2(Double.valueOf(1.0).doubleValue());
                }
                if (customPrice != null) {
                    leistungDTO.setTp(customPrice.getCents());
                }
                return true;
            }
            catch (ParseException ex) {
                log.error("price changing", (Throwable)ex);
                SWTHelper.showError(Messages.VerrechnungsDisplay_badAmountCaption, Messages.VerrechnungsDisplay_badAmountBody);
            }
        }
        return false;
    }

    private boolean changeQuantityDialog(LeistungDTO leistungDTO) {
        String p = Integer.toString(leistungDTO.getCount());
        InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changeNumberCaption, Messages.VerrechnungsDisplay_changeNumberBody, p, null);
        if (dlg.open() == 0) {
            try {
                String val = dlg.getValue();
                if (!StringTool.isNothing((Object)val)) {
                    int changeAnzahl;
                    double secondaryScaleFactor = 1.0;
                    String text = leistungDTO.getIVerrechenbar().getText();
                    if (val.indexOf("/") > 0) {
                        changeAnzahl = 1;
                        String[] frac = val.split("/");
                        secondaryScaleFactor = Double.parseDouble(frac[0]) / Double.parseDouble(frac[1]);
                        text = String.valueOf(leistungDTO.getIVerrechenbar().getText()) + " (" + val + Messages.VerrechnungsDisplay_Orininalpackungen;
                    } else if (val.indexOf(46) > 0) {
                        changeAnzahl = 1;
                        secondaryScaleFactor = Double.parseDouble(val);
                        text = String.valueOf(leistungDTO.getIVerrechenbar().getText()) + " (" + Double.toString(secondaryScaleFactor) + ")";
                    } else {
                        changeAnzahl = Integer.parseInt(dlg.getValue());
                    }
                    leistungDTO.setCount(changeAnzahl);
                    leistungDTO.setScale2(secondaryScaleFactor);
                    return true;
                }
            }
            catch (NumberFormatException ne) {
                log.error("quantity changing", (Throwable)ne);
                SWTHelper.showError(Messages.VerrechnungsDisplay_invalidEntryCaption, Messages.VerrechnungsDisplay_invalidEntryBody);
            }
        }
        return false;
    }

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && LocalLockServiceHolder.get().isLocked((Object)object)) {
            LocalLockServiceHolder.get().releaseLock((Object)object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        boolean bl = this.unlocked = unlocked && this.actualInvoice != null && this.actualInvoice.isCorrectable();
        if (this.invoiceComposite != null) {
            this.invoiceComposite.setUnlocked(this.unlocked);
        }
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    class InvoiceBottomComposite
    extends Composite
    implements IUnlockable {
        Button btnCancel;
        Button btnCorrection;

        public InvoiceBottomComposite(Composite parent) {
            super(parent, 0);
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        }

        public void createComponents() {
            Composite parent = new Composite((Composite)this, 0);
            GridLayout gd = new GridLayout(3, false);
            gd.marginWidth = 0;
            gd.marginHeight = 2;
            parent.setLayout((Layout)gd);
            parent.setLayoutData((Object)new GridData(131072, 128, true, true, 1, 1));
            this.btnCorrection = new Button(parent, 0);
            this.btnCorrection.setEnabled(false);
            this.btnCorrection.setText("Rechnungskorrektur starten..");
            this.btnCorrection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Result<String> res = InvoiceCorrectionView.this.doBillCorrection(((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.actualInvoice);
                    if (res != null) {
                        if (Result.SEVERITY.ERROR.equals((Object)res.getSeverity())) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Rechnungskorrektur", (String)((String)res.get()));
                        }
                        if (((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getNewInvoiceNumber() != null && ((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.isOpenNewInvoice()) {
                            InvoiceCorrectionView.this.openInvoiceNr(((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getNewInvoiceNumber());
                        } else {
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.actualInvoice, ((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.actualInvoice.getClass(), 8)});
                        }
                    }
                }
            });
            this.btnCancel = new Button(parent, 0);
            this.btnCancel.setText("Zur\u00fccksetzen");
            this.btnCancel.setEnabled(false);
            this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    log.debug("invoice correction: invoice reset");
                    InvoiceCorrectionView.this.reload(((InvoiceBottomComposite)InvoiceBottomComposite.this).InvoiceCorrectionView.this.actualInvoice);
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Rechnungskorrektur", (String)"Die Rechnung wurde erfolgreich zur\u00fcckgesetzt.");
                }
            });
            this.setVisible(InvoiceCorrectionView.this.actualInvoice != null && InvoiceCorrectionView.this.actualInvoice.isCorrectable());
        }

        public void refresh(boolean hasChanges) {
            if (InvoiceCorrectionView.this.invoiceCorrectionDTO != null) {
                if (this.btnCancel != null) {
                    this.btnCancel.setEnabled(hasChanges && InvoiceCorrectionView.this.isUnlocked());
                }
                if (this.btnCorrection != null) {
                    this.btnCorrection.setEnabled(hasChanges && InvoiceCorrectionView.this.isUnlocked());
                }
            }
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            this.refresh(InvoiceCorrectionView.this.invoiceCorrectionDTO.hasChanges());
        }
    }

    class InvoiceComposite
    extends ScrolledComposite
    implements IUnlockable {
        Composite wrapper;
        InvoiceHeaderComposite invoiceHeaderComposite;
        InvoiceContentComposite invoiceContentComposite;

        public InvoiceComposite(Composite parent) {
            super(parent, 768);
            this.setLayout((Layout)new GridLayout(1, false));
            this.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        }

        public void createComponents(InvoiceCorrectionDTO invoiceCorrectionDTO) {
            this.wrapper = new Composite((Composite)this, 0);
            this.wrapper.setLayout((Layout)new GridLayout(1, false));
            this.wrapper.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.invoiceHeaderComposite = new InvoiceHeaderComposite(this.wrapper);
            this.invoiceContentComposite = new InvoiceContentComposite(this.wrapper);
            InvoiceCorrectionView.this.invoiceBottomComposite = new InvoiceBottomComposite(this.wrapper);
            this.invoiceHeaderComposite.createComponents(invoiceCorrectionDTO);
            if (invoiceCorrectionDTO != null) {
                if (invoiceCorrectionDTO.getId() != null) {
                    this.invoiceContentComposite.createComponents(invoiceCorrectionDTO);
                    InvoiceCorrectionView.this.invoiceBottomComposite.createComponents();
                }
                invoiceCorrectionDTO.register(new InvoiceCorrectionDTO.IInvoiceCorrectionChanged(){

                    public void changed(InvoiceCorrectionDTO invoiceCorrectionDTO) {
                        if (((InvoiceComposite)InvoiceComposite.this).InvoiceCorrectionView.this.invoiceBottomComposite != null) {
                            ((InvoiceComposite)InvoiceComposite.this).InvoiceCorrectionView.this.invoiceBottomComposite.refresh(true);
                        }
                    }
                });
            }
            this.setContent((Control)this.wrapper);
            this.setExpandHorizontal(true);
            this.setExpandVertical(true);
            this.updateScrollBars();
        }

        public void updateScrollBars() {
            if (this.wrapper != null) {
                this.setMinSize(this.wrapper.computeSize(-1, -1));
                this.layout(true, true);
            }
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            if (this.invoiceHeaderComposite != null) {
                this.invoiceHeaderComposite.setUnlocked(unlocked);
            }
            if (this.invoiceContentComposite != null) {
                this.invoiceContentComposite.setUnlocked(unlocked);
            }
            if (InvoiceCorrectionView.this.invoiceBottomComposite != null) {
                InvoiceCorrectionView.this.invoiceBottomComposite.setUnlocked(unlocked);
            }
        }
    }

    class InvoiceContentComposite
    extends Composite
    implements IUnlockable {
        InvoiceContentHeaderComposite invoiceContentHeaderComposite;
        InvoiceContentMiddleComposite invoiceContentMiddleComposite;

        public InvoiceContentComposite(Composite parent) {
            super(parent, 0);
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 5;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        }

        public void createComponents(InvoiceCorrectionDTO invoiceCorrectionDTO) {
            if (invoiceCorrectionDTO.getFallDTO() != null) {
                this.invoiceContentHeaderComposite = new InvoiceContentHeaderComposite(this);
                this.invoiceContentHeaderComposite.createComponents(invoiceCorrectionDTO.getFallDTO());
            }
            this.invoiceContentMiddleComposite = new InvoiceContentMiddleComposite(this);
            this.invoiceContentMiddleComposite.createComponents(invoiceCorrectionDTO);
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            if (this.invoiceContentHeaderComposite != null) {
                this.invoiceContentHeaderComposite.setUnlocked(unlocked);
            }
            if (this.invoiceContentMiddleComposite != null) {
                this.invoiceContentMiddleComposite.setUnlocked(unlocked);
            }
        }
    }

    class InvoiceContentDiagnosisComposite
    extends Composite
    implements IUnlockable {
        TableViewer tableViewer;
        TableColumnLayout tableColumnLayout;

        public InvoiceContentDiagnosisComposite(Composite parent) {
            super(parent, 0);
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        }

        private void createComponents(final KonsultationDTO konsultationDTO) {
            Composite tableArea = new Composite((Composite)this, 0);
            tableArea.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.tableColumnLayout = new TableColumnLayout();
            tableArea.setLayout((Layout)this.tableColumnLayout);
            this.tableViewer = new TableViewer(tableArea, 67584);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
            Table table = this.tableViewer.getTable();
            table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.createTableViewerColumn(Messages.DiagnosenDisplay_Diagnoses, 1, 0);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            GenericObjectDropTarget.IReceiver dtr = new GenericObjectDropTarget.IReceiver(){

                @Override
                public void dropped(List<Object> list, DropTargetEvent e) {
                    for (Object object : list) {
                        if (!(object instanceof IDiagnosis)) continue;
                        IDiagnosis art = (IDiagnosis)object;
                        DiagnosesDTO dto = new DiagnosesDTO(art);
                        konsultationDTO.getDiagnosesDTOs().add(dto);
                        ((InvoiceContentDiagnosisComposite)InvoiceContentDiagnosisComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.DIAGNOSE_ADD, (Object)konsultationDTO, (Object)dto));
                        InvoiceContentDiagnosisComposite.this.tableViewer.refresh();
                        ((InvoiceContentDiagnosisComposite)InvoiceContentDiagnosisComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                    }
                }

                @Override
                public boolean accept(List<Object> list) {
                    return true;
                }
            };
            final GenericObjectDropTarget dropTarget = new GenericObjectDropTarget("rechnungskorrekturBehandlungen", (Control)table, dtr){

                @Override
                protected Control getHighLightControl() {
                    return InvoiceContentDiagnosisComposite.this.tableViewer.getControl();
                }
            };
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return Messages.DiagnosenDisplay_AddDiagnosis;
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    try {
                        InvoiceCorrectionView.this.getSite().getPage().showView("ch.elexis.DiagnosenView");
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(dropTarget);
                    }
                    catch (PartInitException e) {
                        LoggerFactory.getLogger(InvoiceCorrectionDTO.class).error("cannot init diagnose viewpart", (Throwable)e);
                    }
                }
            });
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Diagnose entfernen";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    DiagnosesDTO dto = InvoiceContentDiagnosisComposite.this.getSelection();
                    if (dto != null) {
                        konsultationDTO.getDiagnosesDTOs().remove(dto);
                        ((InvoiceContentDiagnosisComposite)InvoiceContentDiagnosisComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.DIAGNOSE_REMOVE, (Object)konsultationDTO, (Object)dto));
                        InvoiceContentDiagnosisComposite.this.tableViewer.refresh();
                        ((InvoiceContentDiagnosisComposite)InvoiceContentDiagnosisComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                    }
                }
            });
            this.tableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewer.getTable()));
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.setInput((Object)konsultationDTO.getDiagnosesDTOs());
        }

        public DiagnosesDTO getSelection() {
            StructuredSelection structuredSelection;
            if (this.tableViewer != null && !(structuredSelection = (StructuredSelection)this.tableViewer.getSelection()).isEmpty()) {
                return (DiagnosesDTO)structuredSelection.getFirstElement();
            }
            return null;
        }

        private TableViewerColumn createTableViewerColumn(String title, int bound, int colIdx) {
            TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn column = viewerColumn.getColumn();
            column.setText(title);
            this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(bound, 20, true));
            column.setResizable(true);
            column.setMoveable(false);
            viewerColumn.setLabelProvider((CellLabelProvider)new DefaultColumnLabelProvider(colIdx));
            return viewerColumn;
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            if (this.tableViewer != null) {
                this.tableViewer.getTable().setEnabled(unlocked);
            }
        }

        private class DefaultColumnLabelProvider
        extends ColumnLabelProvider {
            int colIdx;

            public DefaultColumnLabelProvider(int colIdx) {
                this.colIdx = colIdx;
            }

            public String getText(Object element) {
                DiagnosesDTO diagnosesDTO = (DiagnosesDTO)element;
                switch (this.colIdx) {
                    case 0: {
                        return diagnosesDTO.getLabel();
                    }
                }
                return "";
            }
        }
    }

    class InvoiceContentHeaderComposite
    extends Composite
    implements IUnlockable {
        FallDetailBlatt2 fallDetailBlatt2;

        public InvoiceContentHeaderComposite(Composite parent) {
            super(parent, 2048);
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        }

        public void createComponents(FallDTO fallDTO) {
            this.setBackground(UiDesk.getColor("weiss"));
            FormToolkit tk = UiDesk.getToolkit();
            ScrolledForm form = tk.createScrolledForm((Composite)this);
            form.setBackground(UiDesk.getColor("weiss"));
            form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            Composite body = form.getBody();
            GridLayout gd1 = new GridLayout();
            gd1.marginWidth = 0;
            gd1.marginHeight = 0;
            body.setLayout((Layout)gd1);
            ExpandableComposite expandable = WidgetFactory.createExpandableComposite(tk, form, "");
            expandable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            expandable.setExpanded(false);
            expandable.setText("Fallangaben");
            expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    ((InvoiceContentHeaderComposite)InvoiceContentHeaderComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                }
            });
            Composite group = tk.createComposite((Composite)expandable, 0);
            GridLayout gd = new GridLayout(2, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            group.setLayout((Layout)gd);
            group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            expandable.setClient((Control)group);
            this.fallDetailBlatt2 = new FallDetailBlatt2(group, (IFall)fallDTO, true);
            GridData gd2 = new GridData(4, 4, true, false, 1, 1);
            gd2.heightHint = 340;
            this.fallDetailBlatt2.setLayoutData(gd2);
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            if (this.fallDetailBlatt2 != null) {
                this.fallDetailBlatt2.setUnlocked(unlocked);
            }
        }
    }

    class InvoiceContentKonsultationComposite
    extends Composite
    implements IUnlockable {
        TableViewer tableViewer;
        TableColumnLayout tableColumnLayout;

        public InvoiceContentKonsultationComposite(Composite parent) {
            super(parent, 0);
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 4, true, true, 2, 2));
        }

        private void createComponents(final KonsultationDTO konsultationDTO) {
            Composite tableArea = new Composite((Composite)this, 0);
            tableArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.tableColumnLayout = new TableColumnLayout();
            tableArea.setLayout((Layout)this.tableColumnLayout);
            this.tableViewer = new TableViewer(tableArea, 67584);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
            Table table = this.tableViewer.getTable();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            this.createTableViewerColumn("Anzahl", 1, 0);
            this.createTableViewerColumn("Leistungscode", 4, 1);
            this.createTableViewerColumn("Leistungstext", 12, 2);
            this.createTableViewerColumn("Preis", 3, 3);
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.setInput((Object)konsultationDTO.getLeistungDTOs());
            this.tableViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    return ObjectUtils.compare((Comparable)Long.valueOf(((LeistungDTO)e1).getLastUpdate()), (Comparable)Long.valueOf(((LeistungDTO)e2).getLastUpdate()));
                }
            });
            InvoiceCorrectionView.this.invoiceCorrectionDTO.getFallDTO().register(new FallDTO.IFallChanged(){

                public void changed(FallDTO fallDTO, boolean triggersRecalc) {
                    if (triggersRecalc) {
                        for (KonsultationDTO konsultationDTO : ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getKonsultationDTOs()) {
                            for (LeistungDTO leistungDTO : konsultationDTO.getLeistungDTOs()) {
                                leistungDTO.calcPrice(konsultationDTO, fallDTO);
                            }
                        }
                    }
                    if (((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceBottomComposite != null) {
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceBottomComposite.refresh(true);
                    }
                    if (!InvoiceContentKonsultationComposite.this.isDisposed()) {
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                    }
                }
            });
            GenericObjectDropTarget.IReceiver dtr = new GenericObjectDropTarget.IReceiver(){

                @Override
                public void dropped(List<Object> list, DropTargetEvent e) {
                    for (Object object : list) {
                        if (!(object instanceof IBillable)) continue;
                        LeistungDTO leistungDTO = new LeistungDTO((IBillable)object, (IFall)((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getFallDTO());
                        konsultationDTO.getLeistungDTOs().add(leistungDTO);
                        leistungDTO.calcPrice(konsultationDTO, ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getFallDTO());
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.LEISTUNG_ADD, (Object)konsultationDTO, (Object)leistungDTO));
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                    }
                }

                @Override
                public boolean accept(List<Object> list) {
                    return true;
                }
            };
            final GenericObjectDropTarget dropTarget = new GenericObjectDropTarget("rechnungskorrektur", (Control)table, dtr){

                @Override
                protected Control getHighLightControl() {
                    return InvoiceContentKonsultationComposite.this.tableViewer.getControl();
                }
            };
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Anzahl \u00e4ndern";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    LeistungDTO leistungDTO = InvoiceContentKonsultationComposite.this.getSelection();
                    if (leistungDTO != null && InvoiceCorrectionView.this.changeQuantityDialog(leistungDTO)) {
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.LEISTUNG_CHANGE_COUNT, (Object)konsultationDTO, (Object)leistungDTO));
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                    }
                }
            });
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Preis \u00e4ndern";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    LeistungDTO leistungDTO = InvoiceContentKonsultationComposite.this.getSelection();
                    if (leistungDTO != null && InvoiceCorrectionView.this.changePriceDialog(leistungDTO)) {
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.LEISTUNG_CHANGE_PRICE, (Object)konsultationDTO, (Object)leistungDTO));
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                    }
                }
            });
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Leistung auf neuen Fall/Kons transferieren";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    FallSelectionDialog fallSelectionDialog;
                    LeistungDTO leistungDTO = InvoiceContentKonsultationComposite.this.getSelection();
                    if (leistungDTO != null && (fallSelectionDialog = new FallSelectionDialog(InvoiceContentKonsultationComposite.this.getShell(), "Bitte w\u00e4hlen Sie einen Fall aus, auf das die u.a. Leistung transferiert werden soll.\n" + leistungDTO.getText(), ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getFallDTO())).open() == 0 && fallSelectionDialog.getSelectedFall().isPresent()) {
                        konsultationDTO.getLeistungDTOs().remove(leistungDTO);
                        IFall iFall = fallSelectionDialog.getSelectedFall().get();
                        InvoiceHistoryEntryDTO existingEntry = ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.getHistoryEntryForLeistungTransferFromCache(iFall);
                        if (existingEntry != null && existingEntry.getItem() instanceof List) {
                            List leistungen = (List)existingEntry.getItem();
                            leistungen.add(leistungDTO);
                        } else {
                            ArrayList<LeistungDTO> leistungen = new ArrayList<LeistungDTO>();
                            leistungen.add(leistungDTO);
                            ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.LEISTUNG_TRANSFER_TO_FALL_KONS, (Object)konsultationDTO, leistungen, (Object)iFall));
                        }
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                    }
                }
            });
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Leistung hinzuf\u00fcgen";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    try {
                        InvoiceCorrectionView.this.getSite().getPage().showView("ch.elexis.LeistungenView");
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(dropTarget);
                    }
                    catch (PartInitException e) {
                        LoggerFactory.getLogger(InvoiceCorrectionDTO.class).error("cannot init leistungen viewpart", (Throwable)e);
                    }
                }
            });
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "Leistung entfernen";
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    LeistungDTO leistungDTO = InvoiceContentKonsultationComposite.this.getSelection();
                    if (leistungDTO != null) {
                        konsultationDTO.getLeistungDTOs().remove(leistungDTO);
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.LEISTUNG_REMOVE, (Object)konsultationDTO, (Object)leistungDTO));
                        InvoiceContentKonsultationComposite.this.tableViewer.refresh();
                        ((InvoiceContentKonsultationComposite)InvoiceContentKonsultationComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                    }
                }
            });
            this.tableViewer.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewer.getTable()));
        }

        public LeistungDTO getSelection() {
            StructuredSelection structuredSelection;
            if (this.tableViewer != null && !(structuredSelection = (StructuredSelection)this.tableViewer.getSelection()).isEmpty()) {
                return (LeistungDTO)structuredSelection.getFirstElement();
            }
            return null;
        }

        private TableViewerColumn createTableViewerColumn(String title, int bound, int colIdx) {
            TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn column = viewerColumn.getColumn();
            column.setText(title);
            this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(bound, 20, true));
            column.setResizable(true);
            column.setMoveable(false);
            viewerColumn.setLabelProvider((CellLabelProvider)new DefaultColumnLabelProvider(colIdx));
            return viewerColumn;
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            if (this.tableViewer != null) {
                this.tableViewer.getTable().setEnabled(unlocked);
            }
        }

        private class DefaultColumnLabelProvider
        extends ColumnLabelProvider {
            int colIdx;

            public DefaultColumnLabelProvider(int colIdx) {
                this.colIdx = colIdx;
            }

            public String getText(Object element) {
                LeistungDTO leistungDTO = (LeistungDTO)element;
                switch (this.colIdx) {
                    case 0: {
                        return String.valueOf(leistungDTO.getCount());
                    }
                    case 1: {
                        return leistungDTO.getCode();
                    }
                    case 2: {
                        return leistungDTO.getText();
                    }
                    case 3: {
                        return leistungDTO.getPrice() != null ? leistungDTO.getPrice().getAmountAsString() : "0";
                    }
                }
                return "";
            }
        }
    }

    class InvoiceContentMiddleComposite
    extends Composite
    implements IUnlockable {
        private List<IUnlockable> unlockables;
        private List<IAction> actions;

        public InvoiceContentMiddleComposite(Composite parent) {
            super(parent, 0);
            this.unlockables = new ArrayList<IUnlockable>();
            this.actions = new ArrayList<IAction>();
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 5;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.unlockables.clear();
            this.actions.clear();
        }

        public void createComponents(final InvoiceCorrectionDTO invoiceCorrectionDTO) {
            FormToolkit tk = UiDesk.getToolkit();
            for (final KonsultationDTO konsultationDTO : invoiceCorrectionDTO.getKonsultationDTOs()) {
                final ScrolledForm form = tk.createScrolledForm((Composite)this);
                form.setBackground(UiDesk.getColor("hellgrau"));
                form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                Composite body = form.getBody();
                GridLayout gd1 = new GridLayout();
                gd1.marginWidth = 1;
                gd1.marginHeight = 1;
                body.setLayout((Layout)gd1);
                final ExpandableComposite expandable = WidgetFactory.createExpandableComposite(tk, form, "");
                expandable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                expandable.setExpanded(false);
                expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        ((InvoiceContentMiddleComposite)InvoiceContentMiddleComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                        if (((Boolean)e.data).booleanValue()) {
                            Konsultation originKons = Konsultation.load((String)konsultationDTO.getId());
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)originKons);
                        } else {
                            ElexisEventDispatcher.clearSelection(Konsultation.class);
                        }
                    }
                });
                Composite group = tk.createComposite((Composite)expandable, 0);
                GridLayout gd = new GridLayout(2, false);
                gd.marginWidth = 0;
                gd.marginHeight = 0;
                group.setLayout((Layout)gd);
                group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                expandable.setClient((Control)group);
                this.updateKonsTitleText(expandable, konsultationDTO);
                ToolBarManager tbManager = new ToolBarManager(8388928);
                Action actionDateChange = new Action("Datum \u00e4ndern"){

                    public ImageDescriptor getImageDescriptor() {
                        return Images.IMG_CALENDAR.getImageDescriptor();
                    }

                    public String getToolTipText() {
                        return "Datum \u00e4ndern";
                    }

                    public void run() {
                        TimeTool date;
                        String newDate;
                        DateSelectorDialog dlg = new DateSelectorDialog(InvoiceContentMiddleComposite.this.getShell(), new TimeTool(konsultationDTO.getDate()));
                        if (dlg.open() == 0 && !StringUtils.equals((CharSequence)(newDate = (date = dlg.getSelectedDate()).toString(4)), (CharSequence)konsultationDTO.getDate())) {
                            konsultationDTO.setDate(newDate);
                            invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.KONSULTATION_CHANGE_DATE, (Object)konsultationDTO, null));
                            InvoiceContentMiddleComposite.this.updateKonsTitleText(expandable, konsultationDTO);
                        }
                    }
                };
                Action actionMandantChange = new Action(){

                    public String getText() {
                        return "Mandant \u00e4ndern";
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return Images.IMG_MANN.getImageDescriptor();
                    }

                    public void run() {
                        KontaktSelektor ksl = new KontaktSelektor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Mandant.class, "Mandant ausw\u00e4hlen", "Auf wen soll diese Kons verrechnet werden?", new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
                        if (ksl.open() == 0) {
                            Mandant srcMandant = konsultationDTO.getMandant();
                            Mandant selectedMandant = (Mandant)ksl.getSelection();
                            if (selectedMandant != null) {
                                Rechnungssteller srcRechnungsteller;
                                Rechnungssteller dstRechnungsteller = selectedMandant.getRechnungssteller();
                                if (srcMandant != null && !StringUtils.equals((CharSequence)(srcRechnungsteller = srcMandant.getRechnungssteller()).getId(), (CharSequence)dstRechnungsteller.getId()) && !MessageDialog.openQuestion((Shell)InvoiceContentMiddleComposite.this.getShell(), (String)"Rechnungskorrektur", (String)("Der Rechnungsteller des ausgew\u00e4hlten Mandants ist " + dstRechnungsteller.getLabel() + ".\nDieser unterscheidet sich zu dem bisherigen Rechnungsteller " + srcRechnungsteller.getLabel() + ".\n\nWollen Sie trotzdem den Mandanten " + selectedMandant.getLabel() + " ausw\u00e4hlen ?"))) {
                                    return;
                                }
                                konsultationDTO.setMandant(selectedMandant);
                                invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.KONSULTATION_CHANGE_MANDANT, (Object)konsultationDTO, null));
                                InvoiceContentMiddleComposite.this.updateKonsTitleText(expandable, konsultationDTO);
                            } else {
                                MessageDialog.openWarning((Shell)InvoiceContentMiddleComposite.this.getShell(), (String)"Rechnungskorrektur", (String)"Mandantenauswahl fehlerhaft. Der Mandant konnte nicht ge\u00e4ndert werden.");
                            }
                        }
                    }
                };
                Action transferKons = new Action("Konsultation Transfer"){

                    public ImageDescriptor getImageDescriptor() {
                        return Images.IMG_MOVETOLOWERLIST.getImageDescriptor();
                    }

                    public String getToolTipText() {
                        return "Konsultation auf anderen Fall verschieben";
                    }

                    public void run() {
                        FallSelectionDialog fallSelectionDialog = new FallSelectionDialog(InvoiceContentMiddleComposite.this.getShell(), "Bitte w\u00e4hlen Sie einen Fall aus, auf das die u.a. Konsultation transferiert werden soll.\nKonsultation: " + konsultationDTO.getDate(), invoiceCorrectionDTO.getFallDTO());
                        if (fallSelectionDialog.open() == 0 && fallSelectionDialog.getSelectedFall().isPresent() && invoiceCorrectionDTO.getKonsultationDTOs().remove(konsultationDTO)) {
                            IFall iFall = fallSelectionDialog.getSelectedFall().get();
                            invoiceCorrectionDTO.addToCache(new InvoiceHistoryEntryDTO(InvoiceHistoryEntryDTO.OperationType.KONSULTATION_TRANSFER_TO_FALL, (Object)konsultationDTO, (Object)iFall));
                            form.dispose();
                            InvoiceContentMiddleComposite.this.layout(true, true);
                            ((InvoiceContentMiddleComposite)InvoiceContentMiddleComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                        }
                    }
                };
                tbManager.add((IAction)actionDateChange);
                tbManager.add((IAction)actionMandantChange);
                tbManager.add((IAction)transferKons);
                this.actions.add((IAction)actionDateChange);
                this.actions.add((IAction)actionMandantChange);
                ToolBar toolbar = tbManager.createControl(group);
                GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)toolbar);
                InvoiceContentDiagnosisComposite invoiceContentDiagnosisComposite = new InvoiceContentDiagnosisComposite(group);
                InvoiceContentKonsultationComposite invoiceContentKonsultationComposite = new InvoiceContentKonsultationComposite(group);
                invoiceContentDiagnosisComposite.createComponents(konsultationDTO);
                invoiceContentKonsultationComposite.createComponents(konsultationDTO);
                this.unlockables.add(invoiceContentDiagnosisComposite);
                this.unlockables.add(invoiceContentKonsultationComposite);
            }
        }

        public void updateKonsTitleText(ExpandableComposite expandableComposite, KonsultationDTO konsultationDTO) {
            expandableComposite.setText("Konsultation: " + konsultationDTO.getDate() + " Mandant: " + konsultationDTO.getMandant().getLabel());
        }

        @Override
        public void setUnlocked(boolean unlocked) {
            for (IUnlockable iUnlockable : this.unlockables) {
                iUnlockable.setUnlocked(unlocked);
            }
            for (IAction action : this.actions) {
                action.setEnabled(unlocked);
            }
        }
    }

    class InvoiceHeaderComposite
    extends Composite
    implements IUnlockable {
        String[] lbls;

        public InvoiceHeaderComposite(Composite parent) {
            super(parent, 2048);
            this.lbls = new String[]{"Rechnung", "Status", "Patient", "Rechnungsbetrag"};
            GridLayout gd = new GridLayout(1, false);
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            this.setLayout((Layout)gd);
            this.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        }

        public void createComponents(final InvoiceCorrectionDTO invoiceCorrectionDTO) {
            FormToolkit tk = UiDesk.getToolkit();
            ScrolledForm form = tk.createScrolledForm((Composite)this);
            form.setBackground(UiDesk.getColor("weiss"));
            form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            Composite body = form.getBody();
            GridLayout gd1 = new GridLayout();
            gd1.marginWidth = 0;
            gd1.marginHeight = 0;
            body.setLayout((Layout)gd1);
            ExpandableComposite expandable = WidgetFactory.createExpandableComposite(tk, form, "");
            expandable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            expandable.setExpanded(false);
            expandable.setText("Rechnungsangaben");
            expandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    ((InvoiceHeaderComposite)InvoiceHeaderComposite.this).InvoiceCorrectionView.this.invoiceComposite.updateScrollBars();
                }
            });
            expandable.setExpanded(true);
            Composite group = tk.createComposite((Composite)expandable, 0);
            GridLayout gd3 = new GridLayout(2, false);
            gd3.marginWidth = 5;
            gd3.marginHeight = 5;
            group.setLayout((Layout)gd3);
            group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            expandable.setClient((Control)group);
            Color colWhite = UiDesk.getColor("weiss");
            this.setBackground(colWhite);
            GridData gd = new GridData(4, 4, true, false, 1, 1);
            String[] invoiceDetails = invoiceCorrectionDTO.getInvoiceDetails();
            if (invoiceDetails.length == this.lbls.length) {
                int i = 0;
                String[] stringArray = this.lbls;
                int n = this.lbls.length;
                int n2 = 0;
                while (n2 < n) {
                    String lbl = stringArray[n2];
                    String detailText = invoiceDetails[i++];
                    new Label(group, 0).setText(lbl);
                    Text text = new Text(group, 2056);
                    text.setBackground(colWhite);
                    text.setLayoutData((Object)gd);
                    text.setText(detailText != null ? detailText : "");
                    ++n2;
                }
            }
            new Label(group, 0).setText("Bemerkung");
            Text txtMulti = new Text(group, 2634);
            GridData gd2 = new GridData(4, 4, true, true, 1, 1);
            gd2.heightHint = 50;
            txtMulti.setBackground(UiDesk.getColor("weiss"));
            txtMulti.setLayoutData((Object)gd2);
            txtMulti.setText(invoiceCorrectionDTO.getBemerkung() != null ? invoiceCorrectionDTO.getBemerkung() : "");
            if (invoiceCorrectionDTO.getNewInvoiceNumber() != null && !invoiceCorrectionDTO.getNewInvoiceNumber().isEmpty()) {
                new Label(group, 0).setText("Korrigierte Rechnung");
                Link btnNewInvoice = new Link(group, 0);
                btnNewInvoice.setBackground(UiDesk.getColor("weiss"));
                btnNewInvoice.setText("<A>Rechnung " + invoiceCorrectionDTO.getNewInvoiceNumber() + " \u00f6ffnen</A>");
                btnNewInvoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        InvoiceCorrectionView.this.openInvoiceNr(invoiceCorrectionDTO.getNewInvoiceNumber());
                    }
                });
            }
            if (InvoiceCorrectionView.this.actualInvoice != null && !InvoiceCorrectionView.this.detailComposites.isEmpty()) {
                Label separator = new Label(group, 258);
                separator.setLayoutData((Object)new GridData(4, 4, true, false, 10, 1));
                List<IViewContribution> filtered = ViewContributionHelper.getFilteredAndPositionSortedContributions(InvoiceCorrectionView.this.detailComposites, 0);
                for (IViewContribution ivc : filtered) {
                    new Label(group, 0).setText(ivc.getLocalizedTitle());
                    Composite mainComposite = new Composite(group, 0);
                    mainComposite.setBackground(UiDesk.getColor("weiss"));
                    mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                    mainComposite.setLayout((Layout)new GridLayout(1, false));
                    ivc.initComposite(mainComposite);
                }
                InvoiceCorrectionView.this.detailComposites.forEach(dc -> dc.setDetailObject(InvoiceCorrectionView.this.actualInvoice, null));
            }
        }

        @Override
        public void setUnlocked(boolean unlocked) {
        }
    }
}

