/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.dialogs.KonsFilterDialog;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.HistoryDisplay;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Konsultation;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class KonsListe
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.HistoryView";
    HistoryDisplay liste;
    IPatient actPatient;
    ViewMenus menus;
    private Action filterAction;
    private KonsFilter filter;
    private ICoverage actCoverage;
    private IEncounter actEncounter;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);

    @Optional
    @Inject
    void compatitbility(@UIEventTopic(value="info/elexis/po/compatibility/*") Object object) {
        if (object instanceof IEncounter || object instanceof Class && object.equals(IEncounter.class)) {
            if (object instanceof IEncounter) {
                IEncounter encounter = (IEncounter)object;
                CoreModelServiceHolder.get().refresh((Identifiable)encounter, true);
                CoreModelServiceHolder.get().refresh((Identifiable)encounter.getCoverage(), true);
            }
            this.restart(true);
        }
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        if (this.actPatient == null || this.liste.lKons.isEmpty() || patient != null && !this.actPatient.getId().equals(patient.getId())) {
            this.actPatient = patient;
            this.restart(true);
        }
    }

    @Inject
    void activeCoverage(@Optional ICoverage iCoverage) {
        this.restart(false);
    }

    @Optional
    @Inject
    void changedCoverage(@UIEventTopic(value="info/elexis/model/*") ICoverage iCoverage) {
        if (iCoverage != null && !iCoverage.equals(this.actCoverage)) {
            this.restart(false);
            this.actCoverage = iCoverage;
        }
    }

    @Optional
    @Inject
    void changedEncounter(@UIEventTopic(value="info/elexis/model/*") IEncounter iEncounter) {
        if (iEncounter != null && !iEncounter.equals(this.actEncounter)) {
            this.restart(false);
            this.actEncounter = iEncounter;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.liste = new HistoryDisplay(parent, this.getViewSite());
        this.liste.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[]{this.filterAction});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        this.liste.stop();
        super.dispose();
    }

    public void setFocus() {
        this.liste.setFocus();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    private void restart(Boolean isPatientEvent) {
        if (this.liste != null) {
            this.liste.stop();
            if (isPatientEvent == null || isPatientEvent.booleanValue()) {
                this.liste.showLoading();
            }
            this.liste.load(this.actPatient);
            this.liste.start(this.filter);
        }
    }

    private void makeActions() {
        this.filterAction = new Action(Messages.KonsListe_FilterListAction, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.KonsListe_FilterListToolTip);
            }

            public void run() {
                if (!this.isChecked()) {
                    KonsListe.this.filter = null;
                } else {
                    KonsFilterDialog kfd = new KonsFilterDialog(KonsListe.this.actPatient, KonsListe.this.filter);
                    if (kfd.open() == 0) {
                        KonsListe.this.filter = kfd.getResult();
                    } else {
                        kfd = null;
                        this.setChecked(false);
                    }
                }
                KonsListe.this.restart(null);
            }
        };
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    @Deprecated
    public void reloadContents(Class clazz) {
        if (clazz.equals(Konsultation.class)) {
            this.restart(null);
        }
    }
}

