/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.interfaces.text.ITextResolver;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.ScriptUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Script;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextContainer {
    private static final String WARNING_SIGN = "??";
    public static final String MATCH_SQUARE_BRACKET = "[\\[\\]]";
    private static final String TEMPLATE_NOT_FOUND_HEADER = Messages.TextContainer_TemplateNotFoundHeader;
    private static final String TEMPLATE_NOT_FOUND_BODY = Messages.TextContainer_TemplateNotFoundBody;
    private ITextPlugin plugin = null;
    private static Logger log = LoggerFactory.getLogger(TextContainer.class);
    private Shell shell;
    private static final String DONT_SHOW_REPLACEMENT_ERRORS = "*";
    public static final String MATCH_TEMPLATE = "\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]";
    public static final String MATCH_INDIRECT_TEMPLATE = "\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+(\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+)+\\]";
    public static final String MATCH_GENDERIZE = "\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]";
    public static final String MATCH_EXISTS = "\\[[*]?[a-zA-Z\\.]+:exists?:[-a-zA-Z0-9\\.]:?[^\\]]*\\]";
    public static final String MATCH_IDATACCESS = "\\[[*]?[-_a-zA-Z0-9]+:[-a-zA-Z0-9]+:[-a-zA-Z0-9\\.]+:[-a-zA-Z0-9\\.]:?[^\\]]*\\]";
    public static final String MATCH_SQLCLAUSE = "\\[[*]?SQL[^:]*:[^\\[]+\\]";
    public static final String DISALLOWED_SQLEXPRESSIONS = "DROP,UPDATE,CREATE,INSERT";
    public static final String MATCH_SCRIPT = "\\[SCRIPT:[^\\[]+\\]";
    public static Connection queryConn = null;
    private List<String> dontShowErrorFor;

    public TextContainer() {
        if (this.plugin == null) {
            String ExtensionToUse = CoreHub.localCfg.get("briefe/Textmodul", null);
            IExtensionRegistry exr = Platform.getExtensionRegistry();
            IExtensionPoint exp = exr.getExtensionPoint("ch.elexis.core.ui.Text");
            if (exp != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = exp.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elems;
                    IExtension ex = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                    int n3 = elems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement el = iConfigurationElementArray[n4];
                        if (ExtensionToUse == null || el.getAttribute("name").equals(ExtensionToUse)) {
                            try {
                                this.plugin = (ITextPlugin)el.createExecutableExtension("Klasse");
                            }
                            catch (Exception e) {
                                ExHandler.handle((Throwable)e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (this.plugin == null) {
            this.plugin = new DefaultTextPlugin();
        }
        this.dontShowErrorFor = new ArrayList<String>();
    }

    public TextContainer(IViewSite s) {
        this();
        this.shell = s.getShell();
    }

    public TextContainer(Shell s) {
        this();
        this.shell = s;
    }

    public void setFocus() {
        this.plugin.setFocus();
    }

    public ITextPlugin getPlugin() {
        return this.plugin;
    }

    public void dispose() {
        this.plugin.dispose();
    }

    private Brief loadTemplate(String name) {
        Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
        return TextTemplate.findExistingTemplate(name, mandator != null ? mandator.getId() : null);
    }

    public Brief createFromTemplateName(Konsultation kons, String templatenameRaw, String typ, Kontakt adressat, String subject) {
        String suffix = CoreHub.localCfg.get("document_templates/suffix_station", "");
        Brief template = this.loadTemplate(String.valueOf(templatenameRaw) + suffix);
        if (template == null && suffix.length() > 0) {
            template = this.loadTemplate(templatenameRaw);
        }
        if (template == null) {
            SWTHelper.showError(TEMPLATE_NOT_FOUND_HEADER, String.valueOf(TEMPLATE_NOT_FOUND_BODY) + templatenameRaw);
            return null;
        }
        return this.createFromTemplate(kons, template, typ, adressat, subject);
    }

    public Brief createFromTemplate(Konsultation kons, Brief template, String typ, Kontakt adressat, String subject) {
        try {
            if (adressat == null && template.isAskForAddressee()) {
                KontaktSelektor ksel = new KontaktSelektor(this.shell, Kontakt.class, Messages.TextContainer_SelectDestinationHeader, Messages.TextContainer_SelectDestinationBody, Kontakt.DEFAULT_SORT);
                ksel.enableEmptyFieldButton(Messages.TextContainer_SelectNoDestinationLabel);
                if (ksel.open() != 0) {
                    return null;
                }
                adressat = (Kontakt)ksel.getSelection();
                if (adressat == null) {
                    this.dontShowErrorFor.add("Adressat");
                }
            }
            if (template == null) {
                if (this.plugin.createEmptyDocument()) {
                    Brief brief = new Brief(subject == null ? Messages.TextContainer_EmptyDocument : subject, null, (Kontakt)CoreHub.getLoggedInContact(), adressat, kons, typ);
                    this.addBriefToKons(brief, kons);
                    Brief brief2 = brief;
                    return brief2;
                }
            } else if (this.plugin.loadFromByteArray(template.loadBinary(), true)) {
                final Brief ret = new Brief(subject == null ? template.getBetreff() : subject, null, (Kontakt)CoreHub.getLoggedInContact(), adressat, kons, typ);
                this.plugin.initTemplatePrintSettings(template.getBetreff());
                this.plugin.findOrReplace(MATCH_TEMPLATE, new ReplaceCallback(){

                    public Object replace(String in) {
                        return TextContainer.this.replaceFields(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_INDIRECT_TEMPLATE, new ReplaceCallback(){

                    public Object replace(String in) {
                        return TextContainer.this.replaceIndirectFields(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_EXISTS, new ReplaceCallback(){

                    public String replace(String in) {
                        return TextContainer.this.exists(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_GENDERIZE, new ReplaceCallback(){

                    public String replace(String in) {
                        return TextContainer.this.genderize(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_IDATACCESS, new ReplaceCallback(){

                    public Object replace(String in) {
                        return ScriptUtil.loadDataFromPlugin((String)in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_SQLCLAUSE, new ReplaceCallback(){

                    public Object replace(String in) {
                        return TextContainer.this.replaceSQLClause(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.plugin.findOrReplace(MATCH_SCRIPT, new ReplaceCallback(){

                    public Object replace(String in) {
                        return TextContainer.this.executeScript(ret, in.replaceAll(TextContainer.MATCH_SQUARE_BRACKET, ""));
                    }
                });
                this.saveBrief(ret, typ);
                this.addBriefToKons(ret, kons);
                Brief brief = ret;
                return brief;
            }
            return null;
        }
        finally {
            this.dontShowErrorFor.clear();
        }
    }

    private Object replaceFields(Brief brief, String b) {
        String[] q;
        String bl = b;
        boolean showErrors = true;
        if (bl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            bl = bl.substring(1);
            showErrors = false;
        }
        if ((q = bl.split("\\.")).length != 2) {
            log.warn(String.valueOf(Messages.TextContainer_BadVariableFormat) + bl);
            return null;
        }
        if (q[0].equals("Datum")) {
            return new TimeTool().toString(4);
        }
        if (q[0].indexOf(":") != -1) {
            return ScriptUtil.loadDataFromPlugin((String)bl);
        }
        PersistentObject o = (PersistentObject)this.resolveObject(brief, q[0]);
        if (o == null || !o.exists()) {
            if (showErrors && !this.dontShowErrorFor.contains(q[0])) {
                return WARNING_SIGN + bl + WARNING_SIGN;
            }
            return "";
        }
        return this.readFromPo(o, q[1], showErrors);
    }

    private Object replaceIndirectFields(Brief brief, String field) {
        String[] tokens;
        String fieldl = field;
        boolean showErrors = true;
        if (fieldl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            fieldl = fieldl.substring(1);
            showErrors = false;
        }
        if ((tokens = fieldl.split("\\.")).length <= 2) {
            if (showErrors) {
                return WARNING_SIGN + fieldl + WARNING_SIGN;
            }
            return "";
        }
        String firstToken = tokens[0];
        String valueToken = tokens[tokens.length - 1];
        IPersistentObject first = this.resolveObject(brief, firstToken);
        if (first == null) {
            if (showErrors) {
                return WARNING_SIGN + fieldl + WARNING_SIGN;
            }
            return "";
        }
        IPersistentObject current = first;
        int i = 1;
        while (i < tokens.length - 1) {
            IPersistentObject next = this.resolveIndirectObject(current, tokens[i]);
            if (next == null) {
                if (showErrors) {
                    return WARNING_SIGN + fieldl + WARNING_SIGN;
                }
                return "";
            }
            current = next;
            ++i;
        }
        return this.readFromPo((PersistentObject)current, valueToken, showErrors);
    }

    private String readFromPo(PersistentObject po, String name, boolean showErrors) {
        Optional<String> value = this.readUsingDataAccessExtension(po, name);
        if (value.isPresent()) {
            return value.get();
        }
        String ret = po.get(name);
        if (ret == null || ret.startsWith("**")) {
            Map ext;
            String an;
            if (!po.map("ExtInfo").startsWith("**") && (an = (String)(ext = po.getMap("ExtInfo")).get(name)) != null) {
                return an;
            }
            log.warn("Nicht erkanntes Feld in " + name);
            if (showErrors) {
                return WARNING_SIGN + name + WARNING_SIGN;
            }
            return "";
        }
        if (ret.startsWith("<?xml")) {
            Samdas samdas = new Samdas(ret);
            ret = samdas.getRecordText();
        }
        return ret;
    }

    private Optional<String> readUsingDataAccessExtension(Object object, String name) {
        List placeholderExtensions = Extensions.getExtensions((String)"ch.elexis.core.data.DataAccess", (String)"TextPlaceHolder");
        for (IConfigurationElement iConfigurationElement : placeholderExtensions) {
            if (!name.equals(iConfigurationElement.getAttribute("name")) || !object.getClass().getName().equals(iConfigurationElement.getAttribute("type"))) continue;
            try {
                ITextResolver resolver = (ITextResolver)iConfigurationElement.createExecutableExtension("resolver");
                return resolver.resolve(object);
            }
            catch (CoreException e) {
                log.warn("Error getting resolver for name [" + name + "] object [" + object + "]");
            }
        }
        return Optional.empty();
    }

    private IPersistentObject resolveIndirectObject(IPersistentObject parent, String field) {
        if (parent instanceof Fall) {
            String fieldl = field;
            if (fieldl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
                fieldl = fieldl.substring(1);
            }
            Fall fall = (Fall)parent;
            return fall.getReferencedObject(fieldl);
        }
        if (parent instanceof Mandant) {
            String fieldl = field;
            if (fieldl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
                fieldl = fieldl.substring(1);
            }
            Mandant mandant = (Mandant)parent;
            return mandant.getReferencedObject(fieldl);
        }
        if (parent instanceof Patient) {
            String fieldl = field;
            if (fieldl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
                fieldl = fieldl.substring(1);
            }
            Patient patient = (Patient)parent;
            return patient.getReferencedObject(fieldl);
        }
        return null;
    }

    private String executeScript(Brief ret, String in) {
        String[] q = in.split(":");
        if (q.length != 2) {
            log.error("Falsches SCRIPT format: " + in);
            return "???SYNTAX???";
        }
        try {
            Object result = Script.executeScript((String)q[1], (PersistentObject[])new PersistentObject[]{ret});
            return result == null ? q[1] : result.toString();
        }
        catch (ElexisException e) {
            SWTHelper.showError("Fehler beim Ausf\u00fchren des Scripts", e.getMessage());
            return "??SCRIPT ERROR??";
        }
    }

    private String exists(Brief brief, String in) {
        String firstToken;
        IPersistentObject first;
        String[] tokens;
        String[] q;
        IPersistentObject o;
        String inl = in;
        if (inl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            inl = inl.substring(1);
        }
        if ((o = this.resolveObject(brief, (q = inl.split(":"))[0])) == null && (tokens = q[0].split("\\.")).length >= 2 && (first = this.resolveObject(brief, firstToken = tokens[0])) != null) {
            IPersistentObject current = first;
            int i = 1;
            while (i < tokens.length) {
                String value;
                IPersistentObject next = this.resolveIndirectObject(current, tokens[i]);
                if (next == null && current instanceof PersistentObject && StringUtils.isNotEmpty((CharSequence)(value = this.readFromPo((PersistentObject)current, tokens[i], false)))) break;
                current = next;
                ++i;
            }
            o = current;
        }
        if (o != null) {
            return q[2];
        }
        return "";
    }

    private String genderize(Brief brief, String in) {
        String[] q;
        IPersistentObject o;
        String inl = in;
        boolean showErrors = true;
        if (inl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            inl = inl.substring(1);
            showErrors = false;
        }
        if ((o = this.resolveObject(brief, (q = inl.split(":"))[0])) == null) {
            if (showErrors) {
                return "???";
            }
            return "";
        }
        if (q.length != 3) {
            log.error("falsches genderize Format " + inl);
            return null;
        }
        if (!(o instanceof Kontakt)) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForContactsOnly;
            }
            return "";
        }
        Kontakt k = (Kontakt)o;
        String[] g = q[2].split("/");
        if (g.length < 2) {
            if (showErrors) {
                return Messages.TextContainer_BadFieldDefinition;
            }
            return "";
        }
        if (k.istPerson()) {
            Person p = Person.load((String)k.getId());
            if (p.get("Geschlecht").equals("m")) {
                if (q[1].startsWith("m")) {
                    return g[0];
                }
                return g[1];
            }
            if (q[1].startsWith("w")) {
                return g[0];
            }
            return g[1];
        }
        if (g.length < 3) {
            if (showErrors) {
                return Messages.TextContainer_FieldTypeForPersonsOnly;
            }
            return "";
        }
        return g[2];
    }

    private IPersistentObject resolveObject(Brief actBrief, String k) {
        String kl = k;
        if (kl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            kl = kl.substring(1);
        }
        Mandant ret = null;
        if (kl.equalsIgnoreCase("Mandant")) {
            ret = CoreHub.actMandant;
        } else if (kl.equalsIgnoreCase("Anwender")) {
            ret = CoreHub.getLoggedInContact();
        } else if (kl.equalsIgnoreCase("Adressat")) {
            ret = actBrief.getAdressat();
        } else {
            try {
                String fqname = "ch.elexis.data." + kl;
                ret = ElexisEventDispatcher.getSelected(Class.forName(fqname));
            }
            catch (Throwable ex) {
                log.warn(String.valueOf(Messages.TextContainer_UnrecognizedFieldType) + kl);
                ret = null;
            }
        }
        if (ret == null) {
            log.warn(String.valueOf(Messages.TextContainer_UnrecognizedFieldType) + kl);
        }
        return ret;
    }

    public static String replaceSQLClause(String b) {
        TextContainer tmpMe = new TextContainer();
        String result = (String)tmpMe.replaceSQLClause(null, b);
        tmpMe.dispose();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object replaceSQLClause(Brief brief, String b) {
        String bl = b;
        boolean showErrors = true;
        if (bl.substring(0, 1).equalsIgnoreCase(DONT_SHOW_REPLACEMENT_ERRORS)) {
            bl = bl.substring(1);
            showErrors = false;
        }
        JdbcLink j = PersistentObject.getConnection();
        JdbcLink.Stm stm = j.getStatement();
        String sql = bl;
        String sqlPrefix = sql.split(":")[0];
        String[] sqlPrefixParts = sqlPrefix.split("\\|");
        String fieldDelimiter = "\t";
        String rowDelimiter = "\n";
        if (sqlPrefixParts.length > 1) {
            fieldDelimiter = sqlPrefixParts[1];
            fieldDelimiter = this.convertSpecialCharacters(fieldDelimiter);
        }
        if (sqlPrefixParts.length > 2) {
            rowDelimiter = sqlPrefixParts[2];
            rowDelimiter = this.convertSpecialCharacters(rowDelimiter);
        }
        sql = sql.substring(sqlPrefix.length() + 1);
        String[] disallowedList = DISALLOWED_SQLEXPRESSIONS.split(",");
        int i = 0;
        while (i < disallowedList.length) {
            String disallowed = disallowedList[i];
            Pattern p = Pattern.compile("[^_^\\w]*" + disallowed + "\\s", 8);
            Matcher m = p.matcher(sql);
            if (m.find()) {
                return "??? '" + disallowed + "' ist in SQL-Platzhaltern nicht erlaubt ???";
            }
            ++i;
        }
        Pattern p = Pattern.compile("extinfo:[\\w]+\\.[\\w]+[^\\w]", 8);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String part = m.group();
            String stringWithoutDelim = part.substring(0, part.length() - 1);
            String delim = part.substring(part.length() - 1);
            String tablePart = stringWithoutDelim.substring("extinfo:".length()).split("\\.")[0];
            sql = sql.replace(m.group(), "'" + stringWithoutDelim + "', " + tablePart + ".extinfo" + delim);
        }
        if (queryConn == null) {
            queryConn = j.getKeepAliveConnection();
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = queryConn.createStatement();
            rs = statement.executeQuery(sql);
        }
        catch (SQLException e1) {
            j.releaseStatement(stm);
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException tablePart) {
                // empty catch block
            }
            if (!showErrors) return "";
            return "[???" + bl + " ***" + e1.getMessage() + "*** ???]";
        }
        String fieldContent = "";
        String result = "";
        String lRowDelimiter = "";
        try {
            block14: while (rs.next()) {
                String delimiter = "";
                result = String.valueOf(result) + lRowDelimiter;
                lRowDelimiter = rowDelimiter;
                int i2 = 1;
                while (i2 < 1000) {
                    try {
                        fieldContent = rs.getString(i2);
                        if (fieldContent.length() >= "extinfo:".length() && fieldContent.substring(0, "extinfo:".length()).equalsIgnoreCase("extinfo:")) {
                            byte[] blob;
                            String extInfoSpec = fieldContent.substring("extinfo:".length());
                            String extInfoField = extInfoSpec.split("\\.")[1];
                            if ((blob = rs.getBytes(++i2)) == null) {
                                fieldContent = "";
                            } else {
                                Hashtable ht = this.fold(blob);
                                fieldContent = (String)ht.get(extInfoField);
                            }
                        }
                        result = String.valueOf(result) + delimiter + (fieldContent == null ? "" : fieldContent);
                        delimiter = fieldDelimiter;
                    }
                    catch (Exception e) {
                        continue block14;
                    }
                    ++i2;
                }
            }
        }
        catch (SQLException e) {
            j.releaseStatement(stm);
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!showErrors) return "";
            return "[???" + bl + " ***" + e.getMessage() + "*** ???]";
        }
        j.releaseStatement(stm);
        try {
            statement.close();
            return result;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private Hashtable fold(byte[] flat) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(flat);
            ZipInputStream zis = new ZipInputStream(bais);
            zis.getNextEntry();
            ObjectInputStream ois = new ObjectInputStream(zis);
            Hashtable res = (Hashtable)ois.readObject();
            ois.close();
            bais.close();
            return res;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }

    private String convertSpecialCharacters(String in) {
        String result = in;
        result = result.replaceAll("\\\\n", "\n");
        result = result.replaceAll("\\\\t", "\t");
        result = result.replaceAll("\\\\b", "\b");
        result = result.replaceAll("\\\\r", "\r");
        result = result.replaceAll("\\\\f", "\f");
        return result;
    }

    private void addBriefToKons(Brief brief, Konsultation kons) {
        if (kons != null && LocalLockServiceHolder.get().acquireLock((Object)kons).isOk()) {
            String label = "[ " + brief.getLabel() + " ]";
            kons.addXRef("ch.elexis.text.DocXRef", brief.getId(), -1, label);
            LocalLockServiceHolder.get().releaseLock((Object)kons);
        }
    }

    public void saveBrief(Brief brief, String typ) {
        if (brief == null) {
            log.info("ch.elexis.views/TextContainer.java saveBrief(): WARNING: brief == null");
        }
        if (brief == null || brief.getAdressat() == null) {
            KontaktSelektor ksl;
            if (Konsultation.getAktuelleKons() != null) {
                log.debug("ch.elexis.views/TextContainer.java saveBrief(): Konsultation.getAktuelleKons()==" + Konsultation.getAktuelleKons() + ": " + Konsultation.getAktuelleKons().getDatum());
            }
            if ((ksl = new KontaktSelektor(this.shell, Kontakt.class, Messages.TextContainer_SelectAdresseeHeader, Messages.TextContainer_SelectAdresseeBody, Kontakt.DEFAULT_SORT)).open() == 0) {
                log.debug("ch.elexis.views/TextContainer.java saveBrief(): about to brief = new Brief(...)");
                brief = new Brief(Messages.TextContainer_Letter, null, (Kontakt)CoreHub.getLoggedInContact(), (Kontakt)ksl.getSelection(), Konsultation.getAktuelleKons(), typ);
            }
        }
        if (brief != null) {
            byte[] contents;
            if (StringTool.isNothing((Object)brief.getBetreff())) {
                InputDialog dlg = new InputDialog(this.shell, Messages.TextContainer_SaveDocumentHeader, Messages.TextContainer_SaveDocumentBody, brief.getBetreff(), null);
                if (dlg.open() == 0) {
                    brief.setBetreff(dlg.getValue());
                } else {
                    brief.setBetreff(brief.getTyp());
                }
            }
            if ((contents = this.plugin.storeToByteArray()) == null) {
                log.debug("ch.elexis.views/TextContainer.java saveBrief(): WARNING: contents == null - still proceding to brief.save(contents,...)...");
                log.error(Messages.TextContainer_NullSaveHeader);
            }
            brief.save(contents, this.plugin.getMimeType());
            log.info(String.format("saveBrief %s", brief.getLabel()));
            ElexisEventDispatcher.reload(Brief.class);
        }
    }

    public void saveTemplate(String name) {
        SaveTemplateDialog std = new SaveTemplateDialog(this.shell, name);
        if (std.open() == 0) {
            byte[] tmpl;
            String title = std.title;
            Brief brief = new Brief(title, null, (Kontakt)CoreHub.getLoggedInContact(), (Kontakt)std.selectedMand, null, "Vorlagen");
            if (std.bSysTemplate) {
                brief.set("BehandlungsID", "SYS");
            }
            if ((tmpl = this.plugin.storeToByteArray()) == null) {
                log.error(Messages.TextContainer_NullSaveBody);
            }
            brief.save(tmpl, this.plugin.getMimeType());
            DocumentSelectDialog.setDontAskForAddresseeForThisTemplate(brief, std.dontShowAddresseeSelection);
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, Brief.class, 8)});
        }
    }

    public boolean open(Brief brief) {
        log.info("open: " + brief.getLabel());
        byte[] arr = brief.loadBinary();
        if (arr == null) {
            log.debug("ch.elexis.views/TextContainer.java open(): WARNING: arr == null -> about to return false...");
            log.warn(String.valueOf(Messages.TextContainer_ErroneousLetter) + brief.getLabel());
            return false;
        }
        log.info("open: " + brief.getLabel());
        return this.plugin.loadFromByteArray(arr, false);
    }

    public boolean replace(String pattern, ReplaceCallback cb) {
        return this.plugin.findOrReplace(pattern, cb);
    }

    public boolean replace(String pattern, final String repl) {
        return this.plugin.findOrReplace(pattern, new ReplaceCallback(){

            public String replace(String in) {
                return repl;
            }
        });
    }

    public Konsultation getAktuelleKons() {
        Konsultation ret = Konsultation.getAktuelleKons();
        if (ret == null) {
            SelectFallDialog sfd = new SelectFallDialog(UiDesk.getTopShell());
            sfd.open();
            if (sfd.result == null) {
                MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)ch.elexis.core.ui.views.Messages.TextView_NoCaseSelected, (String)ch.elexis.core.ui.views.Messages.TextView_SaveNotPossibleNoCaseAndKonsSelected);
                return null;
            }
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)sfd.result);
            ret = ((Fall)ElexisEventDispatcher.getSelected(Fall.class)).neueKonsultation();
            ret.setMandant(CoreHub.actMandant);
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)ret);
        }
        return ret;
    }

    static class DefaultTextPlugin
    implements ITextPlugin {
        private static final String expl = String.valueOf(Messages.TextContainer_NoPlugin1) + Messages.TextContainer_NoPlugin2 + Messages.Text_No_Plugin_loaded + Messages.Text_Plugin_Not_Configured + Messages.Text_External_Cmd_deleted;

        DefaultTextPlugin() {
        }

        @Override
        public Composite createContainer(Composite parent, ITextPlugin.ICallback h) {
            parent.setLayout((Layout)new FillLayout());
            Form form = UiDesk.getToolkit().createForm(parent);
            form.setText(Messages.Core_Unable_to_create_text);
            form.getBody().setLayout((Layout)new FillLayout());
            FormText ft = UiDesk.getToolkit().createFormText(form.getBody(), false);
            ft.setText(expl, true, false);
            return form.getBody();
        }

        @Override
        public void dispose() {
        }

        @Override
        public void showMenu(boolean b) {
        }

        @Override
        public void showToolbar(boolean b) {
        }

        @Override
        public boolean createEmptyDocument() {
            return false;
        }

        @Override
        public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
            return false;
        }

        @Override
        public boolean findOrReplace(String pattern, ReplaceCallback cb) {
            return false;
        }

        @Override
        public byte[] storeToByteArray() {
            return null;
        }

        @Override
        public boolean clear() {
            return false;
        }

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        }

        @Override
        public boolean loadFromStream(InputStream is, boolean asTemplate) {
            return false;
        }

        @Override
        public boolean print(String printer, String tray, boolean waitUntilFinished) {
            return false;
        }

        @Override
        public boolean insertTable(String marke, int props, String[][] contents, int[] columnSizes) {
            return false;
        }

        @Override
        public void setFocus() {
        }

        @Override
        public ITextPlugin.PageFormat getFormat() {
            return ITextPlugin.PageFormat.USER;
        }

        @Override
        public void setFormat(ITextPlugin.PageFormat f) {
        }

        @Override
        public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
            return null;
        }

        @Override
        public boolean setFont(String name, int style, float size) {
            return false;
        }

        @Override
        public boolean setStyle(int style) {
            return false;
        }

        @Override
        public Object insertText(String marke, String text, int adjust) {
            return null;
        }

        @Override
        public Object insertText(Object pos, String text, int adjust) {
            return null;
        }

        @Override
        public String getMimeType() {
            return "text/nothing";
        }

        @Override
        public void setSaveOnFocusLost(boolean bSave) {
        }

        @Override
        public boolean isDirectOutput() {
            return false;
        }

        @Override
        public void setParameter(ITextPlugin.Parameter parameter) {
        }

        @Override
        public void initTemplatePrintSettings(String template) {
        }
    }

    class SaveTemplateDialog
    extends TitleAreaDialog {
        Text name;
        Combo cMands;
        String title;
        Button btSysTemplate;
        boolean bSysTemplate;
        List<Mandant> lMands;
        Mandant selectedMand;
        String tmplName;
        Button checkBoxDontShowAddresseeSelection;
        boolean dontShowAddresseeSelection;

        protected SaveTemplateDialog(Shell parentShell, String templateName) {
            super(parentShell);
            this.tmplName = templateName;
        }

        public void create() {
            super.create();
            this.setTitle(Messages.TextContainer_SaveTemplateHeader);
            this.setMessage(Messages.TextContainer_SaveTemplateBody);
            this.getShell().setText(Messages.TextContainer_Template);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            ret.setLayout((Layout)new GridLayout());
            new Label(ret, 0).setText(Messages.TextContainer_TemplateName);
            this.name = new Text(ret, 2048);
            this.name.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Mandant lMand;
                    String mandatorID;
                    boolean isSysTemplate = SaveTemplateDialog.this.isSystemTemplate(SaveTemplateDialog.this.name.getText());
                    SaveTemplateDialog.this.btSysTemplate.setSelection(isSysTemplate);
                    SaveTemplateDialog.this.checkBoxDontShowAddresseeSelection.setSelection(isSysTemplate);
                    SaveTemplateDialog.this.checkBoxDontShowAddresseeSelection.setEnabled(!isSysTemplate);
                    if (!isSysTemplate) {
                        SaveTemplateDialog.this.checkBoxDontShowAddresseeSelection.setSelection(DocumentSelectDialog.getDontAskForAddresseeForThisTemplateName(SaveTemplateDialog.this.name.getText()));
                    }
                    Brief brief = SaveTemplateDialog.this.getBriefForTemplateName(SaveTemplateDialog.this.name.getText());
                    String lMandator = "";
                    if (brief != null && (mandatorID = brief.get("DestID")) != null && (lMand = Mandant.load((String)mandatorID)).exists()) {
                        lMandator = lMand.get("Bezeichnung3");
                    }
                    SaveTemplateDialog.this.cMands.setText(lMandator);
                }
            });
            new Label(ret, 0).setText(Messages.Core_Mandator);
            Composite line = new Composite(ret, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            line.setLayout((Layout)gridLayout);
            line.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.cMands = new Combo(line, 4);
            Query qbe = new Query(Mandant.class);
            this.lMands = qbe.execute();
            this.cMands.add(Messages.Core_All);
            for (Mandant m : this.lMands) {
                this.cMands.add(m.getLabel());
            }
            this.btSysTemplate = new Button(line, 32);
            this.btSysTemplate.setText(Messages.TextContainer_SystemTemplate);
            this.btSysTemplate.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SaveTemplateDialog.this.checkBoxDontShowAddresseeSelection.setEnabled(!SaveTemplateDialog.this.btSysTemplate.getSelection());
                    if (SaveTemplateDialog.this.btSysTemplate.getSelection()) {
                        SaveTemplateDialog.this.checkBoxDontShowAddresseeSelection.setSelection(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.checkBoxDontShowAddresseeSelection = new Button(ret, 32);
            this.checkBoxDontShowAddresseeSelection.setText(Messages.TextContainer_DontAskForAddressee);
            this.checkBoxDontShowAddresseeSelection.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            if (this.tmplName != null) {
                this.name.setText(this.tmplName);
            }
            this.name.setSelection(32000);
            return ret;
        }

        protected void okPressed() {
            List<Brief> existing;
            this.title = this.name.getText();
            if (this.title.length() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TextContainer_TemplateTitleEmptyCaption, (String)Messages.TextContainer_TemplateTitleEmptyBody);
                return;
            }
            this.bSysTemplate = this.btSysTemplate.getSelection();
            int i = this.cMands.getSelectionIndex();
            if (i != -1) {
                this.selectedMand = i == 0 ? null : this.lMands.get(i - 1);
            }
            if ((existing = TextTemplate.findExistingTemplates(this.bSysTemplate, this.title, null, this.selectedMand != null ? this.selectedMand.getId() : null)).size() > 0) {
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.TextContainer_TemplateExistsCaption, (String)Messages.TextContainer_TemplateExistsBody)) {
                    existing.forEach(b -> {
                        boolean bl = b.delete();
                    });
                } else {
                    return;
                }
            }
            this.dontShowAddresseeSelection = this.checkBoxDontShowAddresseeSelection.getSelection();
            super.okPressed();
        }

        Brief getBriefForTemplateName(String templateName) {
            Query qry = new Query(Brief.class);
            qry.add("Betreff", "=", templateName, true);
            qry.add("Typ", "=", "Vorlagen", true);
            List result = qry.execute();
            if (result.size() > 0) {
                return (Brief)result.get(0);
            }
            return null;
        }

        boolean isSystemTemplate(String templateName) {
            Query qry = new Query(Brief.class);
            qry.add("Betreff", "=", templateName, true);
            qry.add("Typ", "=", "Vorlagen", true);
            qry.add("BehandlungsID", "=", "SYS", true);
            List result = qry.execute();
            return result.size() > 0;
        }
    }
}

