/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.coolbar.MandantSelectionContributionItem;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.dialogs.ChangePasswordDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.TotpDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.inputs.PrefAccessDenied;
import ch.elexis.core.ui.util.BooleanNotConverter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.Role;
import ch.elexis.data.User;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.swt.SWTResourceManager;

public class UserManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IUnlockable {
    private TableViewer tableViewerUsers;
    private WritableValue<User> wvUser = new WritableValue(null, User.class);
    private WritableValue<Anwender> wvAnwender = new WritableValue(null, Anwender.class);
    private Button btnIsExecutiveDoctor;
    private Label lblRespPhysColor;
    private Group grpAccounting;
    public static final String CHANGE_LINK = "<a>\u00e4ndern</a>";
    private Link linkContact;
    private CheckboxTableViewer checkboxTableViewerAssociation;
    private CheckboxTableViewer checkboxTableViewerRoles;
    private Link linkChangePassword;
    private Button btnUserIsAdmin;
    private Button btnMandatorIsInactive;
    private Color lblRespPhysColorDefColor;
    private Link linkRechnungssteller;
    private RestrictedAction addUserAction;
    private RestrictedAction deleteUserAction;
    private RestrictedAction lockUserAction;
    private Button btnUserIsLocked;
    private Link linkTotp;
    private Button btnAllowExternalAccess;
    private Label userInfoLabel;

    public UserManagementPreferencePage() {
        this.setTitle("Benutzerverwaltung");
        this.noDefaultAndApplyButton();
    }

    public Control createContents(Composite parent) {
        if (!CoreHub.acl.request(AccessControlDefaults.ACL_USERS)) {
            return new PrefAccessDenied(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        MenuManager popManager = new MenuManager();
        this.addUserAction = new RestrictedAction(AccessControlDefaults.USER_CREATE, Messages.Core_Add_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            @Override
            public void doRun() {
                IInputValidator iiv = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() < 3) {
                            return "Mindestens 3 Zeichen";
                        }
                        boolean allLettersOrDigits = newText.chars().allMatch(x -> Character.isLetterOrDigit(x));
                        if (!allLettersOrDigits) {
                            return "Nur Buchstaben und Zahlen erlaubt";
                        }
                        boolean isFree = User.verifyUsernameNotTaken((String)newText);
                        if (!isFree) {
                            return "Benuterzname vergeben (evtl. f\u00fcr gel\u00f6schten Benutzer)";
                        }
                        return null;
                    }
                };
                InputDialog id = new InputDialog(Hub.getActiveShell(), "Benutzernamen festlegen", "Benutzernamen festlegen - dieser kann nicht mehr ge\u00e4ndert, sowie zuk\u00fcnftig anderweitig verwendet werden.", null, iiv);
                int retVal = id.open();
                if (retVal == 0) {
                    User newUser = new User(null, id.getValue(), "");
                    UserManagementPreferencePage.this.updateUserList();
                    UserManagementPreferencePage.this.tableViewerUsers.setSelection((ISelection)new StructuredSelection((Object)newUser));
                }
            }
        };
        popManager.add((IAction)this.addUserAction);
        this.deleteUserAction = new LockedRestrictedAction<User>(AccessControlDefaults.USER_DELETE, Messages.Core_Delete){

            @Override
            public User getTargetedObject() {
                if (UserManagementPreferencePage.this.tableViewerUsers == null) {
                    return null;
                }
                StructuredSelection ss = (StructuredSelection)UserManagementPreferencePage.this.tableViewerUsers.getSelection();
                return ss != null ? (User)ss.getFirstElement() : null;
            }

            @Override
            public void doRun(User user) {
                IUser currentUser = ContextServiceHolder.get().getActiveUser().orElse(null);
                if (currentUser != null) {
                    if (currentUser.getId().equals(user.getId())) {
                        MessageDialog.openWarning((Shell)UserManagementPreferencePage.this.getShell(), (String)"Warnung", (String)"Dieser Benutzer ist gerade eingeloggt und kann daher nicht entfernt werden!");
                    } else {
                        user.delete();
                        UserManagementPreferencePage.this.updateUserList();
                        UserManagementPreferencePage.this.wvUser.setValue(null);
                        UserManagementPreferencePage.this.wvAnwender.setValue(null);
                    }
                }
            }
        };
        popManager.add((IAction)this.deleteUserAction);
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            this.lockUserAction = new RestrictedAction(AccessControlDefaults.USER_CREATE, Messages.Leistungscodes_editItem){

                @Override
                public void doRun() {
                    StructuredSelection ss = (StructuredSelection)UserManagementPreferencePage.this.tableViewerUsers.getSelection();
                    User u = (User)ss.getFirstElement();
                    LockResponse acquireLock = LocalLockServiceHolder.get().acquireLock((Object)u);
                    if (acquireLock.isOk()) {
                        UserManagementPreferencePage.this.setUnlocked(true);
                    }
                }

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_LOCK_OPEN.getImageDescriptor();
                }
            };
            popManager.add((IAction)this.lockUserAction);
        }
        popManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserManagementPreferencePage.this.addUserAction.reflectRight();
                UserManagementPreferencePage.this.deleteUserAction.reflectRight();
                if (UserManagementPreferencePage.this.lockUserAction != null) {
                    UserManagementPreferencePage.this.lockUserAction.reflectRight();
                }
            }
        });
        SashForm sash = new SashForm(container, 256);
        sash.setLayout((Layout)new GridLayout(2, false));
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite compositeLeft = new Composite((Composite)sash, 0);
        compositeLeft.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeLeft = new GridLayout(1, false);
        gl_compositeLeft.marginWidth = 0;
        gl_compositeLeft.marginHeight = 0;
        compositeLeft.setLayout((Layout)gl_compositeLeft);
        Composite compositeButtons = new Composite(compositeLeft, 0);
        compositeButtons.setLayout((Layout)new FillLayout(256));
        compositeButtons.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnAdd = new Button(compositeButtons, 0x800000);
        btnAdd.setImage(Images.IMG_NEW.getImage());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementPreferencePage.this.addUserAction.doRun();
            }
        });
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            final Button btnLock = new Button(compositeButtons, 0x800002);
            btnLock.setSelection(LocalLockServiceHolder.get().isLocked((Object)((IPersistentObject)this.wvUser.getValue())));
            btnLock.setImage(Images.IMG_LOCK_OPEN.getImage());
            btnLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IPersistentObject user = (IPersistentObject)UserManagementPreferencePage.this.wvUser.getValue();
                    if (LocalLockServiceHolder.get().isLocked((Object)user)) {
                        LocalLockServiceHolder.get().releaseLock((Object)user);
                    } else {
                        UserManagementPreferencePage.this.lockUserAction.doRun();
                    }
                    boolean locked = LocalLockServiceHolder.get().isLocked((Object)((IPersistentObject)UserManagementPreferencePage.this.wvUser.getValue()));
                    btnLock.setSelection(locked);
                    UserManagementPreferencePage.this.setUnlocked(locked);
                }
            });
        }
        Composite compositeSelectorTable = new Composite(compositeLeft, 0);
        compositeSelectorTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_compositeSelectorTable = new TableColumnLayout();
        compositeSelectorTable.setLayout((Layout)tcl_compositeSelectorTable);
        Composite compositeEdit = new Composite((Composite)sash, 0);
        GridLayout gl_compositeEdit = new GridLayout(2, false);
        gl_compositeEdit.horizontalSpacing = 0;
        gl_compositeEdit.verticalSpacing = 0;
        gl_compositeEdit.marginWidth = 0;
        gl_compositeEdit.marginHeight = 0;
        compositeEdit.setLayout((Layout)gl_compositeEdit);
        compositeEdit.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.userInfoLabel = new Label(compositeEdit, 0);
        this.userInfoLabel.setForeground(SWTResourceManager.getColor(1));
        this.userInfoLabel.setBackground(SWTResourceManager.getColor(23));
        this.userInfoLabel.setFont(SWTResourceManager.getFont(".AppleSystemUIFont", 14, 1));
        this.userInfoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(compositeEdit, 0);
        this.tableViewerUsers = new TableViewer(compositeSelectorTable, 67584);
        this.tableViewerUsers.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tableUsers = this.tableViewerUsers.getTable();
        tableUsers.setLinesVisible(true);
        this.tableViewerUsers.addSelectionChangedListener(e -> {
            this.releaseLockIfRequired();
            StructuredSelection ss = (StructuredSelection)e.getSelection();
            this.wvUser.setValue(ss == null ? null : (User)ss.getFirstElement());
            this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
            compositeEdit.layout(true, true);
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewerUsers, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tcl_compositeSelectorTable.setColumnData((Widget)tblclmnName, (ColumnLayoutData)new ColumnWeightData(100));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new AnwenderCellLabelProvider());
        Menu menu = popManager.createContextMenu((Control)tableUsers);
        tableUsers.setMenu(menu);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        Group grpSysAccess = new Group(compositeEdit, 0);
        grpSysAccess.setText("Systemzugang");
        grpSysAccess.setLayout((Layout)new GridLayout(3, true));
        grpSysAccess.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.linkChangePassword = new Link((Composite)grpSysAccess, 0);
        this.linkChangePassword.setText("<a>Passwort \u00e4ndern</a>");
        this.linkChangePassword.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.linkChangePassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                new ChangePasswordDialog(UiDesk.getTopShell(), user).open();
            }
        });
        this.btnUserIsAdmin = new Button((Composite)grpSysAccess, 32);
        this.btnUserIsAdmin.setToolTipText("Administratoren unterliegen keinerlei Beschr\u00e4nkungen.");
        this.btnUserIsAdmin.setText("Administrator");
        this.btnUserIsLocked = new Button((Composite)grpSysAccess, 32);
        this.btnUserIsLocked.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnUserIsLocked.setToolTipText("Sperrt die M\u00f6glichkeit sich am System anzumelden.");
        this.btnUserIsLocked.setText("Zugang sperren");
        this.linkTotp = new Link((Composite)grpSysAccess, 0);
        this.linkTotp.setText("<a>Einmalkennwort</a>");
        this.linkTotp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                new TotpDialog(UiDesk.getTopShell(), user).open();
            }
        });
        this.btnAllowExternalAccess = new Button((Composite)grpSysAccess, 32);
        this.btnAllowExternalAccess.setToolTipText("Diese Option aktiviert den Zugriff \u00fcber die Schnittstellen des Elexis-Servers");
        this.btnAllowExternalAccess.setText("Externer Zugriff");
        new Label((Composite)grpSysAccess, 0);
        this.btnAllowExternalAccess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                if (((Button)e.getSource()).getSelection()) {
                    MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)"Aktivierung des externen Zugangs", (String)"Um den externen Zugang zu aktivieren, muss ein starkes Passwort gesetzt, sowie das Einmalkennwort konfiguriert sein. Dies geschieht in den folgenden Dialogen.");
                    int password = new ChangePasswordDialog(UiDesk.getTopShell(), user).open();
                    if (password != 0) {
                        MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)"Starkes Passwort ben\u00f6tigt", (String)"F\u00fcr den externen Zugriff wird ein starkes Passwort ben\u00f6tigt.");
                    } else {
                        new TotpDialog(UiDesk.getTopShell(), user).open();
                        user.set("ALLOW_EXTERNAL", "1");
                    }
                } else {
                    user.set("ALLOW_EXTERNAL", "0");
                }
                UserManagementPreferencePage.this.btnAllowExternalAccess.setSelection(user.get("ALLOW_EXTERNAL").equals("1"));
            }
        });
        this.grpAccounting = new Group(compositeEdit, 0);
        this.grpAccounting.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.grpAccounting.setText("Verrechnung");
        GridLayout gl_grpAccounting = new GridLayout(1, false);
        gl_grpAccounting.marginHeight = 5;
        this.grpAccounting.setLayout((Layout)gl_grpAccounting);
        Composite compositeContact = new Composite((Composite)this.grpAccounting, 0);
        GridLayout gl_compositeContact = new GridLayout(2, false);
        gl_compositeContact.horizontalSpacing = 0;
        gl_compositeContact.verticalSpacing = 0;
        gl_compositeContact.marginWidth = 0;
        gl_compositeContact.marginHeight = 0;
        compositeContact.setLayout((Layout)gl_compositeContact);
        compositeContact.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label lblKontakt = new Label(compositeContact, 0);
        lblKontakt.setText("Kontakt: ");
        this.linkContact = new Link(compositeContact, 0);
        this.linkContact.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.linkContact.setText("nicht gesetzt <a>\u00e4ndern</a>");
        this.linkContact.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Person.class, "Kontakt ausw\u00e4hlen", "Bitte selektieren Sie den zugeordneten Kontakt", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Person p = (Person)ks.getSelection();
                    p.set("istAnwender", "1");
                    user.setAssignedContact((Kontakt)p);
                    UserManagementPreferencePage.this.linkContact.setText(String.valueOf(p.getPersonalia()) + " " + UserManagementPreferencePage.CHANGE_LINK);
                }
            }
        });
        Composite compositeIsRespPhys = new Composite((Composite)this.grpAccounting, 2048);
        compositeIsRespPhys.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeIsRespPhys = new GridLayout(2, false);
        gl_compositeIsRespPhys.marginHeight = 0;
        compositeIsRespPhys.setLayout((Layout)gl_compositeIsRespPhys);
        this.lblRespPhysColor = new Label(compositeIsRespPhys, 0);
        this.lblRespPhysColor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblRespPhysColor.setText("zugeordnete Farbe");
        this.lblRespPhysColorDefColor = this.lblRespPhysColor.getBackground();
        this.lblRespPhysColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!UserManagementPreferencePage.this.btnIsExecutiveDoctor.getSelection()) {
                    return;
                }
                ColorDialog cd = new ColorDialog(UiDesk.getTopShell());
                cd.setRGB(UserManagementPreferencePage.this.lblRespPhysColor.getBackground().getRGB());
                cd.setText(Messages.UserManagementPreferencePage_MandatorColorSelectTitle);
                RGB rgb = cd.open();
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                Mandant m = Mandant.load((String)user.getAssignedContactId());
                UiMandant.setColorForMandator(m, rgb);
                UserManagementPreferencePage.this.lblRespPhysColor.setBackground(UiMandant.getColorForMandator(m));
                UserManagementPreferencePage.this.updateUserList();
            }
        });
        Label lblRechnungssteller = new Label(compositeIsRespPhys, 0);
        lblRechnungssteller.setText("Rechnungssteller:");
        this.linkRechnungssteller = new Link(compositeIsRespPhys, 0);
        this.linkRechnungssteller.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.linkRechnungssteller.setText("nicht gesetzt <a>\u00e4ndern</a>");
        this.linkRechnungssteller.setToolTipText("Set the invoice contact for this mandator");
        this.linkRechnungssteller.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                Anwender ac = user.getAssignedContact();
                if (ac == null || !ac.isExecutiveDoctor()) {
                    MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)"Fehler", (String)"Der selektierte Kontakt ist kein Mandant.");
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Kontakt.class, "Rechnungs-Kontakt ausw\u00e4hlen", "Bitte selektieren Sie den dem Mandant zugeordneten Rechnungs-Kontakt", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Kontakt kontakt = (Kontakt)ks.getSelection();
                    if (kontakt == null) {
                        return;
                    }
                    Mandant mand = Mandant.load((String)ac.getId());
                    mand.setRechnungssteller(kontakt);
                    UserManagementPreferencePage.this.linkRechnungssteller.setText(String.valueOf(mand.getRechnungssteller().getLabel()) + " " + UserManagementPreferencePage.CHANGE_LINK);
                }
            }
        });
        Composite compositeMandator = new Composite((Composite)this.grpAccounting, 0);
        GridLayout gl_compositeMandator = new GridLayout(2, true);
        gl_compositeMandator.verticalSpacing = 0;
        gl_compositeMandator.horizontalSpacing = 0;
        gl_compositeMandator.marginHeight = 0;
        gl_compositeMandator.marginWidth = 0;
        compositeMandator.setLayout((Layout)gl_compositeMandator);
        compositeMandator.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnIsExecutiveDoctor = new Button(compositeMandator, 32);
        this.btnIsExecutiveDoctor.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnIsExecutiveDoctor.setText("ist verantwortlicher Arzt");
        this.btnIsExecutiveDoctor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserManagementPreferencePage.this.btnIsExecutiveDoctor.getSelection()) {
                    User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                    if (user == null) {
                        return;
                    }
                    Anwender ac = user.getAssignedContact();
                    if (ac == null) {
                        return;
                    }
                    if (!ac.isExecutiveDoctor()) {
                        boolean changeIt = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Kontakt ist kein Mandant", (String)"Der selektierte Kontakt ist kein Mandant. Wollen Sie diesen Kontakt in einen Mandanten \u00e4ndern?");
                        if (changeIt) {
                            ac.setExecutiveDoctor(true);
                        } else {
                            UserManagementPreferencePage.this.btnIsExecutiveDoctor.setSelection(false);
                        }
                    }
                }
            }
        });
        this.btnMandatorIsInactive = new Button(compositeMandator, 32);
        this.btnMandatorIsInactive.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnMandatorIsInactive.setText("ehemalig (Verrechn. sperren)");
        this.btnMandatorIsInactive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                Mandant mandant = Mandant.load((String)user.getAssignedContactId());
                if (!mandant.exists() || !mandant.isValid()) {
                    return;
                }
                mandant.setInactive(UserManagementPreferencePage.this.btnMandatorIsInactive.getSelection());
            }
        });
        Composite compositeAccounting = new Composite((Composite)this.grpAccounting, 0);
        compositeAccounting.setLayout((Layout)new GridLayout(2, true));
        compositeAccounting.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Group grpAssociation = new Group(compositeAccounting, 0);
        grpAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpAssociation.setText("t\u00e4tig f\u00fcr");
        GridLayout gl_grp = new GridLayout(2, false);
        gl_grp.marginHeight = 0;
        grpAssociation.setLayout((Layout)gl_grp);
        Composite compositeAssociation = new Composite((Composite)grpAssociation, 0);
        compositeAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tcl_compositeAssociation = new TableColumnLayout();
        compositeAssociation.setLayout((Layout)tcl_compositeAssociation);
        this.checkboxTableViewerAssociation = CheckboxTableViewer.newCheckList((Composite)compositeAssociation, (int)67584);
        this.checkboxTableViewerAssociation.addCheckStateListener(e -> {
            Mandant m = (Mandant)e.getElement();
            if (m == null) {
                return;
            }
            User user = (User)this.wvUser.getValue();
            Anwender anw = user.getAssignedContact();
            if (anw != null) {
                anw.addOrRemoveExecutiveDoctorWorkingFor(m, e.getChecked());
            } else {
                SWTHelper.showError("No contact assigned", "There is no contact assigned to user " + user.getLabel());
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Anwender anw;
                User user;
                Object selected;
                IStructuredSelection selection = UserManagementPreferencePage.this.checkboxTableViewerAssociation.getStructuredSelection();
                if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof Mandant && (user = (User)UserManagementPreferencePage.this.wvUser.getValue()) != null && (anw = user.getAssignedContact()) != null) {
                    Mandant stdWorkingFor = anw.getStdExecutiveDoctorWorkingFor();
                    if (stdWorkingFor != null && stdWorkingFor.equals(selected)) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Std. Mandant entfernen";
                            }

                            public void run() {
                                anw.setStdExecutiveDoctorWorkingFor(null);
                                (this).UserManagementPreferencePage.this.checkboxTableViewerAssociation.refresh();
                            }
                        });
                    } else {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Std. Mandant setzen";
                            }

                            public void run() {
                                anw.setStdExecutiveDoctorWorkingFor((Mandant)selected);
                                (this).UserManagementPreferencePage.this.checkboxTableViewerAssociation.refresh();
                            }
                        });
                    }
                }
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.checkboxTableViewerAssociation.getTable());
        this.checkboxTableViewerAssociation.getTable().setMenu(contextMenu);
        Group grpRoles = new Group(compositeAccounting, 0);
        grpRoles.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpRoles.setText("Rollenzuordnung");
        GridLayout gl_grpRoles = new GridLayout(2, false);
        gl_grpRoles.marginHeight = 0;
        grpRoles.setLayout((Layout)gl_grpRoles);
        Composite compositeRoles = new Composite((Composite)grpRoles, 0);
        compositeRoles.setLayout((Layout)new FillLayout(256));
        compositeRoles.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.checkboxTableViewerRoles = CheckboxTableViewer.newCheckList((Composite)compositeRoles, (int)67584);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        this.checkboxTableViewerRoles.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerRoles.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                Role r = (Role)element;
                return r.getTranslatedLabel() != null ? r.getTranslatedLabel() : r.getId();
            }
        });
        this.checkboxTableViewerRoles.addCheckStateListener(e -> {
            Role r = (Role)e.getElement();
            if (r == null) {
                return;
            }
            User user = (User)this.wvUser.getValue();
            user.setAssignedRole(r, e.getChecked());
        });
        this.checkboxTableViewerAssociation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerAssociation.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                Mandant m;
                Anwender anw;
                Mandant stdWorkingFor = null;
                User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
                if (user != null && (anw = user.getAssignedContact()) != null) {
                    stdWorkingFor = anw.getStdExecutiveDoctorWorkingFor();
                }
                return String.valueOf((m = (Mandant)element).equals((Object)stdWorkingFor) ? "* " : "") + m.getName() + " " + m.getVorname();
            }
        });
        this.checkboxTableViewerAssociation.setComparator((ViewerComparator)new MandantViewerComparator((Viewer)this.checkboxTableViewerAssociation));
        this.updateRoles();
        this.updateAssociations();
        this.initDataBindings();
        this.wvUser.addValueChangeListener((IValueChangeListener)new ValueChangedAdapter());
        this.updateUserList();
        this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
        sash.setWeights(new int[]{1, 5});
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void updateUserList() {
        List query = new Query(User.class).execute();
        query.sort((u1, u2) -> u1.getLabel().compareTo(u2.getLabel()));
        this.tableViewerUsers.setInput((Object)query);
    }

    private void updateRoles() {
        List roles = new Query(Role.class).execute();
        this.checkboxTableViewerRoles.setInput((Object)roles);
    }

    private void updateAssociations() {
        this.checkboxTableViewerAssociation.setInput((Object)new Query(Mandant.class).execute());
        this.checkboxTableViewerAssociation.setCheckedElements((Object[])new Mandant[0]);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeSelectionBtnIsAdminObserveWidget = WidgetProperties.selection().observe((Widget)this.btnUserIsAdmin);
        IObservableValue wvAdminObserveDetailValue = PojoProperties.value(User.class, (String)"administrator", Boolean.class).observeDetail(this.wvUser);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnIsAdminObserveWidget, wvAdminObserveDetailValue, null, null);
        ISWTObservableValue observeSelectionBtnIsMandatorObserveWidget = WidgetProperties.selection().observe((Widget)this.btnIsExecutiveDoctor);
        IObservableValue wvMandatorObserveDetailValue = PojoProperties.value(Anwender.class, (String)"executiveDoctor", Boolean.class).observeDetail(this.wvAnwender);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnIsMandatorObserveWidget, wvMandatorObserveDetailValue, null, null);
        ISWTObservableValue observeSelectionBtnIsActiveObserveWidget = WidgetProperties.selection().observe((Widget)this.btnUserIsLocked);
        IObservableValue wvActiveObserveDetailValue = PojoProperties.value(User.class, (String)"active", Boolean.class).observeDetail(this.wvUser);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnIsActiveObserveWidget, wvActiveObserveDetailValue, new UpdateValueStrategy().setConverter((IConverter)new BooleanNotConverter()), new UpdateValueStrategy().setConverter((IConverter)new BooleanNotConverter()));
        return bindingContext;
    }

    protected void performApply() {
        this.releaseLockIfRequired();
        super.performApply();
    }

    public boolean performOk() {
        this.releaseLockIfRequired();
        return super.performOk();
    }

    public boolean performCancel() {
        this.releaseLockIfRequired();
        return super.performCancel();
    }

    private void releaseLockIfRequired() {
        User user = (User)this.wvUser.getValue();
        if (user != null && LocalLockServiceHolder.get().isLocked((Object)user)) {
            LocalLockServiceHolder.get().releaseLock((Object)user);
        }
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.btnAllowExternalAccess.setEnabled(unlocked);
        this.btnIsExecutiveDoctor.setEnabled(unlocked);
        this.linkChangePassword.setEnabled(unlocked);
        this.linkContact.setEnabled(unlocked);
        this.linkTotp.setEnabled(unlocked);
        this.linkRechnungssteller.setEnabled(unlocked);
        this.btnUserIsAdmin.setEnabled(unlocked);
        this.btnUserIsLocked.setEnabled(unlocked);
        this.checkboxTableViewerAssociation.getTable().setEnabled(unlocked);
        this.checkboxTableViewerRoles.getTable().setEnabled(unlocked);
        this.lblRespPhysColor.setEnabled(unlocked);
    }

    private class AnwenderCellLabelProvider
    extends CellLabelProvider {
        private AnwenderCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            User user = (User)cell.getElement();
            cell.setText(user.getLabel());
            Anwender ac = user.getAssignedContact();
            if (ac != null && ac.isExecutiveDoctor()) {
                Mandant m = Mandant.load((String)ac.getId());
                Color mc = UiMandant.getColorForMandator(m);
                cell.setImage(MandantSelectionContributionItem.getBoxSWTColorImage(mc));
            } else {
                cell.setImage(Images.IMG_EMPTY_TRANSPARENT.getImage());
            }
            if (user.isAdministrator()) {
                cell.setForeground(UiDesk.getColor("rot"));
                cell.setImage(Images.IMG_AUSRUFEZ.getImage());
            }
        }
    }

    public class MandantViewerComparator
    extends ViewerComparator {
        public MandantViewerComparator(Viewer viewer) {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            Mandant m1 = (Mandant)o1;
            Mandant m2 = (Mandant)o2;
            return m1.getName().compareToIgnoreCase(m2.getName());
        }
    }

    private class ValueChangedAdapter
    implements IValueChangeListener<User> {
        private ValueChangedAdapter() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Mandant mandator;
            User user = (User)UserManagementPreferencePage.this.wvUser.getValue();
            if (user == null) {
                UserManagementPreferencePage.this.wvAnwender.setValue(null);
                return;
            }
            UserManagementPreferencePage.this.setErrorMessage(null);
            Anwender anw = user.getAssignedContact();
            UserManagementPreferencePage.this.wvAnwender.setValue((Object)anw);
            String text = anw != null ? anw.getPersonalia() : "Nicht gesetzt";
            UserManagementPreferencePage.this.linkContact.setText(String.valueOf(text) + " " + UserManagementPreferencePage.CHANGE_LINK);
            UserManagementPreferencePage.this.userInfoLabel.setText(String.valueOf(text) + " [" + user.getId() + "]");
            UserManagementPreferencePage.this.updateRoles();
            Object[] assignedRoles = user.getAssignedRoles().toArray();
            UserManagementPreferencePage.this.checkboxTableViewerRoles.setCheckedElements(assignedRoles);
            UserManagementPreferencePage.this.updateAssociations();
            UserManagementPreferencePage.this.btnAllowExternalAccess.setSelection(user.get("ALLOW_EXTERNAL").equals("1"));
            if (anw != null && (mandator = Mandant.load((String)anw.getId())).exists() && mandator.isValid()) {
                UserManagementPreferencePage.this.btnMandatorIsInactive.setSelection(mandator.isInactive());
            }
            UserManagementPreferencePage.this.linkRechnungssteller.setText("- <a>\u00e4ndern</a>");
            UserManagementPreferencePage.this.lblRespPhysColor.setBackground(UserManagementPreferencePage.this.lblRespPhysColorDefColor);
            if (anw != null) {
                UserManagementPreferencePage.this.checkboxTableViewerAssociation.setCheckedElements(anw.getExecutiveDoctorsWorkingFor().toArray());
                if (anw.isExecutiveDoctor()) {
                    Mandant m = Mandant.load((String)anw.getId());
                    Color color = UiMandant.getColorForMandator(m);
                    UserManagementPreferencePage.this.lblRespPhysColor.setBackground(color);
                    Rechnungssteller rs = m.getRechnungssteller();
                    String rst = rs != null ? rs.getLabel() : "Nicht gesetzt";
                    UserManagementPreferencePage.this.linkRechnungssteller.setText(String.valueOf(rst) + " " + UserManagementPreferencePage.CHANGE_LINK);
                }
            }
        }
    }
}

