/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.ISticker;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class StickerSelectionDialog
extends TitleAreaDialog {
    private TableViewer viewer;
    private StickerViewerComparator comparator;
    private List<ISticker> allStickers;
    private List<ISticker> selectedStickers;
    private String message;
    private IStickerService stickerService = StickerServiceHolder.get();

    public StickerSelectionDialog(Shell shell, String message, Class<?> clazz) {
        super(shell);
        this.message = message;
        this.allStickers = this.stickerService.getStickersForClass(clazz);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout());
        Label lbl = new Label(ret, 64);
        lbl.setText(Messages.AssignStickerDialog_PleaseConfirm);
        this.viewer = new TableViewer(ret, 65568);
        this.viewer.getTable().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput(this.allStickers);
        this.createColumns();
        this.comparator = new StickerViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        return ret;
    }

    private void createColumns() {
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.Core_Name);
        col.getColumn().setWidth(300);
        col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 0));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ISticker s = (ISticker)element;
                return s.getLabel();
            }

            public Color getBackground(Object element) {
                ISticker s = (ISticker)element;
                return CoreUiUtil.getColorForString(s.getBackground());
            }

            public Color getForeground(Object element) {
                ISticker s = (ISticker)element;
                return CoreUiUtil.getColorForString(s.getForeground());
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.Core_Value);
        col.getColumn().setWidth(50);
        col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 1));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ISticker s = (ISticker)element;
                return String.valueOf(s.getImportance());
            }

            public Color getBackground(Object element) {
                ISticker s = (ISticker)element;
                return CoreUiUtil.getColorForString(s.getBackground());
            }

            public Color getForeground(Object element) {
                ISticker s = (ISticker)element;
                return CoreUiUtil.getColorForString(s.getForeground());
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StickerSelectionDialog.this.comparator.setColumn(index);
                StickerSelectionDialog.this.viewer.getTable().setSortDirection(StickerSelectionDialog.this.comparator.getDirection());
                StickerSelectionDialog.this.viewer.getTable().setSortColumn(column);
                StickerSelectionDialog.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void create() {
        super.create();
        this.setTitle("Sticker");
        if (this.message != null) {
            this.setMessage(this.message);
        }
        this.getShell().setText("Elexis Sticker");
    }

    public List<ISticker> getSelection() {
        return this.selectedStickers;
    }

    protected void okPressed() {
        this.selectedStickers = Stream.of(this.viewer.getTable().getItems()).filter(it -> it.getChecked()).map(it -> (ISticker)it.getData()).collect(Collectors.toList());
        super.okPressed();
    }

    class StickerViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private boolean direction = true;
        private ISticker s1;
        private ISticker s2;

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ISticker && e2 instanceof ISticker) {
                this.s1 = (ISticker)e1;
                this.s2 = (ISticker)e2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        String label1 = StringUtils.defaultString((String)this.s1.getLabel()).toLowerCase();
                        String label2 = StringUtils.defaultString((String)this.s2.getLabel()).toLowerCase();
                        rc = label1.compareTo(label2);
                        break;
                    }
                    case 1: {
                        Integer wert1 = this.s1.getImportance();
                        Integer wert2 = this.s2.getImportance();
                        rc = wert1.compareTo(wert2);
                        break;
                    }
                }
                if (this.direction) {
                    rc = -rc;
                }
                return rc;
            }
            return 0;
        }

        public int getDirection() {
            return this.direction ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = !this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = true;
            }
        }
    }
}

