/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KontaktExtDialog
extends TitleAreaDialog {
    private String[] fieldDefinitions;
    private IContact actKontact;
    private ExtInfoTable infoTable;
    private static final Logger logger = LoggerFactory.getLogger(KontaktExtDialog.class);

    public KontaktExtDialog(Shell shell, IContact k, String[] defvalues) {
        super(shell);
        this.actKontact = k;
        this.fieldDefinitions = defvalues;
        Arrays.sort(this.fieldDefinitions, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        this.infoTable = new ExtInfoTable(parent, this.fieldDefinitions);
        this.infoTable.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.infoTable.setLayout((Layout)new GridLayout(2, false));
        this.infoTable.setKontakt(this.actKontact);
        this.infoTable.pack();
        return this.infoTable;
    }

    public void create() {
        super.create();
        this.setTitle(this.actKontact.getLabel());
        this.getShell().setText(Messages.KontaktExtDialog_indetityDetails);
    }

    protected void okPressed() {
        this.infoTable.okPressed(this.actKontact);
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    public static class ExtInfoTable
    extends Composite {
        private String[] fieldDefinitions;
        private HashMap<String, String> xids;
        private String[] fields;
        private String[] savedValues;
        private Text[] values;
        private Composite savedParent;

        public ExtInfoTable(Composite parent, String[] f) {
            super(parent, 0);
            this.fieldDefinitions = f;
            Group params = new Group(parent, 0);
            params.setText(Messages.KontaktExtDialog_pleaseENterDetails);
            params.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            params.setLayout((Layout)new GridLayout(2, false));
            this.savedParent = params;
        }

        public void setKontakt(IContact k) {
            this.xids = new HashMap();
            this.fields = new String[this.fieldDefinitions.length];
            this.savedValues = new String[this.fieldDefinitions.length];
            this.values = new Text[this.fieldDefinitions.length];
            int i = 0;
            while (i < this.fieldDefinitions.length) {
                IXid iXid;
                String key;
                String[] val = this.fieldDefinitions[i].split("=");
                this.fields[i] = key = val[0];
                if (val.length == 2) {
                    this.xids.put(key, val[1]);
                }
                String value = "";
                String xid = this.xids.get(this.fields[i]);
                if (xid != null && (iXid = XidServiceHolder.get().getXid((Identifiable)k, xid)) != null) {
                    value = iXid.getDomainId();
                }
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = (String)k.getExtInfo((Object)this.fields[i]);
                }
                String msg_key_label = "KontaktExtInfo_" + key;
                msg_key_label = msg_key_label.replaceAll("[^a-zA-Z0-9_]", "_");
                String msg_key_tooltip = "KontaktExtInfo_" + key + "_tooltip";
                msg_key_tooltip = msg_key_tooltip.replaceAll("[^a-zA-Z0-9_]", "_");
                String label_text = key;
                String tooltip_text = "";
                try {
                    label_text = ResourceBundle.getBundle("").getString(msg_key_label);
                }
                catch (MissingResourceException ex) {
                    logger.info("init: missing_l10n_key {}", (Object)msg_key_label);
                }
                try {
                    tooltip_text = ResourceBundle.getBundle("").getString(msg_key_tooltip);
                }
                catch (MissingResourceException ex) {
                    logger.info("init: missing_l10n_key {}", (Object)msg_key_tooltip);
                }
                new Label(this.savedParent, 0).setText(label_text);
                this.values[i] = new Text(this.savedParent, 2052);
                this.values[i].setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                this.values[i].setText(StringUtils.defaultString((String)value));
                this.values[i].setToolTipText(tooltip_text);
                this.savedValues[i] = this.values[i].getText();
                ++i;
            }
        }

        public void okPressed(IContact k) {
            int i = 0;
            while (i < this.fieldDefinitions.length) {
                String value = this.values[i].getText();
                if (this.savedValues == null && !value.isEmpty() || this.savedValues[i] != null && !this.savedValues[i].equals(value)) {
                    k.setExtInfo((Object)this.fields[i], (Object)value);
                    String xid = this.xids.get(this.fields[i]);
                    if (xid != null) {
                        k.addXid(xid, value, true);
                    }
                    CoreModelServiceHolder.get().save((Identifiable)k);
                }
                ++i;
            }
        }
    }
}

