/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.artikel.Artikeldetail;
import ch.elexis.data.Artikel;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ArtikelDetailDialog
extends TitleAreaDialog {
    protected IArticle article;

    public ArtikelDetailDialog(Shell shell, IPersistentObject o) {
        super(shell);
        Optional identifiable = StoreToStringServiceHolder.get().loadFromString(o.storeToString());
        if (!identifiable.isPresent() || !(identifiable.get() instanceof IArticle)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Der Artikel [" + o.getLabel() + "] konnte nicht geladen werden."));
            throw new IllegalStateException("Could not load identifiable for article [" + o.getLabel() + "]");
        }
        this.article = (IArticle)identifiable.get();
    }

    public ArtikelDetailDialog(Shell shell, IArticle article) {
        super(shell);
        this.article = article;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite ret = new ScrolledComposite(parent, 512);
        Composite cnt = new Composite((Composite)ret, 0);
        ret.setContent((Control)cnt);
        ret.setExpandHorizontal(true);
        ret.setExpandVertical(true);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        cnt.setLayout((Layout)new FillLayout());
        LabeledInputField.AutoForm tblArtikel = null;
        tblArtikel = this.article instanceof Identifiable ? new LabeledInputField.AutoForm(cnt, Artikeldetail.getModelFieldDefs(parent.getShell())) : new LabeledInputField.AutoForm(cnt, Artikeldetail.getFieldDefs(parent.getShell()));
        tblArtikel.reload((Identifiable)this.article);
        ret.setMinSize(cnt.computeSize(-1, -1));
        return ret;
    }

    protected Point getInitialSize() {
        Point orig = super.getInitialSize();
        orig.y += orig.y >> 2;
        return orig;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        this.getShell().setText(Messages.Article_Detail);
        this.setTitle(this.article.getLabel());
        this.setMessage(Messages.ArtikelDetailDialog_enterArticleDetails);
    }

    protected void okPressed() {
        ElexisEventDispatcher.reload(Artikel.class);
        super.okPressed();
    }
}

