/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Patient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class SendHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
        try {
            Optional selectedDocument;
            Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMail");
            HashMap<String, String> params = new HashMap<String, String>();
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            if (patient != null) {
                params.put("ch.elexis.core.mail.ui.sendMail.subject", "Patient: " + patient.getLabel());
            }
            if ((selectedDocument = ContextServiceHolder.get().getTyped(IDocumentLetter.class)).isPresent()) {
                List<IDocumentLetter> iDocuments = Collections.singletonList((IDocumentLetter)selectedDocument.get());
                String documentsString = AttachmentsUtil.getDocumentsString(iDocuments);
                params.put("ch.elexis.core.mail.ui.sendMail.documents", documentsString);
            }
            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
            ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("ch.elexis.core.mail.ui.sendMail not found", ex);
        }
        return null;
    }
}

