/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMessage;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IMessageTransporter;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ObjectStatus;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class InternalDatabaseMessageTransporter
implements IMessageTransporter {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public IStatus send(TransientMessage message) {
        IContact contact;
        IContact assignedContact;
        String receiver = message.getReceiver();
        Optional user = this.coreModelService.load(receiver, IUser.class);
        if (user.isPresent() && (assignedContact = ((IUser)user.get()).getAssignedContact()) != null) {
            receiver = assignedContact.getId();
        }
        if ((contact = (IContact)this.coreModelService.load(receiver, IContact.class).orElse(null)) == null || !contact.isUser()) {
            return new Status(8, this.getClass(), "invalid receiver, or receiver is not user");
        }
        IMessage idbMessage = this.prepareMessage(receiver, message);
        try {
            CoreModelServiceHolder.get().save((Identifiable)idbMessage);
            return ObjectStatus.OK_STATUS((String)idbMessage.getId(), null);
        }
        catch (IllegalStateException e) {
            return ObjectStatus.ERROR_STATUS((Object)"Could not save message", (Throwable)e);
        }
    }

    private IMessage prepareMessage(String receiver, TransientMessage message) {
        IMessage idbMessage = (IMessage)this.coreModelService.create(IMessage.class);
        String sender = StringUtils.truncate((String)message.getSender(), (int)25);
        idbMessage.setSender(sender);
        idbMessage.setMessageText(message.getMessageText());
        idbMessage.setMessageCodes(message.getMessageCodes());
        idbMessage.setMessagePriority(message.getMessagePriority());
        idbMessage.setCreateDateTime(message.getCreateDateTime());
        idbMessage.setSenderAcceptsAnswer(message.isSenderAcceptsAnswer());
        idbMessage.addReceiver(receiver);
        return idbMessage;
    }

    public String getUriScheme() {
        return "internaldb";
    }

    public boolean isExternal() {
        return false;
    }
}

