/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.es;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.common.InstanceStatus;
import ch.elexis.core.constants.Elexis;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockRequest;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IUser;
import ch.elexis.core.server.IEventService;
import ch.elexis.core.server.IInstanceService;
import ch.elexis.core.server.ILockService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.eenv.ElexisEnvironmentServiceActivator;
import ch.elexis.core.services.es.AcceptAllLockService;
import ch.elexis.core.services.es.DenyAllLockService;
import ch.elexis.core.services.es.ElexisServerClientConfig;
import ch.elexis.core.services.es.NoRemoteEventService;
import ch.elexis.core.services.es.NoRemoteInstanceService;
import ch.elexis.core.services.es.RefreshTask;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ElexisServerService
implements IElexisServerService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final UUID systemUuid = UUID.randomUUID();
    private static boolean standalone = false;
    private String restUrl;
    private Timer timer;
    private IEventService eventService;
    private IInstanceService instanceService;
    private ILockService lockService = new DenyAllLockService();
    private IElexisServerService.ConnectionStatus connectionStatus;
    @Reference
    private IConfigService configService;
    @Reference
    private IContextService contextService;
    @Reference
    private ElexisEnvironmentServiceActivator eeActivator;

    public ElexisServerService() {
        this.eventService = new NoRemoteEventService();
        this.instanceService = new NoRemoteInstanceService();
    }

    @Activate
    public void activate() {
        if (StringUtils.equals((CharSequence)this.contextService.getStationIdentifier(), (CharSequence)"ELEXIS-SERVER")) {
            return;
        }
        this.initializeProperties();
        if (standalone) {
            this.eventService = new NoRemoteEventService();
            this.instanceService = new NoRemoteInstanceService();
            this.lockService = new AcceptAllLockService();
        } else {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new RefreshTask(this), 5000L, 5000L);
            InstanceStatus instanceStatus = this.createInstanceStatus();
            this.updateInstanceStatus(instanceStatus);
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public UUID getSystemUuid() {
        return systemUuid;
    }

    private void initializeProperties() {
        Optional eeService;
        this.restUrl = System.getProperty("elexisServerUrl");
        if (StringUtils.equals((CharSequence)this.restUrl, (CharSequence)"disconnected")) {
            standalone = true;
            this.connectionStatus = IElexisServerService.ConnectionStatus.STANDALONE;
            this.log.info("ES connection administratively deactivated, operating in stand-alone mode.");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.restUrl)) {
            try {
                new URL(this.restUrl);
            }
            catch (MalformedURLException e) {
                this.log.error("Invalid elexis-server url [{}], not initializing remote es services.", (Object)this.restUrl);
                this.restUrl = null;
            }
            this.connectionStatus = IElexisServerService.ConnectionStatus.LOCAL;
            this.log.info("Bound to ES " + this.restUrl);
            return;
        }
        if (this.restUrl == null && (eeService = OsgiServiceUtil.getService(IElexisEnvironmentService.class)).isPresent()) {
            this.connectionStatus = IElexisServerService.ConnectionStatus.LOCAL;
            this.restUrl = String.valueOf(((IElexisEnvironmentService)eeService.get()).getBaseUrl()) + "/services";
            this.log.info("Bound to ES via EE " + this.restUrl);
            return;
        }
        standalone = true;
        this.connectionStatus = IElexisServerService.ConnectionStatus.STANDALONE;
        this.log.debug("No elexis-server url provided, operating in stand-alone mode.");
    }

    public boolean isStandalone() {
        return standalone;
    }

    public InstanceStatus createInstanceStatus() {
        InstanceStatus instanceStatus = new InstanceStatus();
        instanceStatus.setState(InstanceStatus.STATE.ACTIVE);
        instanceStatus.setUuid(this.getSystemUuid().toString());
        instanceStatus.setVersion(Elexis.VERSION);
        instanceStatus.setOperatingSystem(String.valueOf(System.getProperty("os.name")) + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + "/J" + System.getProperty("java.version"));
        String identId = this.configService.getLocal("station/identId", "");
        String identTxt = this.configService.getLocal("station/identText", "");
        instanceStatus.setIdentifier(String.valueOf(identTxt) + " [" + identId + "]");
        IUser u = this.contextService.getActiveUser().orElse(null);
        instanceStatus.setActiveUser(u != null ? u.getId() : "NO USER ACTIVE");
        return instanceStatus;
    }

    public IStatus postEvent(ElexisEvent elexisEvent) {
        if (this.eventService != null) {
            try {
                elexisEvent.putProperty("systemuuid", systemUuid.toString());
                this.eventService.postEvent(elexisEvent);
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not post event [{}]", (Object)(String.valueOf(elexisEvent.getTopic()) + " " + elexisEvent.getProperties()), (Object)e);
                return new Status(4, "ch.elexis.core.services", e.getMessage(), (Throwable)e);
            }
        }
        return new Status(4, "ch.elexis.core.services", "No EventService available");
    }

    public boolean deliversRemoteEvents() {
        return !(this.eventService instanceof NoRemoteEventService);
    }

    public Response updateInstanceStatus(InstanceStatus request) {
        return this.instanceService.updateStatus(request);
    }

    public Response getInstanceStatus() {
        return this.instanceService.getStatus();
    }

    public LockResponse acquireOrReleaseLocks(LockRequest request) {
        return this.lockService.acquireOrReleaseLocks(request);
    }

    public boolean isLocked(LockRequest request) {
        return this.lockService.isLocked(request);
    }

    public LockInfo getLockInfo(String storeToString) {
        return this.lockService.getLockInfo(storeToString);
    }

    public synchronized boolean validateElexisServerConnection() {
        if (IElexisServerService.ConnectionStatus.STANDALONE == this.connectionStatus) {
            return true;
        }
        boolean connectionOk = false;
        try {
            String testRestUrl = String.valueOf(this.restUrl) + "/elexis/lockservice/lockInfo";
            URL url = new URL(testRestUrl);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(1000);
            urlConn.setReadTimeout(1500);
            urlConn.connect();
            connectionOk = urlConn.getResponseCode() >= 200 && urlConn.getResponseCode() < 300;
        }
        catch (IOException e) {
            this.log.warn("Error connecting to elexis-server", (Throwable)e);
        }
        if (connectionOk && this.connectionStatus != IElexisServerService.ConnectionStatus.REMOTE) {
            this.connectionStatus = IElexisServerService.ConnectionStatus.REMOTE;
            this.eventService = (IEventService)ConsumerFactory.createConsumer((String)this.restUrl, (Configuration)new ElexisServerClientConfig(), IEventService.class);
            this.contextService.postEvent("info/elexis/model/reload", IEventService.class);
            this.instanceService = (IInstanceService)ConsumerFactory.createConsumer((String)this.restUrl, (Configuration)new ElexisServerClientConfig(), IInstanceService.class);
            this.contextService.postEvent("info/elexis/model/reload", IInstanceService.class);
            this.lockService = (ILockService)ConsumerFactory.createConsumer((String)this.restUrl, (Configuration)new ElexisServerClientConfig(), ILockService.class);
            this.contextService.postEvent("info/elexis/model/reload", ILockService.class);
        }
        if (!connectionOk && this.connectionStatus != IElexisServerService.ConnectionStatus.LOCAL) {
            this.connectionStatus = IElexisServerService.ConnectionStatus.LOCAL;
            this.eventService = new NoRemoteEventService();
            this.contextService.postEvent("info/elexis/model/reload", IEventService.class);
            this.instanceService = new NoRemoteInstanceService();
            this.contextService.postEvent("info/elexis/model/reload", IInstanceService.class);
            this.lockService = new DenyAllLockService();
            this.contextService.postEvent("info/elexis/model/reload", ILockService.class);
        }
        return connectionOk;
    }

    public IElexisServerService.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }
}

