/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.constants.ElexisEnvironmentPropertyConstants;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.eenv.ElexisEnvironmentService;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ElexisEnvironmentServiceActivator.class})
public class ElexisEnvironmentServiceActivator {
    private ServiceRegistration<IElexisEnvironmentService> serviceRegistration;
    @Reference
    private IConfigService configService;
    @Reference
    private IContextService contextService;

    @Activate
    public void activate() {
        String elexisEnvironmentHost = System.getProperty("EE_HOSTNAME");
        if (StringUtils.isBlank((CharSequence)elexisEnvironmentHost)) {
            elexisEnvironmentHost = System.getenv(ElexisEnvironmentPropertyConstants.EE_HOSTNAME);
        }
        if (StringUtils.isBlank((CharSequence)elexisEnvironmentHost)) {
            elexisEnvironmentHost = this.configService.get("EE_HOSTNAME", null);
        }
        Logger log = LoggerFactory.getLogger(this.getClass());
        if (StringUtils.isNotBlank((CharSequence)elexisEnvironmentHost)) {
            try {
                ElexisEnvironmentService elexisEnvironmentService = new ElexisEnvironmentService(elexisEnvironmentHost, this.contextService, this.configService);
                this.serviceRegistration = FrameworkUtil.getBundle(ElexisEnvironmentServiceActivator.class).getBundleContext().registerService(IElexisEnvironmentService.class, (Object)elexisEnvironmentService, null);
            }
            catch (Exception e) {
                log.warn("EE initialization failed:", (Throwable)e);
            }
        } else {
            log.debug("No elexis-environment configured");
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

