/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class CodeElementService
implements ICodeElementService {
    private HashMap<String, ICodeElementServiceContribution> contributions = new HashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void setCodeElementServiceContribution(ICodeElementServiceContribution contribution) {
        ICodeElementServiceContribution previous = this.contributions.put(contribution.getSystem().toLowerCase(), contribution);
        if (previous != null) {
            LoggerFactory.getLogger(this.getClass()).warn("Possible ICodeElementServiceContribution collision previous [" + previous + "] new [" + contribution + "]");
        }
    }

    public void unsetCodeElementServiceContribution(ICodeElementServiceContribution store) {
        this.contributions.remove(store.getSystem().toLowerCase());
    }

    public Optional<ICodeElement> loadFromString(String system, String code, Map<Object, Object> context) {
        ICodeElementServiceContribution contribution = this.contributions.get(system.toLowerCase());
        if (contribution != null) {
            if (context == null) {
                context = Collections.emptyMap();
            }
            return contribution.loadFromCode(code, context);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No ICodeElementServiceContribution for system [" + system + "] code [" + code + "]");
        return Optional.empty();
    }

    public Optional<IArticle> findArticleByGtin(String gtin) {
        for (ICodeElementServiceContribution contribution : this.getContributionsByTyp(ICodeElementService.CodeElementTyp.ARTICLE)) {
            Optional loadFromCode = contribution.loadFromCode(gtin);
            if (!loadFromCode.isPresent()) continue;
            if (loadFromCode.get() instanceof IArticle) {
                return loadFromCode.map(IArticle.class::cast);
            }
            LoggerFactory.getLogger(this.getClass()).warn("Found article for gtin [{}] but is not castable to IArticle [{}]", (Object)gtin, (Object)((ICodeElement)loadFromCode.get()).getClass().getName());
        }
        return Optional.empty();
    }

    public List<ICodeElementServiceContribution> getContributionsByTyp(ICodeElementService.CodeElementTyp typ) {
        return this.contributions.values().stream().filter(contribution -> contribution.getTyp() == typ).collect(Collectors.toList());
    }

    public Optional<ICodeElementServiceContribution> getContribution(ICodeElementService.CodeElementTyp typ, String codeSystemName) {
        return Optional.ofNullable(this.contributions.get(codeSystemName.toLowerCase()));
    }
}

