/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.consumer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.internal.MediaTypes;

public class RequestConfigurer {
    private final String baseUrl;
    private final Client client;
    private final Method method;
    private final Object[] parameter;

    public RequestConfigurer(Client client, String baseUrl, Method method, Object[] parameter) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.method = method;
        this.parameter = parameter;
    }

    public Invocation.Builder configure() {
        WebTarget target = this.computeTarget();
        target = this.addQueryParameters(target);
        target = this.addMatrixParameters(target);
        Invocation.Builder request = target.request();
        request = this.addHeaders(request);
        return request;
    }

    public String getRequestUrl() {
        WebTarget target = this.computeTarget();
        return target.getUri().toString();
    }

    private WebTarget computeTarget() {
        String serviceUrl = this.baseUrl;
        if (this.method.isAnnotationPresent(Path.class)) {
            String path = this.method.getAnnotation(Path.class).value();
            serviceUrl = this.computeUrl(serviceUrl, path);
        }
        return this.client.target(this.replacePathParams(serviceUrl, this.method, this.parameter));
    }

    private String computeUrl(String serviceUrl, String path) {
        if (serviceUrl.endsWith("/") && path.startsWith("/")) {
            return String.valueOf(serviceUrl) + path.substring(1, path.length());
        }
        if (!serviceUrl.endsWith("/") && !path.startsWith("/")) {
            return String.valueOf(serviceUrl) + "/" + path;
        }
        return String.valueOf(serviceUrl) + path;
    }

    private String replacePathParams(String serviceUrl, Method method, Object[] parameter) {
        String result = serviceUrl;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            String paramName = this.extractPathParam(annotations);
            if (paramName != null) {
                result = result.replace(this.getPathSegment(result, paramName), parameter[i].toString());
            }
            ++i;
        }
        this.validatePath(result);
        return result;
    }

    private String getPathSegment(String fullPath, String pathParameter) {
        Pattern pattern = Pattern.compile(".*?(\\{" + pathParameter + ":*?.*?\\}).*?");
        Matcher matcher = pattern.matcher(fullPath);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return pathParameter;
    }

    private String extractPathParam(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == PathParam.class) {
                return ((PathParam)annotation).value();
            }
            ++n2;
        }
        return null;
    }

    private void validatePath(String path) {
        Pattern pattern = Pattern.compile(".*?\\{(.+)\\}.*?");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            String message = "Path " + path + " has undefined path parameters: ";
            int i = 1;
            while (i <= matcher.groupCount()) {
                message = String.valueOf(message) + matcher.group(i) + " ";
                ++i;
            }
            throw new IllegalStateException(message);
        }
    }

    private WebTarget addQueryParameters(WebTarget target) {
        WebTarget result = target;
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            String paramName = this.extractQueryParam(annotations);
            if (paramName != null) {
                result = result.queryParam(paramName, new Object[]{this.parameter[i]});
            }
            ++i;
        }
        return result;
    }

    private String extractQueryParam(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == QueryParam.class) {
                return ((QueryParam)annotation).value();
            }
            ++n2;
        }
        return null;
    }

    private WebTarget addMatrixParameters(WebTarget target) {
        WebTarget result = target;
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            String paramName = this.extractMatrixParam(annotations);
            if (paramName != null) {
                result = result.matrixParam(paramName, new Object[]{this.parameter[i]});
            }
            ++i;
        }
        return result;
    }

    private String extractMatrixParam(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == MatrixParam.class) {
                return ((MatrixParam)annotation).value();
            }
            ++n2;
        }
        return null;
    }

    private Invocation.Builder addHeaders(Invocation.Builder request) {
        Invocation.Builder result = request;
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            String paramName = this.extractHeaderParam(annotations);
            if (paramName != null) {
                result = result.header(paramName, this.parameter[i]);
            }
            ++i;
        }
        result = this.addAcceptHeader(request);
        return result;
    }

    private Invocation.Builder addAcceptHeader(Invocation.Builder request) {
        Invocation.Builder result = request;
        MediaType accept = MediaType.WILDCARD_TYPE;
        if (this.method.isAnnotationPresent(Produces.class)) {
            accept = (MediaType)MediaTypes.createFrom((Produces)this.method.getAnnotation(Produces.class)).get(0);
            result = result.header("Accept", (Object)accept);
        }
        return result;
    }

    private String extractHeaderParam(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == HeaderParam.class) {
                return ((HeaderParam)annotation).value();
            }
            ++n2;
        }
        return null;
    }
}

