/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import ch.elexis.core.types.Gender;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class FuzzyGenderToEnumConverter
implements AttributeConverter<Gender, String> {
    public String convertToDatabaseColumn(Gender objectValue) {
        if (objectValue == null) {
            return "x";
        }
        switch (objectValue) {
            case MALE: {
                return "m";
            }
            case FEMALE: {
                return "w";
            }
        }
        return "x";
    }

    public Gender convertToEntityAttribute(String dataValue) {
        if (dataValue == null) {
            return Gender.UNKNOWN;
        }
        switch (dataValue) {
            case "F": 
            case "W": 
            case "f": 
            case "w": {
                return Gender.FEMALE;
            }
            case "M": 
            case "m": {
                return Gender.MALE;
            }
        }
        return Gender.UNKNOWN;
    }
}

