/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICPCEpisodeDiagnosisLink;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="CH_ELEXIS_ICPC_EPISODES")
@EntityListeners(value={EntityWithIdListener.class})
public class ICPCEpisode
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
EntityWithExtInfo,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Lob
    protected byte[] extInfo;
    @ManyToOne
    @JoinColumn(name="PatientID")
    private Kontakt patientKontakt;
    @OneToMany(mappedBy="Episode")
    private List<ICPCEpisodeDiagnosisLink> diagnosisLinks;
    @Column(length=256, name="Title")
    private String title;
    @Column(length=20, name="StartDate")
    private String startDate;
    @Column(length=10, name="Number")
    private String number;
    @Convert(converter=IntegerStringConverter.class)
    private int status;
    static final long serialVersionUID = -2633306263023120078L;

    public ICPCEpisode() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.diagnosisLinks = new ArrayList<ICPCEpisodeDiagnosisLink>();
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public byte[] getExtInfo() {
        return this._persistence_get_extInfo();
    }

    @Override
    public void setExtInfo(byte[] extInfo) {
        this._persistence_set_extInfo(extInfo);
    }

    public String getTitle() {
        return this._persistence_get_title();
    }

    public void setTitle(String title) {
        this._persistence_set_title(title);
    }

    public String getStartDate() {
        return this._persistence_get_startDate();
    }

    public void setStartDate(String startDate) {
        this._persistence_set_startDate(startDate);
    }

    public String getNumber() {
        return this._persistence_get_number();
    }

    public void setNumber(String number) {
        this._persistence_set_number(number);
    }

    public int getStatus() {
        return this._persistence_get_status();
    }

    public void setStatus(int status) {
        this._persistence_set_status(status);
    }

    public Kontakt getPatientKontakt() {
        return this._persistence_get_patientKontakt();
    }

    public void setPatientKontakt(Kontakt patientKontakt) {
        this._persistence_set_patientKontakt(patientKontakt);
    }

    public void addDiagnosis(String diagnosis) {
        ICPCEpisodeDiagnosisLink link = new ICPCEpisodeDiagnosisLink();
        link.setEpisode(this);
        link.setDiagnosis(diagnosis);
        this._persistence_get_diagnosisLinks().add(link);
    }

    public void removeDiagnosis(ICPCEpisodeDiagnosisLink link) {
        this._persistence_get_diagnosisLinks().remove(link);
    }

    public List<ICPCEpisodeDiagnosisLink> getLinks() {
        return this._persistence_get_diagnosisLinks();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ICPCEpisode(persistenceObject);
    }

    public ICPCEpisode(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "number") {
            return this.number;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "diagnosisLinks") {
            return this.diagnosisLinks;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "title") {
            return this.title;
        }
        if (string == "startDate") {
            return this.startDate;
        }
        if (string == "patientKontakt") {
            return this.patientKontakt;
        }
        if (string == "extInfo") {
            return this.extInfo;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "number") {
            this.number = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "diagnosisLinks") {
            this.diagnosisLinks = (List)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "title") {
            this.title = (String)object;
            return;
        }
        if (string == "startDate") {
            this.startDate = (String)object;
            return;
        }
        if (string == "patientKontakt") {
            this.patientKontakt = (Kontakt)object;
            return;
        }
        if (string == "extInfo") {
            this.extInfo = (byte[])object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(String string) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, string);
        this.number = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public List _persistence_get_diagnosisLinks() {
        this._persistence_checkFetched("diagnosisLinks");
        return this.diagnosisLinks;
    }

    public void _persistence_set_diagnosisLinks(List list) {
        this._persistence_checkFetchedForSet("diagnosisLinks");
        this._persistence_propertyChange("diagnosisLinks", this.diagnosisLinks, list);
        this.diagnosisLinks = list;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_title() {
        this._persistence_checkFetched("title");
        return this.title;
    }

    public void _persistence_set_title(String string) {
        this._persistence_checkFetchedForSet("title");
        this._persistence_propertyChange("title", this.title, string);
        this.title = string;
    }

    public String _persistence_get_startDate() {
        this._persistence_checkFetched("startDate");
        return this.startDate;
    }

    public void _persistence_set_startDate(String string) {
        this._persistence_checkFetchedForSet("startDate");
        this._persistence_propertyChange("startDate", this.startDate, string);
        this.startDate = string;
    }

    public Kontakt _persistence_get_patientKontakt() {
        this._persistence_checkFetched("patientKontakt");
        return this.patientKontakt;
    }

    public void _persistence_set_patientKontakt(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patientKontakt");
        this._persistence_propertyChange("patientKontakt", this.patientKontakt, kontakt);
        this.patientKontakt = kontakt;
    }

    public byte[] _persistence_get_extInfo() {
        this._persistence_checkFetched("extInfo");
        return this.extInfo;
    }

    public void _persistence_set_extInfo(byte[] byArray) {
        this._persistence_checkFetchedForSet("extInfo");
        this._persistence_propertyChange("extInfo", this.extInfo, byArray);
        this.extInfo = byArray;
    }

    public int _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(int n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", new Integer(this.status), new Integer(n));
        this.status = n;
    }
}

