/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.vfs;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemChangeWatcherTimerTask
extends TimerTask {
    private final ITaskService taskService;
    private final IVirtualFilesystemService virtualFileSystemService;
    private final Logger logger;
    private final Map<String, String[]> pollMap;

    FilesystemChangeWatcherTimerTask(ITaskService taskService, IVirtualFilesystemService virtualFileSystemService) {
        this.taskService = taskService;
        this.virtualFileSystemService = virtualFileSystemService;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pollMap = Collections.synchronizedMap(new HashMap());
    }

    void incur(String taskDescriptorId, String url, String fileExtensionFilter) {
        this.pollMap.put(taskDescriptorId, new String[]{url, fileExtensionFilter});
    }

    void release(String taskDescriptorId) {
        this.pollMap.remove(taskDescriptorId);
    }

    @Override
    public void run() {
        Set<Map.Entry<String, String[]>> pollEntrySet = this.pollMap.entrySet();
        for (Map.Entry<String, String[]> entry : pollEntrySet) {
            String taskDescriptorId = entry.getKey();
            String urlString = entry.getValue()[0];
            String fileExtensionFilter = entry.getValue()[1];
            this.logger.debug("[{}] poll run for url [{}] fileExtensionFilter [{}]", new Object[]{taskDescriptorId, urlString, fileExtensionFilter});
            IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = new IVirtualFilesystemService.IVirtualFilesystemHandle[]{};
            try {
                IVirtualFilesystemService.IVirtualFilesystemHandle of = this.virtualFileSystemService.of(urlString);
                listHandles = StringUtils.isNotBlank((CharSequence)fileExtensionFilter) ? of.listHandles(handle -> fileExtensionFilter.equalsIgnoreCase(handle.getExtension())) : of.listHandles();
            }
            catch (IOException e) {
                this.logger.warn("[{}] Error on listHandle", (Object)taskDescriptorId, (Object)e);
            }
            IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = listHandles;
            int n = listHandles.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = iVirtualFilesystemHandleArray[n2];
                try {
                    this.runTaskForFile(taskDescriptorId, fileHandle.getAbsolutePath());
                }
                catch (TaskException e) {
                    this.logger.warn("[{}] Error triggering taskDescriptor", (Object)taskDescriptorId, (Object)e);
                }
                ++n2;
            }
        }
    }

    private ITask runTaskForFile(String taskDescriptorId, String url) throws TaskException {
        this.logger.debug("[{}] Triggering for url [{}]", (Object)taskDescriptorId, (Object)url);
        try {
            Map<String, String> runContext = Collections.singletonMap("url", url);
            return this.taskService.trigger(taskDescriptorId, null, TaskTriggerType.FILESYSTEM_CHANGE, runContext);
        }
        catch (IllegalStateException e) {
            throw new TaskException(6, (Throwable)e);
        }
    }

    public Set<String[]> getIncurred() {
        HashSet<String[]> incurred = new HashSet<String[]>();
        this.pollMap.entrySet().forEach(es -> {
            boolean bl = incurred.add(new String[]{(String)es.getKey(), ((String[])es.getValue())[0], ((String[])es.getValue())[1]});
        });
        return incurred;
    }
}

