/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.runnables;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.SerializableBoolean;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.tasks.model.TaskState;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;

public class RemoveTaskLogEntriesRunnable
implements IIdentifiedRunnable {
    public static final String RUNNABLE_ID = "removeTaskLogEntries";
    public static final String DESCRIPTION = "Remove task log entries considering parameters";
    public static final String RCP_INTEGER_BEQ_FINISHEDAT_AGE_IN_MINUTES = "beqFinishedAtAge";
    public static final String RCP_BOOLEAN_HARD_DELETE = "hardDelete";
    public static final String RCP_BOOLEAN_ONLY_NO_ERROR = "deleteOnlyNoError";
    private IModelService taskModelService;

    public RemoveTaskLogEntriesRunnable(IModelService taskModelService) {
        this.taskModelService = taskModelService;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return DESCRIPTION;
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        defaultRunContext.put(RCP_INTEGER_BEQ_FINISHEDAT_AGE_IN_MINUTES, Integer.valueOf(80640));
        defaultRunContext.put(RCP_BOOLEAN_HARD_DELETE, Boolean.TRUE);
        defaultRunContext.put(RCP_BOOLEAN_ONLY_NO_ERROR, Boolean.TRUE);
        return defaultRunContext;
    }

    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        Number beqAgeInMinutes = (Number)runContext.get(RCP_INTEGER_BEQ_FINISHEDAT_AGE_IN_MINUTES);
        Long ageBarrierInMilliseconds = System.currentTimeMillis() - beqAgeInMinutes.longValue() * 60L * 1000L;
        boolean onlyNoError = SerializableBoolean.valueOf(runContext, (String)RCP_BOOLEAN_ONLY_NO_ERROR);
        boolean hardDelete = SerializableBoolean.valueOf(runContext, (String)RCP_BOOLEAN_HARD_DELETE);
        IQuery query = this.taskModelService.getQuery(ITask.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK__FINISHED_AT, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)ageBarrierInMilliseconds);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)false);
        if (onlyNoError) {
            query.and((EStructuralFeature)ModelPackage.Literals.ITASK__STATE, IQuery.COMPARATOR.EQUALS, (Object)TaskState.COMPLETED.getValue());
        }
        List itemsToDelete = query.execute();
        int itemsToDeleteSize = itemsToDelete.size();
        if (hardDelete) {
            this.taskModelService.remove(itemsToDelete);
        } else {
            this.taskModelService.delete(itemsToDelete);
        }
        String message = String.valueOf(itemsToDeleteSize) + (hardDelete ? " removed from database" : " marked as deleted");
        return Collections.singletonMap("resultData", message);
    }
}

