/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Log;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;

public class Resource {
    Class clazz = this.getClass();
    String resbase;
    static Log log;

    public Resource(String packagename) {
        this.resbase = "/" + packagename.replace('.', '/') + "/";
    }

    public InputStream getInputStream(String name) {
        String resname = String.valueOf(this.resbase) + name;
        InputStream is = this.clazz.getResourceAsStream(resname);
        if (is == null) {
            return null;
        }
        return is;
    }

    public String getText(String name) {
        InputStream is = this.getInputStream(name);
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            is.close();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        return sb.toString();
    }

    public byte[] getBytes(String name) {
        InputStream is = this.getInputStream(name);
        byte[] buffer = new byte[]{};
        byte[] tmpbuf = new byte[1024];
        try {
            int len;
            while ((len = is.read(tmpbuf)) > 0) {
                byte[] newbuf = new byte[buffer.length + len];
                System.arraycopy(buffer, 0, newbuf, 0, buffer.length);
                System.arraycopy(tmpbuf, 0, newbuf, buffer.length, len);
                buffer = newbuf;
            }
            is.close();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
        return buffer;
    }

    public Image getImage(String name) {
        byte[] buffer = this.getBytes(name);
        Image ret = Toolkit.getDefaultToolkit().createImage(buffer);
        return ret;
    }

    public URL getBaseDir(String rsc) {
        String p = "/" + rsc.replace('.', '/');
        return this.clazz.getResource(p);
    }
}

