/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.medication.views.MedicationComposite;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.views.IRefreshable;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class MedicationView
extends ViewPart
implements IRefreshable {
    private MedicationComposite tpc;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this){

        public void partActivated(IWorkbenchPartReference partRef) {
            super.partActivated(partRef);
            if (MedicationView.this.tpc != null && !MedicationView.this.tpc.isDisposed()) {
                MedicationView.this.tpc.showMedicationDetailComposite(null);
            }
        }
    };
    public static final String PART_ID = "ch.elexis.core.ui.medication.views.MedicationView";

    @Inject
    void activePatient(@Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl((Control)this.tpc)) {
                this.updateUi(patient, false);
            }
        });
    }

    @Optional
    @Inject
    void udpatePatient(@UIEventTopic(value="info/elexis/model/update") IPatient patient) {
        if (CoreUiUtil.isActiveControl((Control)this.tpc)) {
            this.updateUi(patient, false);
        }
    }

    @Optional
    @Inject
    void updatePrescription(@UIEventTopic(value="info/elexis/model/update") IPrescription prescription) {
        if (CoreUiUtil.isActiveControl((Control)this.tpc) && prescription != null) {
            EntryType entryType;
            if (!(this.getMedicationComposite().isShowingHistory() || (entryType = prescription.getEntryType()) != EntryType.RECIPE && entryType != EntryType.SELF_DISPENSED)) {
                return;
            }
            if (prescription.getPatient().equals(ContextServiceHolder.get().getActivePatient().orElse(null))) {
                this.updateUi(prescription.getPatient(), true);
            }
        }
    }

    @Inject
    void createPrescription(@Optional @UIEventTopic(value="info/elexis/model/create") IPrescription prescription) {
        this.updatePrescription(prescription);
    }

    @Inject
    void reloadPrescription(@Optional @UIEventTopic(value="info/elexis/model/create") Class<?> clazz) {
        if (clazz == IPrescription.class && CoreUiUtil.isActiveControl((Control)this.tpc)) {
            ContextServiceHolder.get().getActivePatient().ifPresent(patient -> this.updateUi((IPatient)patient, false));
        }
    }

    public void createPartControl(Composite parent) {
        this.tpc = new MedicationComposite(parent, 0, this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tpc);
        int sorter = ConfigServiceHolder.getUser((String)"medicationlist/sortOrder", (int)1);
        this.tpc.setViewerSortOrder(ViewerSortOrder.getSortOrderPerValue(sorter));
        ViewerSortOrder.getSortOrderPerValue(sorter).setAtcSort(ConfigServiceHolder.getUser((String)"medicationlist/sortAtc", (boolean)false));
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setMedicationTableViewerComparator(ViewerSortOrder order) {
        this.tpc.setViewerSortOrder(order);
        ConfigServiceHolder.setUser((String)"medicationlist/sortOrder", (int)order.val);
    }

    public ViewerSortOrder getMedicationTableViewerComparator() {
        return this.tpc.getViewerSortOrder();
    }

    public void setFocus() {
        this.tpc.setFocus();
        this.refresh();
    }

    private void updateUi(IPatient patient, boolean forceUpdate) {
        this.tpc.updateUi(patient, forceUpdate);
    }

    public void refresh() {
        if (CoreUiUtil.isActiveControl((Control)this.tpc)) {
            Display.getDefault().asyncExec(() -> this.updateUi(ContextServiceHolder.get().getActivePatient().orElse(null), false));
        }
    }

    public void resetSelection() {
        this.tpc.resetSelectedMedication();
    }

    public MedicationComposite getMedicationComposite() {
        return this.tpc;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

