/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.SQLExceptionList;
import org.apache.commons.dbcp2.Utils;
import org.apache.commons.pool2.KeyedObjectPool;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    private final KeyedObjectPool<K, PoolablePreparedStatement<K>> pool;
    private final K key;
    private volatile boolean batchAdded;

    public PoolablePreparedStatement(PreparedStatement stmt, K key, KeyedObjectPool<K, PoolablePreparedStatement<K>> pool, DelegatingConnection<?> conn) {
        super(conn, stmt);
        this.pool = pool;
        this.key = key;
        this.removeThisTrace(this.getConnectionInternal());
    }

    @Override
    public void activate() throws SQLException {
        this.setClosedInternal(false);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().addTrace(this);
        }
        super.activate();
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.pool.returnObject(this.key, (Object)this);
            }
            catch (RuntimeException | SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", e);
            }
        }
    }

    @Override
    public void passivate() throws SQLException {
        if (this.batchAdded) {
            this.clearBatch();
        }
        this.setClosedInternal(true);
        this.removeThisTrace(this.getConnectionInternal());
        List<AbandonedTrace> resultSetList = this.getTrace();
        if (resultSetList != null) {
            ResultSet[] resultSets;
            ArrayList<Exception> thrownList = new ArrayList<Exception>();
            ResultSet[] resultSetArray = resultSets = resultSetList.toArray(Utils.EMPTY_RESULT_SET_ARRAY);
            int n = resultSets.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSet resultSet = resultSetArray[n2];
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception e) {
                        thrownList.add(e);
                    }
                }
                ++n2;
            }
            this.clearTrace();
            if (!thrownList.isEmpty()) {
                throw new SQLExceptionList(thrownList);
            }
        }
        super.passivate();
    }
}

