/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eigenartikel.service;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.types.ArticleTyp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EigenartikelCodeElementService
implements ICodeElementServiceContribution {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public String getSystem() {
        return "Eigenartikel";
    }

    public Optional<ICodeElement> loadFromCode(String code, Map<Object, Object> context) {
        INamedQuery query = this.coreModelService.getNamedQuery(IArticle.class, new String[]{"typ", "code"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"typ", ArticleTyp.EIGENARTIKEL, "code", code}));
        if (!found.isEmpty()) {
            if (found.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).warn("Found more than one " + ArticleTyp.EIGENARTIKEL.getCodeSystemName() + " with code [" + code + "] using first");
            }
            return Optional.of((ICodeElement)found.get(0));
        }
        query = this.coreModelService.getNamedQuery(IArticle.class, new String[]{"typ", "id"});
        found = query.executeWithParameters(query.getParameterMap(new Object[]{"typ", ArticleTyp.EIGENARTIKEL, "id", code}));
        if (!found.isEmpty()) {
            if (found.size() > 1) {
                LoggerFactory.getLogger(this.getClass()).warn("Found more than one " + ArticleTyp.EIGENARTIKEL.getCodeSystemName() + " with id [" + code + "] using first");
            }
            return Optional.of((ICodeElement)found.get(0));
        }
        return Optional.empty();
    }

    public ICodeElementService.CodeElementTyp getTyp() {
        return ICodeElementService.CodeElementTyp.ARTICLE;
    }

    public List<ICodeElement> getElements(Map<Object, Object> context) {
        INamedQuery query = this.coreModelService.getNamedQuery(IArticle.class, new String[]{"typ"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"typ", ArticleTyp.EIGENARTIKEL}));
    }
}

