/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.documents.FilterCategory;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.documents.views.DocumentsFilterBarComposite;
import ch.elexis.core.ui.documents.views.DocumentsTreeContentProvider;
import ch.elexis.core.ui.documents.views.DocumentsViewerComparator;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsView
extends ViewPart {
    public static final String ID = "ch.elexis.core.ui.documents.views.DocumentsView";
    public static final String SETTING_FLAT_VIEW = "documentsView/flatView";
    private static Logger logger = LoggerFactory.getLogger(DocumentsView.class);
    private TreeViewer viewer;
    private IStructuredSelection currentDragSelection;
    private final String[] colLabels = new String[]{"", "", Messages.Core_Category, Messages.Core_Title, Messages.DocumentView_dateCreatedColumn, Messages.Core_Keywords};
    private final String colWidth = "20,20,150,250,100,500";
    private final String sortSettings = "0,1,-1,false";
    private String searchTitle = "";
    private DocumentsViewerComparator ovComparator;
    private Action doubleClickAction;
    private boolean bFlat = false;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    private DocumentsTreeContentProvider contentProvider;

    @Inject
    void activePatient(@Optional IPatient patient) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                this.viewer.setInput((Object)patient);
                this.viewer.expandAll();
            });
        }
    }

    @Optional
    @Inject
    void udpateDocument(@UIEventTopic(value="info/elexis/model/update") IDocument document) {
        if (document != null && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            document = (IDocument)DocumentStoreServiceHolder.getService().loadDocument(document.getId(), document.getStoreId()).get();
            this.contentProvider.updateElement(document);
            this.viewer.getTree().deselectAll();
            this.viewer.refresh();
        }
    }

    @Optional
    @Inject
    void deleteDocument(@UIEventTopic(value="info/elexis/model/delete") IDocument document) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.contentProvider.updateElement(document);
            this.viewer.setSelection((ISelection)new StructuredSelection());
            this.viewer.refresh();
        }
    }

    @Optional
    @Inject
    void createDocument(@UIEventTopic(value="info/elexis/model/create") IDocument document) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.contentProvider.updateElement(document);
            this.viewer.refresh();
        }
    }

    @Optional
    @Inject
    void reloadDocument(@UIEventTopic(value="info/elexis/model/reload") IDocument document) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        Composite filterComposite = new Composite(parent, 0);
        GridData data = new GridData(768);
        filterComposite.setLayoutData((Object)data);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        final Text tSearch = new Text(filterComposite, 2048);
        data = new GridData(768);
        tSearch.setLayoutData((Object)data);
        tSearch.setMessage(Messages.DocumentView_searchLabel);
        ModifyListener searchListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DocumentsView.this.searchTitle = tSearch.getText();
                DocumentsView.this.refresh();
                if (DocumentsView.this.searchTitle == null || DocumentsView.this.searchTitle.isEmpty()) {
                    DocumentsView.this.viewer.collapseAll();
                } else {
                    DocumentsView.this.viewer.expandAll();
                }
            }
        };
        tSearch.addModifyListener(searchListener);
        this.createFlatMenu(filterComposite);
        this.viewer = new TreeViewer(parent, 66306);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        ArrayList<TreeViewerColumn> viewerColumns = new ArrayList<TreeViewerColumn>();
        int i = 0;
        while (i < this.colLabels.length) {
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
            viewerColumns.add(viewerColumn);
            TreeColumn column = viewerColumn.getColumn();
            column.setText(this.colLabels[i]);
            column.setData((Object)i);
            column.setResizable(true);
            column.setMoveable(false);
            ++i;
        }
        ((TreeViewerColumn)viewerColumns.get(0)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        ((TreeViewerColumn)viewerColumns.get(1)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public String getToolTipText(Object element) {
                IDocument doc;
                if (element instanceof IDocument && !(doc = (IDocument)element).getStatus().isEmpty()) {
                    return doc.getStatus().stream().map(s -> s.getName()).reduce((u, t) -> String.valueOf(u) + "," + t).get();
                }
                return super.getToolTipText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    java.util.Optional<DocumentStatus> sent = doc.getStatus().stream().filter(s -> s == DocumentStatus.SENT).findFirst();
                    if (sent.isPresent()) {
                        return Images.IMG_OUTBOX.getImage();
                    }
                    return Images.IMG_INBOX.getImage();
                }
                return super.getImage(element);
            }
        });
        ((TreeViewerColumn)viewerColumns.get(2)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return DocumentsView.this.bFlat ? doc.getCategory().getName() : "";
                }
                if (element instanceof ICategory) {
                    ICategory cat = (ICategory)element;
                    return cat.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof ICategory) {
                    return Images.IMG_FOLDER.getImage();
                }
                return super.getImage(element);
            }
        });
        ((TreeViewerColumn)viewerColumns.get(3)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return doc.getTitle();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    java.util.Optional opt = DocumentStoreServiceHolder.getService().getPersistenceObject(doc);
                    if (opt.isPresent() && ((ILocalDocumentService)LocalDocumentServiceHolder.getService().get()).contains(opt.get())) {
                        return Images.IMG_EDIT.getImage();
                    }
                }
                return super.getImage(element);
            }
        });
        ((TreeViewerColumn)viewerColumns.get(4)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return new TimeTool(doc.getCreated()).toString(4);
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return new TimeTool(doc.getCreated()).toString(1);
                }
                return super.getToolTipText(element);
            }
        });
        ((TreeViewerColumn)viewerColumns.get(5)).setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    List documentReferences = FindingsServiceHolder.getiFindingsService().getDocumentFindings(doc.getId(), IDocumentReference.class);
                    if (documentReferences.isEmpty()) {
                        return java.util.Optional.ofNullable(doc.getKeywords()).orElse("");
                    }
                    return java.util.Optional.ofNullable(Objects.toString(((IDocumentReference)documentReferences.get(0)).getKeywords(), doc.getKeywords())).orElse("");
                }
                return "";
            }
        });
        this.applyUsersColumnWidthSetting();
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        DocumentsFilterBarComposite filterBarComposite = this.addFilterBar(parent);
        this.contentProvider = new DocumentsTreeContentProvider(this.viewer).selectFilterCategory(filterBarComposite.getSelection());
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setUseHashlookup(true);
        this.viewer.addFilter((ViewerFilter)new ViewFilterProvider());
        this.bFlat = ConfigServiceHolder.getUser((String)SETTING_FLAT_VIEW, (boolean)false);
        this.contentProvider.setFlat(this.bFlat);
        this.ovComparator = new DocumentsViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.ovComparator);
        TreeColumn[] treeCols = this.viewer.getTree().getColumns();
        int i2 = 0;
        while (i2 < treeCols.length) {
            TreeColumn tc = treeCols[i2];
            tc.addSelectionListener(this.getSelectionAdapter(tc, i2));
            ++i2;
        }
        this.makeActions();
        this.applySortDirection();
        this.hookDoubleClickAction();
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    if (DocumentsView.this.bFlat && DocumentsView.this.currentDragSelection != null) {
                        return;
                    }
                    String[] files = (String[])event.data;
                    ICategory category = null;
                    if (event.item != null) {
                        if (event.item.getData() instanceof IDocument) {
                            IDocument dh = (IDocument)event.item.getData();
                            category = dh.getCategory();
                        } else if (event.item.getData() instanceof ICategory) {
                            category = (ICategory)event.item.getData();
                        }
                    }
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command cmd = commandService.getCommand("ch.elexis.core.ui.documents.commandCreate");
                    if (files != null) {
                        String[] stringArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String file = stringArray[n2];
                            Object created = null;
                            try {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("documents.file.path", file);
                                if (category != null) {
                                    params.put("documents.category", category.getName());
                                }
                                ExecutionEvent ev = new ExecutionEvent(cmd, params, null, null);
                                created = cmd.executeWithChecks(ev);
                            }
                            catch (Exception e) {
                                logger.error("drop error", (Throwable)e);
                            }
                            if (DocumentsView.this.currentDragSelection != null && created instanceof java.util.Optional && ((java.util.Optional)created).isPresent()) {
                                IDocument sourceDocument = (IDocument)DocumentsView.this.currentDragSelection.getFirstElement();
                                DocumentStoreServiceHolder.getService().removeDocument(sourceDocument);
                                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((Object)sourceDocument, IDocument.class, 2, 10000)});
                            }
                            ++n2;
                        }
                    }
                }
            }
        });
        Transfer[] dragTransferTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DocumentsView.this.viewer.getSelection();
                for (Object object : selection.toList()) {
                    IDocument document = (IDocument)object;
                    if (document.getContentLength() >= 1L) continue;
                    event.doit = false;
                    SWTHelper.showError((String)Messages.Core_Error_while_exporting, (String)(String.valueOf(Messages.DocumentView_exportErrorEmptyText) + "\nDokument: " + document.getTitle()));
                    break;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection;
                DocumentsView.this.currentDragSelection = selection = (IStructuredSelection)DocumentsView.this.viewer.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] documents = new String[selection.size()];
                    HashSet<String> titles = new HashSet<String>();
                    int i = 0;
                    while (i < selection.size()) {
                        IDocument dh = (IDocument)selection.toList().get(i);
                        try {
                            String absPath;
                            String _titel = dh.getTitle();
                            if (titles.contains(dh.getTitle())) {
                                _titel = String.valueOf(dh.getTitle()) + "(" + i + ")";
                            } else {
                                titles.add(dh.getTitle());
                            }
                            documents[i] = absPath = DocumentStoreServiceHolder.getService().saveContentToTempFile(dh, _titel, dh.getExtension(), true);
                        }
                        catch (ElexisException e) {
                            event.doit = false;
                            break;
                        }
                        event.data = documents;
                        ++i;
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    private void createFlatMenu(Composite filterComposite) {
        ToolBarManager tMenuManager = new ToolBarManager(8388928);
        tMenuManager.add((IAction)new Action("Neuer Brief", 1){
            {
                this.setImageDescriptor(Images.IMG_DOCUMENT_ADD.getImageDescriptor());
            }

            public void run() {
                ParameterizedCommand cmd = DocumentsView.this.commandService.createCommand("ch.elexis.core.ui.commands.BriefNew", null);
                if (cmd != null) {
                    DocumentsView.this.handlerService.executeHandler(cmd);
                }
                super.run();
            }
        });
        tMenuManager.add((IAction)new Action("AUF erstellen und drucken"){
            {
                this.setImageDescriptor(Images.IMG_VIEW_WORK_INCAPABLE.getImageDescriptor());
            }

            public void run() {
                Object createdAuf;
                ParameterizedCommand cmd = DocumentsView.this.commandService.createCommand("ch.elexis.core.ui.commands.AufNew", null);
                if (cmd != null && (createdAuf = DocumentsView.this.handlerService.executeHandler(cmd)) instanceof ISickCertificate) {
                    ContextServiceHolder.get().getRootContext().setTyped(createdAuf);
                    cmd = DocumentsView.this.commandService.createCommand("ch.elexis.core.ui.commands.AufPrint", null);
                    if (cmd != null) {
                        DocumentsView.this.handlerService.executeHandler(cmd);
                    }
                    ContextServiceHolder.get().getRootContext().removeTyped(ISickCertificate.class);
                }
                super.run();
            }
        });
        tMenuManager.createControl(filterComposite);
    }

    private DocumentsFilterBarComposite addFilterBar(Composite parent) {
        ArrayList<FilterCategory> filters = new ArrayList<FilterCategory>();
        filters.add(new FilterCategory(null, "Alle"));
        filters.add(new FilterCategory("Allg.", "Briefe"));
        filters.add(new FilterCategory("AUF-Zeugnis", "Auf"));
        filters.add(new FilterCategory("Rezept", "Rezepte"));
        DocumentsFilterBarComposite filterBarComposite = new DocumentsFilterBarComposite(parent, 0, filters);
        filterBarComposite.setLayoutData(new GridData(4, 128, true, false));
        filterBarComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DocumentsView.this.contentProvider != null) {
                    DocumentsView.this.contentProvider.selectFilterCategory(event.getSelection());
                }
            }
        });
        return filterBarComposite;
    }

    private SelectionListener getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentsView.this.ovComparator.setBFlat(DocumentsView.this.bFlat);
                DocumentsView.this.ovComparator.setColumn(index);
                DocumentsView.this.viewer.getTree().setSortDirection(DocumentsView.this.ovComparator.getDirection());
                DocumentsView.this.viewer.getTree().setSortColumn(column);
                DocumentsView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void applySortDirection() {
        String[] usrSortSettings = "0,1,-1,false".split(",");
        int propertyIdx = Integer.parseInt(usrSortSettings[0]);
        int direction = Integer.parseInt(usrSortSettings[1]);
        if (propertyIdx != 0) {
            this.sortViewer(propertyIdx, direction);
        }
    }

    private void sortViewer(int propertyIdx, int direction) {
        TreeColumn column = this.viewer.getTree().getColumn(propertyIdx);
        this.ovComparator.setColumn(propertyIdx);
        this.ovComparator.setDirection(direction);
        this.viewer.getTree().setSortDirection(this.ovComparator.getDirection());
        this.viewer.getTree().setSortColumn(column);
        this.viewer.refresh();
    }

    private void applyUsersColumnWidthSetting() {
        TreeColumn[] treeColumns = this.viewer.getTree().getColumns();
        String[] userColWidth = "20,20,150,250,100,500".split(",");
        int i = 0;
        while (i < treeColumns.length) {
            treeColumns[i].setWidth(Integer.parseInt(userColWidth[i]));
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public void activation(boolean mode) {
        if (!mode) {
            TreeColumn[] treeColumns = this.viewer.getTree().getColumns();
            StringBuilder sb = new StringBuilder();
            TreeColumn[] treeColumnArray = treeColumns;
            int n = treeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tc = treeColumnArray[n2];
                sb.append(tc.getWidth());
                sb.append(",");
                ++n2;
            }
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = DocumentsView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IDocument) {
                    IDocument dh = (IDocument)obj;
                    DocumentStoreServiceHolder.getService().getPersistenceObject(dh).ifPresent(po -> {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument");
                        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection(po));
                        try {
                            command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, null, null));
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            MessageDialog.openError((Shell)DocumentsView.this.getSite().getShell(), (String)"Fehler", (String)"Das Dokument konnte nicht ge\u00f6ffnet werden.");
                            e.printStackTrace();
                        }
                    });
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)dh);
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocumentsView.this.doubleClickAction.run();
            }
        });
    }

    public void switchFlatView(boolean bFlat) {
        this.bFlat = bFlat;
        if (this.viewer != null) {
            ConfigServiceHolder.setUser((String)SETTING_FLAT_VIEW, (boolean)bFlat);
            this.contentProvider.setFlat(bFlat);
            this.viewer.refresh();
        }
    }

    class ViewFilterProvider
    extends ViewerFilter {
        ViewFilterProvider() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (DocumentsView.this.searchTitle != null && !DocumentsView.this.searchTitle.isEmpty()) {
                String searchText = DocumentsView.this.searchTitle.toLowerCase();
                if (element instanceof ICategory) {
                    StructuredViewer sviewer = (StructuredViewer)viewer;
                    ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
                    Object[] objectArray = provider.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (this.select(viewer, element, child)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                if (element instanceof IDocument) {
                    IDocument iDocument = (IDocument)element;
                    if (iDocument.getCategory().getName().toLowerCase().startsWith(searchText)) {
                        return true;
                    }
                    if (iDocument.getTitle().toLowerCase().contains(searchText)) {
                        return true;
                    }
                    if (iDocument.getKeywords() != null && iDocument.getKeywords().toLowerCase().contains(searchText.toLowerCase())) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
    }
}

