/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v231;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v231.message.ADT_A08;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.PV1;
import ca.uhn.hl7v2.parser.PipeParser;
import ch.elexis.hl7.HL7Writer;
import ch.elexis.hl7.data.HL7Konsultation;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.util.HL7Helper;
import java.util.Date;

public class HL7_ADT_A08
extends HL7Writer {
    final String uniqueMessageControlID;
    final String uniqueProcessingID;
    final HL7Mandant mandant;

    public HL7_ADT_A08(String sendingApplication1, String sendingApplication3, String receivingApplication1, String receivingApplication3, String receivingFacility, String uniqueMessageControlID, String uniqueProcessingID, HL7Mandant mandant) {
        super(sendingApplication1, sendingApplication3, receivingApplication1, receivingApplication3, receivingFacility);
        this.uniqueMessageControlID = uniqueMessageControlID;
        this.uniqueProcessingID = uniqueProcessingID;
        this.mandant = mandant;
    }

    public String createText(HL7Patient patient, HL7Konsultation consultation) throws DataTypeException, HL7Exception {
        ADT_A08 adt = new ADT_A08();
        this.fillMSH(adt.getMSH(), "ADT", "A08", this.mandant, this.uniqueMessageControlID, "8859/1", patient);
        this.fillEVN(adt.getEVN());
        this.fillPID(adt.getPID(), patient);
        this.fillPV1(adt.getPV1(), consultation);
        DefaultHapiContext context = new DefaultHapiContext();
        PipeParser parser = context.getPipeParser();
        return parser.encode((Message)adt);
    }

    private void fillEVN(EVN evn) throws DataTypeException {
        evn.getEvn1_EventTypeCode().setValue("A08");
        evn.getEvn2_RecordedDateTime().getTs1_TimeOfAnEvent().setValue(HL7Helper.dateToString(new Date()));
    }

    private void fillPV1(PV1 pv1, HL7Konsultation consultation) throws DataTypeException {
        pv1.getAdmitDateTime().getTs1_TimeOfAnEvent().setValue(HL7Helper.dateToString(consultation.getZeitpunkt()));
        pv1.getVisitNumber().getCx1_ID().setValue(consultation.getId());
        pv1.getAlternateVisitID().getCx1_ID().setValue(consultation.getId());
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }
}

