/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.model.Identifiable;
import java.util.Date;
import java.util.Set;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Narrative;

public interface IdentifiableDomainResourceAttributeMapper<T extends Identifiable, U extends DomainResource> {
    default public void mapMetaData(Identifiable source, DomainResource target) {
        Meta meta = new Meta();
        meta.setLastUpdated(new Date(source.getLastupdate()));
        target.setMeta(meta);
    }

    default public void mapNarrative(Identifiable source, DomainResource target) {
        Narrative narrative = new Narrative();
        narrative.setStatus(Narrative.NarrativeStatus.GENERATED);
        narrative.setDivAsString(source.getLabel());
        target.setText(narrative);
    }

    public void elexisToFhir(T var1, U var2, SummaryEnum var3, Set<Include> var4);

    public void fhirToElexis(U var1, T var2);
}

