/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.types.Gender;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.StringType;

public class IContactHelper
extends AbstractHelper {
    private IModelService modelService;
    private IXidService xidService;
    private IUserService userService;

    public IContactHelper(IModelService modelService, IXidService xidService, IUserService userService) {
        this.modelService = modelService;
        this.xidService = xidService;
        this.userService = userService;
    }

    public List<HumanName> getHumanNames(IPerson person) {
        ArrayList<HumanName> ret = new ArrayList<HumanName>();
        if (person.isPerson()) {
            HumanName humanName = new HumanName();
            humanName.setFamily(person.getLastName());
            humanName.addGiven(person.getFirstName());
            humanName.addPrefix(person.getTitel());
            humanName.addSuffix(person.getTitelSuffix());
            humanName.setText(this.createLabel(person));
            humanName.setUse(HumanName.NameUse.OFFICIAL);
            ret.add(humanName);
        }
        return ret;
    }

    private String createLabel(IPerson person) {
        StringBuilder sb = new StringBuilder();
        String titel = person.getTitel();
        String firstName = person.getFirstName();
        String lastName = person.getLastName();
        String titelSuffix = person.getTitelSuffix();
        if (StringUtils.isNotBlank((CharSequence)titel)) {
            sb.append(String.valueOf(titel) + " ");
        }
        sb.append(firstName);
        sb.append(" " + lastName);
        if (StringUtils.isNotBlank((CharSequence)titelSuffix)) {
            sb.append(", " + titelSuffix);
        }
        return sb.toString();
    }

    public String getOrganizationName(IOrganization organization) {
        StringBuilder sb = new StringBuilder();
        if (organization.isOrganization()) {
            if (organization.getDescription1() != null) {
                sb.append(organization.getDescription1());
            }
            if (organization.getDescription2() != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(organization.getDescription2());
            }
        }
        return sb.toString();
    }

    public Enumerations.AdministrativeGender getGender(Gender gender) {
        if (gender == Gender.FEMALE) {
            return Enumerations.AdministrativeGender.FEMALE;
        }
        if (gender == Gender.MALE) {
            return Enumerations.AdministrativeGender.MALE;
        }
        if (gender == Gender.UNKNOWN) {
            return Enumerations.AdministrativeGender.UNKNOWN;
        }
        return Enumerations.AdministrativeGender.OTHER;
    }

    public Date getBirthDate(IPerson kontakt) {
        LocalDateTime dateOfBirth = kontakt.getDateOfBirth();
        if (dateOfBirth != null) {
            return this.getDate(dateOfBirth);
        }
        return null;
    }

    public List<Address> getAddresses(IContact contact) {
        ArrayList<Address> ret = new ArrayList<Address>();
        Address address = new Address();
        address.setUse(Address.AddressUse.HOME);
        address.setCity(contact.getCity());
        address.setPostalCode(contact.getZip());
        address.setCountry(contact.getCountry() != null ? contact.getCountry().name() : null);
        ArrayList<StringType> lines = new ArrayList<StringType>();
        lines.add(new StringType(contact.getStreet()));
        address.setLine(lines);
        ret.add(address);
        return ret;
    }

    public List<ContactPoint> getContactPoints(IContact contact) {
        ContactPoint contactPoint;
        ArrayList<ContactPoint> ret = new ArrayList<ContactPoint>();
        if (contact.getPhone1() != null && !contact.getPhone1().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setRank(1);
            contactPoint.setValue(contact.getPhone1());
            ret.add(contactPoint);
        }
        if (contact.getPhone2() != null && !contact.getPhone2().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setValue(contact.getPhone2());
            contactPoint.setRank(2);
            ret.add(contactPoint);
        }
        if (contact.getMobile() != null && !contact.getMobile().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            contactPoint.setUse(ContactPoint.ContactPointUse.MOBILE);
            contactPoint.setValue(contact.getMobile());
            ret.add(contactPoint);
        }
        if (contact.getEmail() != null && !contact.getEmail().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.EMAIL);
            contactPoint.setValue(contact.getEmail());
            ret.add(contactPoint);
        }
        if (contact.getWebsite() != null && !contact.getWebsite().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.URL);
            contactPoint.setValue(contact.getWebsite());
            ret.add(contactPoint);
        }
        if (contact.getFax() != null && !contact.getFax().isEmpty()) {
            contactPoint = new ContactPoint();
            contactPoint.setSystem(ContactPoint.ContactPointSystem.FAX);
            contactPoint.setValue(contact.getFax());
            ret.add(contactPoint);
        }
        return ret;
    }

    public List<Identifier> getIdentifiers(IContact contact) {
        ArrayList<Identifier> ret = new ArrayList<Identifier>();
        List xids = this.xidService.getXids((Identifiable)contact);
        for (IXid xid : xids) {
            Identifier identifier = new Identifier();
            identifier.setSystem(xid.getDomain());
            identifier.setValue(xid.getDomainId());
            ret.add(identifier);
        }
        return ret;
    }
}

