/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IAppointmentSlotAttributeMapper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Slot;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"transformer.id=Slot.IAppointment"})
public class SlotTerminTransformer
implements IFhirTransformer<Slot, IAppointment> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAppointmentService appointmentService;
    private IAppointmentSlotAttributeMapper attributeMapper;

    @Activate
    private void activate() {
        this.attributeMapper = new IAppointmentSlotAttributeMapper(this.appointmentService);
    }

    @Override
    public Optional<Slot> getFhirObject(IAppointment localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Slot slot = new Slot();
        this.attributeMapper.elexisToFhir(localObject, slot, summaryEnum, includes);
        return Optional.of(slot);
    }

    @Override
    public Optional<IAppointment> getLocalObject(Slot fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.coreModelService.load(id, IAppointment.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IAppointment> updateLocalObject(Slot fhirObject, IAppointment localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<IAppointment> createLocalObject(Slot fhirObject) {
        IAppointment create = (IAppointment)this.coreModelService.create(IAppointment.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.coreModelService.save((Identifiable)create);
        return Optional.of(create);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Slot.class.equals(fhirClazz) && IAppointment.class.equals(localClazz);
    }
}

