/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IAppointmentAppointmentAttributeMapper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Appointment;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AppointmentTerminTransformer
implements IFhirTransformer<Appointment, IAppointment> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAppointmentService appointmentService;
    @Reference
    private IConfigService configService;
    private IAppointmentAppointmentAttributeMapper attributeMapper;

    @Activate
    private void activate() {
        this.attributeMapper = new IAppointmentAppointmentAttributeMapper(this.appointmentService, this.coreModelService, this.configService);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Appointment.class.equals(fhirClazz) && IAppointment.class.equals(localClazz);
    }

    @Override
    public Optional<IAppointment> getLocalObject(Appointment fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.coreModelService.load(id, IAppointment.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IAppointment> createLocalObject(Appointment fhirObject) {
        throw new UnsupportedOperationException("Create Slot first, then perform update operation using Slot id.");
    }

    @Override
    public Optional<Appointment> getFhirObject(IAppointment localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Appointment appointment = new Appointment();
        this.attributeMapper.elexisToFhir(localObject, appointment, summaryEnum, includes);
        return Optional.of(appointment);
    }

    @Override
    public Optional<IAppointment> updateLocalObject(Appointment fhirObject, IAppointment localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }
}

