/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.FindingsFormatUtil;
import ch.elexis.core.findings.util.model.CodingWrapper;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class ModelUtil {
    private static IModelService findingsModelService;
    private static FhirContext context;

    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    public void setFindingsModelService(IModelService modelService) {
        findingsModelService = modelService;
    }

    public static <T> Optional<T> loadFinding(String id, Class<T> clazz) {
        if (id != null) {
            return findingsModelService.load(id, clazz);
        }
        return Optional.empty();
    }

    public static <T> INamedQuery<T> getFindingsNamedQuery(Class<T> clazz, String ... properties) {
        return findingsModelService.getNamedQuery(clazz, properties);
    }

    public static <T> T createFinding(Class<T> clazz) {
        return (T)findingsModelService.create(clazz);
    }

    public static void saveFinding(Identifiable identifiable) {
        findingsModelService.save(identifiable);
    }

    public static void deleteFinding(Deleteable deleteable) {
        findingsModelService.delete(deleteable);
    }

    private static IParser getJsonParser() {
        if (context == null) {
            context = FhirContext.forR4();
        }
        return context.newJsonParser();
    }

    public static IBaseResource getAsResource(String jsonResource) {
        return ModelUtil.getJsonParser().parseResource(jsonResource);
    }

    public static Optional<IBaseResource> loadResource(IFinding finding) throws DataFormatException {
        IBaseResource resource = null;
        String rawContent = finding.getRawContent();
        if (rawContent != null && !rawContent.isEmpty()) {
            Optional<String> convertedContent;
            if (!FindingsFormatUtil.isCurrentFindingsFormat(rawContent) && (convertedContent = FindingsFormatUtil.convertToCurrentFindingsFormat(rawContent)).isPresent()) {
                rawContent = convertedContent.get();
            }
            resource = ModelUtil.getAsResource(rawContent);
        }
        return Optional.ofNullable(resource);
    }

    public static void saveResource(IBaseResource resource, IFinding finding) throws DataFormatException {
        if (resource != null) {
            String resourceJson = ModelUtil.getJsonParser().encodeResourceToString(resource);
            finding.setRawContent(resourceJson);
        }
    }

    public static void setCodingsToConcept(CodeableConcept codeableConcept, List<ICoding> coding) {
        codeableConcept.getCoding().clear();
        for (ICoding iCoding : coding) {
            ModelUtil.setCodingToConcept(codeableConcept, iCoding);
        }
    }

    public static void setCodingToConcept(CodeableConcept codeableConcept, ICoding iCoding) {
        codeableConcept.addCoding(new Coding(iCoding.getSystem(), iCoding.getCode(), iCoding.getDisplay()));
    }

    public static List<ICoding> getCodingsFromConcept(CodeableConcept codeableConcept) {
        ArrayList<ICoding> ret = new ArrayList<ICoding>();
        List coding = codeableConcept.getCoding();
        for (Coding code : coding) {
            ret.add(new CodingWrapper(code));
        }
        return ret;
    }

    public static boolean isCodeInList(String system, String code, List<ICoding> list) {
        if (list != null && !list.isEmpty()) {
            for (ICoding iCoding : list) {
                if (!iCoding.getSystem().equals(system) || !iCoding.getCode().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemInList(String system, List<ICoding> list) {
        if (list != null && !list.isEmpty()) {
            for (ICoding iCoding : list) {
                if (!iCoding.getSystem().equals(system)) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<ICoding> getCodeBySystem(List<ICoding> coding, CodingSystem codingSystem) {
        for (ICoding iCoding : coding) {
            if (!codingSystem.getSystem().equals(iCoding.getSystem())) continue;
            return Optional.of(iCoding);
        }
        return Optional.empty();
    }

    public static Optional<CodeableConcept> getCodeableConceptBySystem(List<CodeableConcept> concepts, CodingSystem codingSystem) {
        for (CodeableConcept concept : concepts) {
            Optional<ICoding> found = ModelUtil.getCodeBySystem(ModelUtil.getCodingsFromConcept(concept), codingSystem);
            if (!found.isPresent()) continue;
            return Optional.of(concept);
        }
        return Optional.empty();
    }

    public static Optional<CodeableConcept> getCodeableConceptBySystem(List<CodeableConcept> concepts, String codingSystem) {
        for (CodeableConcept concept : concepts) {
            Optional<ICoding> found = ModelUtil.getCodeBySystem(ModelUtil.getCodingsFromConcept(concept), codingSystem);
            if (!found.isPresent()) continue;
            return Optional.of(concept);
        }
        return Optional.empty();
    }

    public static Optional<ICoding> getCodeBySystem(List<ICoding> coding, String codingSystem) {
        for (ICoding iCoding : coding) {
            if (!codingSystem.equals(iCoding.getSystem())) continue;
            return Optional.of(iCoding);
        }
        return Optional.empty();
    }

    public static Optional<String> getNarrativeAsString(Narrative narrative) {
        String text = narrative.getDivAsString();
        if (text != null) {
            String divDecodedText = text.replaceAll("<div>|<div xmlns=\"http://www.w3.org/1999/xhtml\">|</div>|</ div>", "");
            divDecodedText = divDecodedText.replaceAll("<br/>|<br />", "\n").replaceAll("&amp;", "&").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("'&sect;'", "\u00a7");
            return Optional.of(divDecodedText);
        }
        return Optional.empty();
    }

    public static void setNarrativeFromString(Narrative narrative, String text) {
        try {
            text = ModelUtil.fixXhtmlContent(text);
            String divEncodedText = text.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\u00a7", "'&sect;'").replaceAll("&", "&amp;").replaceAll("(\r\n|\r|\n)", "<br />");
            divEncodedText = ModelUtil.addDivToEncodedText(divEncodedText);
            narrative.setDivAsString(divEncodedText);
            narrative.setStatus(Narrative.NarrativeStatus.GENERATED);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ModelUtil.class).error("Could not set narrative text [" + text + "]");
            throw e;
        }
    }

    private static String addDivToEncodedText(String divEncodedText) {
        if (!divEncodedText.startsWith("<div")) {
            divEncodedText = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + divEncodedText + "</div>";
        }
        return divEncodedText;
    }

    private static String fixXhtmlContent(String content) {
        content = content.replace('\u00a0', ' ');
        return content;
    }

    public static boolean isSameCoding(ICoding left, ICoding right) {
        return left.getSystem().equals(right.getSystem()) && left.getCode().equals(right.getCode());
    }

    public static void addCodingIfNotPresent(List<ICoding> coding, ICoding iCoding) {
        for (ICoding presentCoding : coding) {
            if (!ModelUtil.isSameCoding(presentCoding, iCoding)) continue;
            return;
        }
        coding.add(iCoding);
    }

    public static String getExactUnitOfComponent(List<ObservationComponent> observationComponents) {
        HashSet<String> units = new HashSet<String>();
        for (ObservationComponent child : observationComponents) {
            Optional valueUnit = child.getNumericValueUnit();
            if (valueUnit.isPresent()) {
                units.add((String)valueUnit.get());
                continue;
            }
            return null;
        }
        return units.size() == 1 ? (String)units.iterator().next() : null;
    }

    public static List<IObservation> getObservationChildren(IObservation iObservation, List<IObservation> list, int maxDepth) {
        if (maxDepth > 0) {
            List refChildrens = iObservation.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
            list.addAll(refChildrens);
            for (IObservation child : refChildrens) {
                ModelUtil.getObservationChildren(child, list, --maxDepth);
            }
        }
        return list;
    }

    public static IObservation getRootObservationRecursive(IObservation observation) {
        IObservation rootObservation = observation;
        List sources = observation.getSourceObservations(IObservationLink.ObservationLinkType.REF);
        if (sources != null && !sources.isEmpty()) {
            for (IObservation iObservation : sources) {
                rootObservation = ModelUtil.getRootObservationRecursive(iObservation);
            }
        }
        return rootObservation;
    }

    public static <T extends IFinding> void initFhir(T created, Class<T> type) {
        if (type.equals(IEncounter.class)) {
            Encounter fhirEncounter = new Encounter();
            fhirEncounter.setId((IIdType)new IdType(fhirEncounter.getClass().getSimpleName(), created.getId()));
            fhirEncounter.setClass_(new Coding("2.16.840.1.113883.1.11.13955", "AMB", "ambulatory"));
            ModelUtil.saveResource((IBaseResource)fhirEncounter, created);
        } else if (type.equals(IObservation.class)) {
            Observation fhirObservation = new Observation();
            fhirObservation.setId((IIdType)new IdType(fhirObservation.getClass().getSimpleName(), created.getId()));
            fhirObservation.setStatus(Observation.ObservationStatus.FINAL);
            ModelUtil.saveResource((IBaseResource)fhirObservation, created);
        } else if (type.equals(ICondition.class)) {
            Condition fhirCondition = new Condition();
            fhirCondition.setId((IIdType)new IdType(fhirCondition.getClass().getSimpleName(), created.getId()));
            fhirCondition.setRecordedDate(new Date());
            ModelUtil.saveResource((IBaseResource)fhirCondition, created);
        } else if (type.equals(IProcedureRequest.class)) {
            ServiceRequest fhirProcedureRequest = new ServiceRequest();
            fhirProcedureRequest.setId((IIdType)new IdType(fhirProcedureRequest.getClass().getSimpleName(), created.getId()));
            ModelUtil.saveResource((IBaseResource)fhirProcedureRequest, created);
        } else if (type.equals(IFamilyMemberHistory.class)) {
            FamilyMemberHistory fhirFamilyMemberHistory = new FamilyMemberHistory();
            fhirFamilyMemberHistory.setId((IIdType)new IdType(fhirFamilyMemberHistory.getClass().getSimpleName(), created.getId()));
            ModelUtil.saveResource((IBaseResource)fhirFamilyMemberHistory, created);
        } else if (type.equals(IAllergyIntolerance.class)) {
            AllergyIntolerance fhirAllergyIntolerance = new AllergyIntolerance();
            fhirAllergyIntolerance.setId((IIdType)new IdType(fhirAllergyIntolerance.getClass().getSimpleName(), created.getId()));
            ModelUtil.saveResource((IBaseResource)fhirAllergyIntolerance, created);
        } else if (type.equals(IClinicalImpression.class)) {
            ClinicalImpression fhirClinicalImpression = new ClinicalImpression();
            fhirClinicalImpression.setId((IIdType)new IdType(fhirClinicalImpression.getClass().getSimpleName(), created.getId()));
            ModelUtil.saveResource((IBaseResource)fhirClinicalImpression, created);
        } else if (type.equals(IDocumentReference.class)) {
            DocumentReference fhirDocumentReference = new DocumentReference();
            fhirDocumentReference.setId((IIdType)new IdType(fhirDocumentReference.getClass().getSimpleName(), created.getId()));
            fhirDocumentReference.setStatus(Enumerations.DocumentReferenceStatus.CURRENT);
            ModelUtil.saveResource((IBaseResource)fhirDocumentReference, created);
        } else {
            LoggerFactory.getLogger(ModelUtil.class).error("Could not initialize unknown type [" + type + "]");
        }
    }

    public static boolean fixFhirResource(IFinding finding) {
        Encounter fhirEncounter;
        boolean changed = false;
        Optional<IBaseResource> resource = ModelUtil.loadResource(finding);
        if (resource.isPresent() && resource.get() instanceof Encounter && ((fhirEncounter = (Encounter)resource.get()).getClass_() == null || fhirEncounter.getClass_().getSystem() == null)) {
            fhirEncounter.setClass_(new Coding("2.16.840.1.113883.1.11.13955", "AMB", "ambulatory"));
            ModelUtil.saveResource((IBaseResource)fhirEncounter, finding);
            changed = true;
        }
        return changed;
    }
}

