/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"rdbmsType", "hostName", "port", "databaseName", "connectionString", "username", "password", "text"})
public class DBConnection
implements Serializable {
    private static final long serialVersionUID = -7571011690246990109L;
    public DBType rdbmsType;
    @XmlAttribute
    public String hostName;
    @XmlAttribute
    public String port;
    @XmlAttribute
    public String databaseName;
    @XmlAttribute
    public String connectionString;
    @XmlAttribute
    public String username;
    @XmlAttribute
    public String password;
    @XmlAttribute
    public String text;

    public DBConnection(DBType rdbmsType, String jdbcString, String username, char[] password) {
        this.rdbmsType = rdbmsType;
        this.connectionString = jdbcString;
        this.username = username;
        this.password = new String(password);
    }

    public DBConnection() {
    }

    public boolean allValuesSet() {
        boolean result = true;
        if (this.rdbmsType == null) {
            result = false;
        }
        if (!DBType.H2.equals((Object)this.rdbmsType) && StringUtils.isBlank((CharSequence)this.hostName)) {
            result = false;
        }
        if (StringUtils.isBlank((CharSequence)this.databaseName)) {
            result = false;
        }
        if (StringUtils.isBlank((CharSequence)this.username)) {
            result = false;
        }
        return result;
    }

    public void marshall(OutputStream os) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
        Marshaller m = jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, os);
    }

    public static DBConnection unmarshall(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
        Unmarshaller um = jaxbContext.createUnmarshaller();
        Object o = um.unmarshal(is);
        return (DBConnection)o;
    }

    public String marshallIntoString() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter sw = new StringWriter();){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)this, (Writer)sw);
                return sw.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JAXBException e) {
            return "";
        }
    }

    public static DBConnection unmarshall(String value) {
        if (value == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            return DBConnection.unmarshall(byteArrayInputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return new DBConnection();
        }
    }

    public static Optional<String> getHostName(String url) {
        URI uri;
        String host;
        if (url == null || url.startsWith("jdbc:h2:")) {
            return Optional.empty();
        }
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (!StringUtils.isEmpty((CharSequence)(host = (uri = URI.create(url)).getHost()))) {
            return Optional.of(host);
        }
        return Optional.empty();
    }

    public static Optional<String> getDatabaseName(String url) {
        URI uri;
        String path;
        if (url.startsWith("jdbc:h2:") && (url = url.substring("jdbc:h2:".length())).indexOf(59) > -1) {
            url = url.substring(0, url.indexOf(59));
            return Optional.of(url);
        }
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (!StringUtils.isBlank((CharSequence)(path = (uri = URI.create(url)).getPath()))) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.contains("/")) {
                path = path.substring(0, path.indexOf("/"));
            }
            return Optional.of(path);
        }
        return Optional.empty();
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum DBType {
        MySQL("com.mysql.cj.jdbc.Driver", "mySQl", "3306"),
        PostgreSQL("org.postgresql.Driver", "PostgreSQL", "5432"),
        H2("org.h2.Driver", "H2", "");

        public final String driverName;
        public final String dbType;
        public final String defaultPort;

        private DBType(String driverName, String dbType, String defaultPort) {
            this.driverName = driverName;
            this.dbType = dbType;
            this.defaultPort = defaultPort;
        }

        public static Optional<DBType> valueOfIgnoreCase(String value) {
            DBType[] dBTypeArray = DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBType dbType = dBTypeArray[n2];
                if (dbType.dbType.equalsIgnoreCase(value)) {
                    return Optional.of(dbType);
                }
                ++n2;
            }
            return Optional.empty();
        }

        public static Optional<DBType> valueOfDriver(String driver) {
            if (driver.equals("com.mysql.jdbc.Driver")) {
                return Optional.of(MySQL);
            }
            DBType[] dBTypeArray = DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBType dbType = dBTypeArray[n2];
                if (dbType.driverName.equals(driver)) {
                    return Optional.of(dbType);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }
}

