/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts;

import ch.elexis.core.l10n.Messages;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.slf4j.LoggerFactory;

public class PdfPreviewPartLoadHandler {
    private static ExecutorService loader = Executors.newSingleThreadExecutor();
    private final ScrolledComposite scrolledComposite;
    private final Composite previewComposite;
    private float scalingFactor;
    private Label headLabel;
    private int numberOfPages;
    private Image[] images;
    private PDDocument pdDocument;

    public PdfPreviewPartLoadHandler(InputStream pdfInputStream, Float scalingFactor, Composite previewComposite, ScrolledComposite scrolledComposite) {
        this.previewComposite = previewComposite;
        this.scrolledComposite = scrolledComposite;
        this.scalingFactor = scalingFactor != null ? scalingFactor.floatValue() : 1.0f;
        loader.submit(new LoaderRunnable(pdfInputStream));
    }

    protected void unloadDocument() throws IOException {
        if (this.pdDocument != null) {
            this.pdDocument.close();
            this.pdDocument = null;
        }
    }

    public void changeScalingFactor(Float scalingFactor) {
        this.scalingFactor = scalingFactor.floatValue();
        loader.submit(new LoaderRunnable(null));
    }

    public void close() {
        if (this.pdDocument != null) {
            try {
                this.pdDocument.close();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Excepton closing PDDocument", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    private class LoaderRunnable
    implements Runnable {
        private InputStream pdfInputStream;

        public LoaderRunnable(InputStream pdfInputStream) {
            this.pdfInputStream = pdfInputStream;
        }

        @Override
        public void run() {
            try {
                PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().syncExec(() -> {
                    Control[] children;
                    PdfPreviewPartLoadHandler.this.headLabel = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                    PdfPreviewPartLoadHandler.this.headLabel.setText(Messages.PdfPreview_NoPDFSelected);
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                    Control[] controlArray = children = PdfPreviewPartLoadHandler.this.previewComposite.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (!PdfPreviewPartLoadHandler.this.headLabel.equals(control)) {
                            control.dispose();
                        }
                        ++n2;
                    }
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                });
                if (PdfPreviewPartLoadHandler.this.pdDocument == null) {
                    if (this.pdfInputStream != null) {
                        PdfPreviewPartLoadHandler.this.pdDocument = PDDocument.load((InputStream)this.pdfInputStream);
                        this.pdfInputStream.close();
                        PdfPreviewPartLoadHandler.this.numberOfPages = PdfPreviewPartLoadHandler.this.pdDocument.getNumberOfPages();
                        PdfPreviewPartLoadHandler.this.images = new Image[PdfPreviewPartLoadHandler.this.numberOfPages];
                    } else if (this.pdfInputStream == null && PdfPreviewPartLoadHandler.this.pdDocument == null) {
                        return;
                    }
                }
                PDFRenderer renderer = new PDFRenderer(PdfPreviewPartLoadHandler.this.pdDocument);
                int i = 0;
                while (i < PdfPreviewPartLoadHandler.this.numberOfPages) {
                    int j = i;
                    BufferedImage bufferedImage = renderer.renderImage(i, PdfPreviewPartLoadHandler.this.scalingFactor);
                    ImageData imageData = PdfPreviewPartLoadHandler.this.convertToSWT(bufferedImage);
                    PdfPreviewPartLoadHandler.this.images[j] = new Image((Device)PdfPreviewPartLoadHandler.this.previewComposite.getDisplay(), imageData);
                    PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().asyncExec(() -> {
                        if (j == 0) {
                            PdfPreviewPartLoadHandler.this.headLabel.setText("");
                            PdfPreviewPartLoadHandler.this.headLabel.setImage(PdfPreviewPartLoadHandler.this.images[j]);
                            PdfPreviewPartLoadHandler.this.headLabel.addDisposeListener(dl -> PdfPreviewPartLoadHandler.this.images[j].dispose());
                        } else {
                            Label label = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                            label.setImage(PdfPreviewPartLoadHandler.this.images[j]);
                            label.addDisposeListener(dl -> PdfPreviewPartLoadHandler.this.images[j].dispose());
                        }
                        PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                        PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                        PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                    });
                    ++i;
                }
            }
            catch (IOException e) {
                PdfPreviewPartLoadHandler.this.previewComposite.getDisplay().asyncExec(() -> {
                    if (PdfPreviewPartLoadHandler.this.headLabel != null) {
                        PdfPreviewPartLoadHandler.this.headLabel.dispose();
                    }
                    PdfPreviewPartLoadHandler.this.headLabel = new Label(PdfPreviewPartLoadHandler.this.previewComposite, 0);
                    PdfPreviewPartLoadHandler.this.headLabel.setText(e.getMessage());
                    PdfPreviewPartLoadHandler.this.previewComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.layout(true, true);
                    PdfPreviewPartLoadHandler.this.scrolledComposite.setMinSize(PdfPreviewPartLoadHandler.this.previewComposite.computeSize(-1, -1));
                });
            }
        }
    }
}

