/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Condition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONItemType;
import org.h2.util.json.JSONStringSource;
import org.h2.util.json.JSONValidationTarget;
import org.h2.util.json.JSONValidationTargetWithUniqueKeys;
import org.h2.util.json.JSONValidationTargetWithoutUniqueKeys;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

public class IsJsonPredicate
extends Condition {
    private Expression left;
    private final boolean not;
    private final boolean withUniqueKeys;
    private final JSONItemType itemType;

    public IsJsonPredicate(Expression expression, boolean bl, boolean bl2, JSONItemType jSONItemType) {
        this.left = expression;
        this.not = bl;
        this.withUniqueKeys = bl2;
        this.itemType = jSONItemType;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" IS");
        if (this.not) {
            stringBuilder.append(" NOT");
        }
        stringBuilder.append(" JSON");
        switch (this.itemType) {
            case VALUE: {
                break;
            }
            case ARRAY: {
                stringBuilder.append(" ARRAY");
                break;
            }
            case OBJECT: {
                stringBuilder.append(" OBJECT");
                break;
            }
            case SCALAR: {
                stringBuilder.append(" SCALAR");
                break;
            }
            default: {
                throw DbException.throwInternalError("itemType=" + (Object)((Object)this.itemType));
            }
        }
        if (this.withUniqueKeys) {
            stringBuilder.append(" WITH UNIQUE KEYS");
        }
        return stringBuilder.append(')');
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        boolean bl;
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (value.getValueType()) {
            case 12: 
            case 15: {
                byte[] byArray = value.getBytesNoCopy();
                JSONValidationTarget jSONValidationTarget = this.withUniqueKeys ? new JSONValidationTargetWithUniqueKeys() : new JSONValidationTargetWithoutUniqueKeys();
                try {
                    bl = this.itemType.includes(JSONBytesSource.parse(byArray, jSONValidationTarget)) ^ this.not;
                }
                catch (RuntimeException runtimeException) {
                    bl = this.not;
                }
                break;
            }
            case 40: {
                Object object = ((ValueJson)value).getItemType();
                if (!this.itemType.includes((JSONItemType)((Object)object))) {
                    bl = this.not;
                    break;
                }
                if (!this.withUniqueKeys || object == JSONItemType.SCALAR) {
                    bl = !this.not;
                    break;
                }
            }
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                Object object = value.getString();
                JSONValidationTarget jSONValidationTarget = this.withUniqueKeys ? new JSONValidationTargetWithUniqueKeys() : new JSONValidationTargetWithoutUniqueKeys();
                try {
                    bl = this.itemType.includes(JSONStringSource.parse(object, jSONValidationTarget)) ^ this.not;
                }
                catch (RuntimeException runtimeException) {
                    bl = this.not;
                }
                break;
            }
            default: {
                bl = this.not;
            }
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new IsJsonPredicate(this.left, !this.not, this.withUniqueKeys, this.itemType);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        n = !(this.left.getType().getValueType() != 40 || this.withUniqueKeys && this.itemType != JSONItemType.SCALAR) ? ++n : (n += 10);
        return n;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.left;
        }
        throw new IndexOutOfBoundsException();
    }
}

