/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.logback.rocketchat;

import ch.elexis.core.logback.rocketchat.internal.IntegrationPostHandler;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;

public class RocketchatAppender
extends AppenderBase<ILoggingEvent> {
    public void start() {
        if (this.getContext().getProperty("identification") == null) {
            this.getContext().putProperty("identification", "logback");
            this.addInfo("No <identification> parameter defined, defaulting to logback.");
        }
        super.start();
    }

    protected void append(ILoggingEvent eventObject) {
        try {
            boolean attachmentBased;
            String integrationUrl = this.getContext().getProperty("integrationUrl");
            if (integrationUrl == null || integrationUrl.length() == 0) {
                return;
            }
            URL realIntegrationUrl = new URL(integrationUrl);
            String identification = this.getContext().getProperty("identification");
            IStatus postStatus = new IntegrationPostHandler(eventObject, identification, attachmentBased = this.getContext().getProperty("attachmentBased") == null ? true : Boolean.valueOf(this.getContext().getProperty("attachmentBased"))).post(realIntegrationUrl);
            if (!postStatus.isOK()) {
                this.addError("Error posting to integrationUrl [" + this.getContext().getProperty("integrationUrl") + "]: " + postStatus.getMessage());
            }
        }
        catch (IOException ex) {
            this.addError("Error posting to integrationUrl [" + this.getContext().getProperty("integrationUrl") + "]: " + ex.getLocalizedMessage());
        }
    }

    public String getEvent() {
        return this.getContext().getProperty("event");
    }

    public void setEvent(String event) {
        this.getContext().putProperty("event", event);
    }

    public String getIntegrationUrl() {
        return this.getContext().getProperty("integrationUrl");
    }

    public void setIntegrationUrl(String integrationUrl) {
        this.addInfo("Changing integration url ...");
        this.getContext().putProperty("integrationUrl", integrationUrl);
    }

    public String getIdentification() {
        return this.getContext().getProperty("identification");
    }

    public void setIdentification(String identification) {
        this.getContext().putProperty("identification", identification);
    }

    public String getAttachmentBased() {
        return this.getContext().getProperty("attachmentBased");
    }

    public void setAttachmentBased(String attachmentBased) {
        this.getContext().putProperty("attachmentBased", attachmentBased);
    }
}

