/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.laboratory.controls.LaborMappingComposite;
import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.scripting.ScriptEditor;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class EditLabItem
extends TitleAreaDialog {
    private LaborMappingComposite mapping;
    Text iKuerzel;
    Text iTitel;
    Text iRef;
    Text iRfF;
    Text iUnit;
    Text iPrio;
    Text iComma;
    Combo cGroup;
    Combo cExportTag;
    Button alph;
    Button numeric;
    Button abs;
    Button formula;
    Button document;
    Button visible;
    String formel;
    org.eclipse.swt.widgets.List labors;
    Labor actLabor;
    LabItem actLabItem;
    ArrayList<String> groups = new ArrayList();
    ArrayList<String> exportTags = new ArrayList();
    private Text loincCode;
    private Button loincCodeSelection;
    Label originLaboratory;
    Button originLaboratorySelection;
    Button noRefValues;

    public EditLabItem(Shell parentShell, LabItem act) {
        super(parentShell);
        this.actLabItem = act;
        if (act != null) {
            this.actLabor = this.actLabItem != null ? this.actLabItem.getLabor() : null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.Core_Laboratory_parameter);
        this.setTitle(Messages.Core_Enter_new_laboratory_parameter);
        this.setMessage(Messages.EditLabItem_message);
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(4, false));
        this.mapping = new LaborMappingComposite(ret, 0);
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        layoutData.heightHint = 150;
        this.mapping.setLayoutData(layoutData);
        this.mapping.setLabItem(this.actLabItem);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Short_Label);
        this.iKuerzel = new Text(ret, 2048);
        this.iKuerzel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.iKuerzel.setTextLimit(80);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Title);
        this.iTitel = new Text(ret, 2048);
        this.iTitel.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.iTitel.setTextLimit(80);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Type);
        Group grp = new Group(ret, 0);
        grp.setLayout((Layout)new FillLayout(256));
        grp.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.numeric = new Button((Composite)grp, 16);
        this.numeric.setText(Messages.Core_Number);
        this.alph = new Button((Composite)grp, 16);
        this.alph.setText(Messages.Core_Text);
        this.abs = new Button((Composite)grp, 16);
        this.abs.setText(Messages.Core_Absolute);
        this.formula = new Button((Composite)grp, 16);
        this.formula.setText(Messages.Core_Formula);
        this.formula.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptEditor se;
                if (EditLabItem.this.formula.getSelection() && (se = new ScriptEditor(EditLabItem.this.getShell(), EditLabItem.this.formel, Messages.EditLabItem_titleScriptEditor)).open() == 0) {
                    EditLabItem.this.formel = se.getScript();
                }
            }
        });
        this.document = new Button((Composite)grp, 16);
        this.document.setText(Messages.Core_Document);
        this.document.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditLabItem.this.documentSelectionChanged();
            }
        });
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Reference_Male);
        this.iRef = new Text(ret, 2048);
        this.iRef.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.iRef.setTextLimit(80);
        this.iRef.setEnabled(this.actLabItem == null || !this.actLabItem.isNoReferenceValueItem());
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Reference_female);
        this.iRfF = new Text(ret, 2048);
        this.iRfF.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.iRfF.setTextLimit(80);
        this.iRfF.setEnabled(this.actLabItem == null || !this.actLabItem.isNoReferenceValueItem());
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Unit);
        this.noRefValues = new Button((Composite)grp, 32);
        this.noRefValues.setText(ch.elexis.core.l10n.Messages.LabResultEvaluator_LabItemNoRefValue);
        this.noRefValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditLabItem.this.iRef.setEnabled(!EditLabItem.this.noRefValues.getSelection());
                EditLabItem.this.iRfF.setEnabled(!EditLabItem.this.noRefValues.getSelection());
            }
        });
        this.noRefValues.setSelection(this.actLabItem != null && this.actLabItem.isNoReferenceValueItem());
        this.iUnit = new Text(ret, 2048);
        this.iUnit.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.iUnit.setTextLimit(25);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Group);
        List labItems = LabItem.getLabItems();
        this.groups.clear();
        this.exportTags.clear();
        for (LabItem li : labItems) {
            if (li.getExport() != null && li.getExport().length() > 0 && !this.exportTags.contains(li.getExport())) {
                this.exportTags.add(li.getExport());
            }
            if (this.groups.contains(li.getGroup())) continue;
            this.groups.add(li.getGroup());
        }
        Collections.sort(this.groups);
        Collections.sort(this.exportTags);
        this.cGroup = new Combo(ret, 4);
        this.cGroup.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cGroup.setToolTipText(Messages.Core_Labgroup);
        this.cGroup.setItems(this.groups.toArray(new String[0]));
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Sequence_number);
        this.iPrio = new Text(ret, 2048);
        this.iPrio.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.iPrio.setToolTipText(Messages.Core_Sequence_inside_group);
        this.iPrio.setTextLimit(3);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.EditLabItem_OriginLaboratoryLabel);
        this.originLaboratory = new Label(ret, 0);
        this.originLaboratory.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.originLaboratory.setText(this.actLabor != null ? this.actLabor.getLabel() : "");
        this.originLaboratorySelection = new Button(ret, 8);
        this.originLaboratorySelection.setText("...");
        this.originLaboratorySelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(EditLabItem.this.getShell(), Labor.class, Messages.Laboratory_Please_Select_Origin, Messages.Laboratory_Please_Select_Origin, false, new String[0]);
                if (ksl.open() == 0) {
                    EditLabItem.this.actLabor = (Labor)ksl.getSelection();
                    EditLabItem.this.originLaboratory.setText(EditLabItem.this.actLabor.getLabel());
                } else {
                    EditLabItem.this.actLabor = null;
                    EditLabItem.this.originLaboratory.setText("");
                }
            }
        });
        WidgetFactory.createLabel((Composite)ret, (String)"LOINC");
        this.loincCode = new Text(ret, 2048);
        this.loincCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.loincCode.setTextLimit(80);
        this.loincCode.setEnabled(false);
        this.loincCodeSelection = new Button(ret, 8);
        this.loincCodeSelection.setText("...");
        this.loincCodeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionDialog dialog = CodeSelectorFactory.getSelectionDialog((String)"LOINC", (Shell)EditLabItem.this.getShell(), null);
                if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length > 0) {
                    ICodeElement code = (ICodeElement)dialog.getResult()[0];
                    EditLabItem.this.loincCode.setText(code.getCode());
                }
            }
        });
        WidgetFactory.createLabel((Composite)ret, (String)Messages.EditLabItem_labelDecimalPlace);
        this.iComma = new Text(ret, 2048);
        this.iComma.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.iComma.setTextLimit(80);
        WidgetFactory.createLabel((Composite)ret, (String)Messages.EditLabItem_labelVisible);
        this.visible = new Button(ret, 32);
        this.visible.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        WidgetFactory.createLabel((Composite)ret, (String)Messages.Core_Export_tag);
        this.cExportTag = new Combo(ret, 4);
        this.cExportTag.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cExportTag.setToolTipText(Messages.Core_HL7_Tags_comma_separated);
        this.cExportTag.setItems(this.exportTags.toArray(new String[0]));
        if (this.actLabItem != null) {
            this.iKuerzel.setText(this.actLabItem.getKuerzel());
            this.iTitel.setText(this.actLabItem.getName());
            if (this.actLabItem.getTyp() == LabItemTyp.NUMERIC) {
                this.numeric.setSelection(true);
            } else if (this.actLabItem.getTyp() == LabItemTyp.TEXT) {
                this.alph.setSelection(true);
            } else if (this.actLabItem.getTyp() == LabItemTyp.ABSOLUTE) {
                this.abs.setSelection(true);
            } else if (this.actLabItem.getTyp() == LabItemTyp.DOCUMENT) {
                this.document.setSelection(true);
                this.documentSelectionChanged();
            } else {
                this.formula.setSelection(true);
            }
            this.iUnit.setText(this.actLabItem.getEinheit());
            this.iRef.setText(this.actLabItem.get("RefMann"));
            this.iRfF.setText(this.actLabItem.getRefW());
            this.cGroup.setText(this.actLabItem.getGroup());
            this.iPrio.setText(this.actLabItem.getPrio());
            this.iComma.setText(Integer.toString(this.actLabItem.getDigits()));
            this.visible.setSelection(this.actLabItem.isVisible());
            this.loincCode.setText(this.actLabItem.getLoincCode());
            this.cExportTag.setText(this.actLabItem.getExport());
            this.formel = this.actLabItem.getFormula();
        }
        return ret;
    }

    private void documentSelectionChanged() {
        this.iRef.setEnabled(!this.document.getSelection());
        this.iRfF.setEnabled(!this.document.getSelection());
    }

    protected void okPressed() {
        if (this.iTitel.getText().length() < 1 && this.iPrio.getText().length() < 1) {
            this.setErrorMessage(Messages.EditLabItem_errorNoTitle);
            return;
        }
        LabItemTyp typ = this.numeric.getSelection() ? LabItemTyp.NUMERIC : (this.abs.getSelection() ? LabItemTyp.ABSOLUTE : (this.formula.getSelection() ? LabItemTyp.FORMULA : (this.document.getSelection() ? LabItemTyp.DOCUMENT : LabItemTyp.TEXT)));
        String refValMale = this.iRef.getText();
        String refValFemale = this.iRfF.getText();
        if (this.noRefValues.getSelection()) {
            refValMale = "inconclusive";
            refValFemale = "inconclusive";
        }
        if (this.actLabItem == null) {
            this.actLabItem = new LabItem(this.iKuerzel.getText(), this.iTitel.getText(), null, refValMale, refValFemale, this.iUnit.getText(), typ, this.cGroup.getText(), this.iPrio.getText());
            this.mapping.persistTransientLabMappings(this.actLabItem);
        } else {
            String t = "0";
            if (typ == LabItemTyp.TEXT) {
                t = "1";
            } else if (typ == LabItemTyp.ABSOLUTE) {
                t = "2";
            } else if (typ == LabItemTyp.FORMULA) {
                t = "3";
            } else if (typ == LabItemTyp.DOCUMENT) {
                t = "4";
            }
            this.actLabItem.set(new String[]{"kuerzel", "titel", "LaborID", "RefMann", "RefFrauOrTx", "Einheit", "Typ", "Gruppe", "prio", "export"}, new String[]{this.iKuerzel.getText(), this.iTitel.getText(), this.actLabor != null ? this.actLabor.getId() : null, refValMale, refValFemale, this.iUnit.getText(), t, this.cGroup.getText(), this.iPrio.getText(), this.cExportTag.getText()});
        }
        this.actLabItem.setLoincCode(this.loincCode.getText());
        if (!this.iComma.getText().isEmpty()) {
            this.actLabItem.setDigits(Integer.parseInt(this.iComma.getText()));
        } else {
            this.actLabItem.setDigits(0);
        }
        this.actLabItem.setVisible(this.visible.getSelection());
        if (!StringTool.isNothing((Object)this.formel)) {
            this.actLabItem.setFormula(this.formel);
        }
        super.okPressed();
    }

    public void setShortDescText(String string) {
        this.iKuerzel.setText(string);
    }

    public void setTitelText(String string) {
        if (string != null) {
            this.iTitel.setText(string);
        }
    }

    public void setRefMText(String string) {
        if (string != null) {
            this.iRef.setText(string);
        }
    }

    public void setRefFText(String string) {
        if (string != null) {
            this.iRfF.setText(string);
        }
    }

    public void setUnitText(String string) {
        if (string != null) {
            this.iUnit.setText(string);
        }
    }
}

