/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigendiagnosen;

import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.eigendiagnosen.Messages;
import ch.elexis.core.ui.eigendiagnosen.ModelServiceHolder;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;

public class EigendiagnoseSelector
extends CodeSelectorFactory {
    private CommonViewer commonViewer;

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.commonViewer = cv;
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new EigendiagnoseContentProvider(this.commonViewer), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(this.commonViewer, new String[]{"code=" + Messages.Core_Short_Label, "title=" + Messages.Core_Text}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        this.commonViewer.setNamedSelection("ch.elexis.core.ui.eigendiagnosen.selection");
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        return vc;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return Messages.Eigendiagnosen_CodeSystemName;
    }

    public Class getElementClass() {
        return IDiagnosisTree.class;
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IDiagnosisTree.class.equals(clazz) && this.commonViewer != null && !this.commonViewer.isDisposed()) {
            this.commonViewer.getViewerWidget().refresh();
        }
    }

    @Optional
    @Inject
    public void update(@UIEventTopic(value="info/elexis/model/update") IDiagnosisTree object) {
        if (this.commonViewer != null && object != null) {
            this.commonViewer.getViewerWidget().update((Object)object, null);
        }
    }

    private class EigendiagnoseContentProvider
    extends CommonViewerContentProvider
    implements ITreeContentProvider {
        public EigendiagnoseContentProvider(CommonViewer commonViewer) {
            super(commonViewer);
        }

        protected IQuery<?> getBaseQuery() {
            return ModelServiceHolder.get().getQuery(IDiagnosisTree.class);
        }

        public Object[] getElements(Object inputElement) {
            List roots = Collections.emptyList();
            IQuery<?> query = this.getBaseQuery();
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"VERSION");
            if (this.hasActiveFilter(this.fieldFilterValues)) {
                query.startGroup();
                for (String key : this.fieldFilterValues.keySet()) {
                    query.and(key, IQuery.COMPARATOR.LIKE, (Object)("%" + (String)this.fieldFilterValues.get(key) + "%"));
                }
                query.andJoinGroups();
                if (this.fieldOrderBy != null) {
                    query.orderBy(this.fieldOrderBy, this.fieldOrder);
                }
                List found = query.execute();
                ArrayList foundCopy = new ArrayList(found);
                roots = found.parallelStream().filter(d -> this.shouldBeVisible((IDiagnosisTree)d, foundCopy)).collect(Collectors.toList());
            } else {
                query.startGroup();
                query.or((EStructuralFeature)ModelPackage.Literals.IDIAGNOSIS_TREE__PARENT, IQuery.COMPARATOR.EQUALS, null);
                query.or((EStructuralFeature)ModelPackage.Literals.IDIAGNOSIS_TREE__PARENT, IQuery.COMPARATOR.EQUALS, (Object)"NIL");
                query.andJoinGroups();
                if (this.fieldOrderBy != null) {
                    query.orderBy(this.fieldOrderBy, this.fieldOrder);
                }
                roots = query.execute();
            }
            return roots.toArray();
        }

        private boolean hasActiveFilter(Map<String, String> fieldFilterValues) {
            if (fieldFilterValues != null && !fieldFilterValues.isEmpty()) {
                for (String key : fieldFilterValues.keySet()) {
                    String value = fieldFilterValues.get(key);
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean shouldBeVisible(IDiagnosisTree diagnosis, List<IDiagnosisTree> foundCopy) {
            List children = diagnosis.getChildren();
            if (children.isEmpty()) {
                return true;
            }
            for (IDiagnosisTree child : children) {
                if (!foundCopy.contains(child)) continue;
                return true;
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)parentElement).getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDiagnosisTree) {
                return !((IDiagnosisTree)element).getChildren().isEmpty();
            }
            return false;
        }
    }
}

