/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.Log;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractEval {
    public static CefMessageRouter createRouter() {
        CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig("chromiumEvaluate", "chromiumEvaluateCancel");
        return CefMessageRouter.create(config);
    }

    protected static String getEvalFunction(String id, String script, String finallyExec) {
        return "(function() {\nvar req;\ntry {\n  var ret;\n  try {\n  ret = (function() {\n  " + script + "\n" + "  })();\n" + "  try { req = __encodeType(['" + id + "', ret]) } catch(e) { req = __encodeType(" + 51 + ", true) };\n" + "  } catch(e) { req = __encodeType(e.toString(), true); }\n" + "} finally {" + finallyExec + "  }})();";
    }

    public abstract Object eval(String var1, CompletableFuture<Boolean> var2) throws InterruptedException, ExecutionException;

    protected Object executeEvalWithHandler(CefMessageRouter router, String url, BiConsumer<String, String> function, String script, CompletableFuture<Boolean> created) throws InterruptedException, ExecutionException {
        final String id = Integer.toString(new Random().nextInt());
        final CompletableFuture evalResult = new CompletableFuture();
        CefMessageRouterHandlerAdapter handler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                Object[] decodeType;
                block3: {
                    Log.debug("evaluate.returned: " + request);
                    callback.success(null);
                    decodeType = (Object[])AbstractEval.decodeType(request, 51);
                    if (id.equals(decodeType[0])) break block3;
                    return false;
                }
                try {
                    evalResult.complete(decodeType[1]);
                }
                catch (Throwable t) {
                    evalResult.completeExceptionally(t);
                }
                return true;
            }
        };
        router.addHandler(handler, true);
        String finallyExec = "  window.chromiumEvaluate({request: req,";
        Logger logger = Logger.getLogger("com.equo.chromium");
        if (logger != null && logger.getLevel() != Level.OFF) {
            finallyExec = String.valueOf(finallyExec) + " onSuccess: function(response) { console.log(response); }, onFailure: function(error_code, error_message) {console.log(error_message);},";
        }
        finallyExec = String.valueOf(finallyExec) + " persistent: true });\n";
        String eval = AbstractEval.getEvalFunction(id, script, finallyExec);
        created.thenRun(() -> {
            CefApp.getInstance().doMessageLoopWork(-1L);
            function.accept(eval, url);
        });
        this.awaitCondition(Display.getCurrent(), evalResult, false);
        router.removeHandler(handler);
        return evalResult.get();
    }

    protected void awaitCondition(Display display, CompletableFuture<?> condition, boolean doMessageLoopWork) {
        if (display != null) {
            while (!condition.isDone() && !display.isDisposed()) {
                if (doMessageLoopWork) {
                    CefApp.getInstance().doMessageLoopWork(-1L);
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    public static Object decodeType(String encoded, int errorCode) throws SWTException {
        try {
            Object json = Jsoner.deserialize(encoded);
            return AbstractEval.decodeType(json, errorCode);
        }
        catch (JsonException e) {
            throw new SWTException(51);
        }
    }

    private static Object decodeType(Object json, int errorCode) {
        if (json instanceof JsonArray) {
            int size = ((JsonArray)json).size();
            Object[] array = new Object[size];
            int i = 0;
            while (i < array.length) {
                array[i] = AbstractEval.decodeType(((JsonArray)json).get(i), errorCode);
                ++i;
            }
            return array;
        }
        if (json instanceof JsonObject) {
            JsonObject jsonErr = (JsonObject)json;
            if (jsonErr.containsKey("isError")) {
                Object err = jsonErr.get("error");
                if (Integer.valueOf(51).equals(err)) {
                    throw new SWTException(51);
                }
                throw new SWTException(50, err.toString());
            }
            throw new SWTException(errorCode);
        }
        if (json instanceof Number) {
            return ((Number)json).doubleValue();
        }
        return json;
    }
}

