package com.equo.chromium.internal;

import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserStandalone;
import org.cef.misc.Rectangle;

public final class Standalone extends IndependentBrowser {

	public Standalone(String url, String title, Rectangle window) {
		Engine.initCEF(Engine.BrowserType.STANDALONE);
		createClient();
		setBrowser(getClientHandler().createBrowser(url, false, false, createRequestContext(), null));
		getBrowser().setReference(this);

		CefBrowser browser = getBrowser();
		if (browser instanceof CefBrowserStandalone) {
			CefBrowserStandalone standaloneBrowser = (CefBrowserStandalone) browser;

			if (title != null && !title.trim().isEmpty()) {
				standaloneBrowser.setWindowTitle(title);
			}

			if (window != null) {
				standaloneBrowser.setWindow(window);
			}
		}

		browser.createImmediately();
	}

	public Standalone(String url) {
		this(url, null, null);
	}

	public Standalone(String url, Rectangle window) {
		this(url, null, window);
	}

	public Standalone(String url, String title) {
		this(url, title, null);
	}
}