/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.io.Settings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public class CfgSettings
extends Settings {
    private static final long serialVersionUID = 178926817L;
    private transient String filename;
    private transient String message = "CfgSettings v" + CfgSettings.Version();

    public static final String Version() {
        return "1.0.2";
    }

    public CfgSettings(String n, String msg2) {
        this.filename = n;
        this.message = msg2;
        this.undo();
    }

    public static Settings open(String name, String msg2) {
        try {
            if (CfgSettings.exists(name)) {
                return new CfgSettings(name, msg2);
            }
            Object h = System.getProperty("user.home", "");
            if (!((String)h).equals("")) {
                h = (String)h + File.separator;
            }
            if (CfgSettings.exists((String)h + name)) {
                return new CfgSettings((String)h + name, msg2);
            }
            if (CfgSettings.exists(name + ".cfg")) {
                return new CfgSettings(name + ".cfg", msg2);
            }
            if (CfgSettings.exists((String)h + name + ".cfg")) {
                return new CfgSettings((String)h + name + ".cfg", msg2);
            }
            if (name.matches(".*" + File.pathSeparator + ".*")) {
                return new CfgSettings(name, msg2);
            }
            return new CfgSettings((String)h + name, msg2);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static boolean exists(String name) {
        File fi = new File(name);
        return fi.exists();
    }

    @Override
    protected void flush_absolute() {
        if (this.filename == null) {
            return;
        }
        try {
            BufferedWriter fo = new BufferedWriter(new FileWriter(this.filename));
            fo.write("#" + this.message);
            ArrayList<String> all = this.getAll();
            for (String el : all) {
                String v = this.get(el, null);
                fo.write(el + "=" + v);
                fo.newLine();
            }
            fo.close();
        }
        catch (Exception e1) {
            ExHandler.handle(e1);
        }
    }

    @Override
    public void undo() {
        if (this.filename == null) {
            return;
        }
        this.clear();
        try {
            File fl = new File(this.filename);
            if (fl.exists() && fl.canRead()) {
                String line;
                BufferedReader fi = new BufferedReader(new FileReader(fl));
                while ((line = fi.readLine()) != null) {
                    if (StringTool.isNothing(line = line.replaceAll("#.*", "").trim())) continue;
                    String[] pair = line.split("=");
                    if (pair.length != 2) {
                        log.error("Format Error in config file " + this.filename);
                        continue;
                    }
                    this.set(pair[0].trim(), pair[1].trim());
                }
                fi.close();
                this.cleaned();
            }
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
        }
    }

    public void kill() {
        if (this.filename == null) {
            return;
        }
        File f = new File(this.filename);
        f.delete();
    }
}

