/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Result<T> {
    List<msg> list = new ArrayList<msg>();
    private SEVERITY severity = SEVERITY.OK;
    private int code;

    public SEVERITY getSeverity() {
        return this.severity;
    }

    public int getCode() {
        return this.code;
    }

    public List<msg> getMessages() {
        return this.list;
    }

    public String getCombinedMessages() {
        return this.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "));
    }

    public boolean isOK() {
        if (!this.list.isEmpty()) {
            for (msg m : this.list) {
                if (m.severity == SEVERITY.OK) continue;
                return false;
            }
        }
        return true;
    }

    public T get() {
        if (this.list.isEmpty()) {
            return null;
        }
        msg result = this.list.get(0);
        if (this.list.size() > 1) {
            for (msg m : this.list) {
                if (m.severity.ordinal() <= this.list.get((int)0).severity.ordinal()) continue;
                result = m;
            }
        }
        return result.object;
    }

    public Result(T result) {
        if (result instanceof Throwable) {
            Throwable _result = (Throwable)result;
            this.add(SEVERITY.ERROR, 0, _result.getMessage(), null, false);
        } else {
            this.add(SEVERITY.OK, 0, "Ok", result, false);
        }
    }

    public Result<T> add(SEVERITY severity, int code, String text, T result, boolean log) {
        this.list.add(new msg(code, text, severity, result));
        if (severity.ordinal() > this.severity.ordinal()) {
            this.severity = severity;
            this.code = code;
        }
        return this;
    }

    public Result<T> add(Result<T> r) {
        if (r.severity.ordinal() > this.severity.ordinal()) {
            this.severity = r.severity;
            this.code = r.code;
        }
        this.list.addAll(r.list);
        return this;
    }

    public Result() {
    }

    public Result(SEVERITY severity, List<msg> msgs) {
        if (severity.ordinal() > this.severity.ordinal()) {
            this.severity = severity;
        }
        if (msgs != null) {
            this.list.addAll(msgs);
        }
    }

    public Result(SEVERITY severity, int code, String text, T result, boolean bLog) {
        this.add(severity, code, text, result, bLog);
    }

    public String toString() {
        return "Result (" + String.valueOf((Object)this.severity) + ") msgs: " + this.list.stream().map(x -> x.text + "/" + x.code + "/" + String.valueOf(x.object)).reduce((x, y) -> x + " , " + y).get();
    }

    public static final <T> Result<T> OK() {
        return new Result<Object>(null);
    }

    public static final Result<String> OK(String text) {
        return new Result<String>(SEVERITY.OK, 0, text, text, false);
    }

    public static final Result<String> ERROR(String text) {
        return new Result<String>(SEVERITY.ERROR, 0, text, text, false);
    }

    public msg removeMsgEntry(String text, int code) {
        Iterator<msg> iterator = this.list.iterator();
        msg entry = null;
        while (iterator.hasNext()) {
            msg msg2 = iterator.next();
            if (!text.equals(msg2.text) || code != msg2.code) continue;
            entry = msg2;
            iterator.remove();
        }
        return entry;
    }

    public void addMessage(SEVERITY severity, String message) {
        this.list.add(new msg(0, message, severity, null));
    }

    public void addMessage(int code, SEVERITY severity, String message, T object) {
        this.list.add(new msg(code, message, severity, object));
    }

    public void addMessage(SEVERITY severity, String message, T object) {
        this.list.add(new msg(0, message, severity, object));
    }

    public final class CODE {
        public static final int URL = 779;

        private CODE() {
        }
    }

    public static enum SEVERITY {
        OK,
        WARNING,
        ERROR,
        FATAL;

    }

    public class msg {
        int code;
        String text;
        SEVERITY severity;
        T object;

        msg(int c, String t, SEVERITY s, T r) {
            this.code = c;
            this.text = t;
            this.severity = s;
            this.object = r;
        }

        public SEVERITY getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code;
        }

        public String getText() {
            return this.text;
        }

        public T getObject() {
            return this.object;
        }

        public String toString() {
            return "msg (" + String.valueOf((Object)this.severity) + ") " + this.code + " - " + this.text + " - " + String.valueOf(this.object);
        }
    }
}

