/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseNativeExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(DatabaseNativeExceptionHandler.class);
    public static final String MYSQL_ERRORCODE_TABLE_EXISTS = "42S01";
    public static final String MYSQL_ERRORCODE_DUPLICATE_COLUMN = "42S21";
    public static final String MYSQL_ERRORCODE_DUPLICATE_KEY_NAME = "42000";
    public static final String POSTGRES_ERRORCODE_DUPLICATE_COLUMN = "42701";
    public static final String POSTGRES_ERRORCODE_DUPLICATE_TABLE = "42P07";

    public static boolean handleException(String dBFlavor, SQLException e) {
        switch (dBFlavor) {
            case "mysql": {
                return DatabaseNativeExceptionHandler.handleMysqlException(e);
            }
            case "postgresql": {
                return DatabaseNativeExceptionHandler.handlePostgresException(e);
            }
            case "h2": {
                return DatabaseNativeExceptionHandler.handleH2Exception(e);
            }
        }
        log.error("Unknown database flavor: " + dBFlavor);
        return true;
    }

    private static boolean handleH2Exception(SQLException e) {
        return true;
    }

    private static boolean handleMysqlException(SQLException e) {
        String sqlState;
        switch (sqlState = e.getSQLState()) {
            case "42S01": {
                log.info("Found table exists, mitigating error code " + sqlState + ": " + e.getMessage());
                return false;
            }
            case "42S21": {
                log.info("Found duplicate column, mitigating error code " + sqlState + ": " + e.getMessage());
                return false;
            }
            case "42000": {
                log.info("Found duplicate key name, mitigating error code " + sqlState + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private static boolean handlePostgresException(SQLException e) {
        String sqlState;
        switch (sqlState = e.getSQLState()) {
            case "42701": 
            case "42P07": {
                log.info("Found duplicate element, mitigating error code " + sqlState + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }
}

