/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.elexis.core.jdt.NonNull;
import ch.rgw.tools.ExHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class Extensions {
    public static List<IConfigurationElement> getExtensions(String ext) {
        return Extensions.getExtensions(ext, null);
    }

    public static List<IConfigurationElement> getExtensions(String ext, String elementName) {
        LinkedList<IConfigurationElement> ret = new LinkedList<IConfigurationElement>();
        IExtensionRegistry exr = Platform.getExtensionRegistry();
        IExtensionPoint exp = exr.getExtensionPoint(ext);
        if (exp != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = exp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elems;
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                int n3 = elems.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (elementName != null) {
                        if (elementName.equals(el.getName())) {
                            ret.add(el);
                        }
                    } else {
                        ret.add(el);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ret;
    }

    public static List getClasses(List<IConfigurationElement> list, String points) {
        return Extensions.getClasses(list, points, true);
    }

    public static List getClasses(List<IConfigurationElement> list, String points, boolean bMandatory) {
        LinkedList<Object> ret = new LinkedList<Object>();
        for (IConfigurationElement el : list) {
            try {
                Object o = el.createExecutableExtension(points);
                if (o == null) continue;
                ret.add(o);
            }
            catch (CoreException e) {
                if (!bMandatory) continue;
                ExHandler.handle((String)(el.getName() + ": " + points), (Throwable)e);
            }
        }
        return ret;
    }

    public static List getClasses(String extension, String points) {
        return Extensions.getClasses(extension, points, null, null);
    }

    public static List getClasses(String extension, String elementName, String points) {
        return Extensions.getClasses(extension, elementName, points, null, null);
    }

    @NonNull
    public static List getClasses(String extension, String points, String idParam, String idValue) {
        return Extensions.getClasses(extension, null, points, idParam, idValue);
    }

    @NonNull
    public static List getClasses(String extension, String elementName, String points, String idParam, String idValue) {
        List<IConfigurationElement> extensions = Extensions.getExtensions(extension, elementName);
        if (idParam != null && idValue != null) {
            List<IConfigurationElement> filteredExtensions = extensions.stream().filter(p -> idValue.equalsIgnoreCase(p.getAttribute(idParam))).collect(Collectors.toList());
            return Extensions.getClasses(filteredExtensions, points, true);
        }
        return Extensions.getClasses(extensions, points, true);
    }

    public static List<String> getStrings(List<IConfigurationElement> list, String attr) {
        LinkedList<String> ret = new LinkedList<String>();
        for (IConfigurationElement el : list) {
            ret.add(el.getAttribute(attr));
        }
        return ret;
    }

    public static List<String> getStrings(String ext, String attr) {
        return Extensions.getStrings(Extensions.getExtensions(ext), attr);
    }

    public static Object executeService(Object service, String method, Class[] types, Object[] params) {
        try {
            Method m = service.getClass().getMethod(method, types);
            return m.invoke(service, params);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }
}

