/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import ch.elexis.core.l10n.Messages;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.Enumerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizeUtil {
    private static Logger log = LoggerFactory.getLogger(LocalizeUtil.class);

    public static String getLocaleText(Enumerator enumerator) {
        if (enumerator != null) {
            try {
                return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(enumerator.getClass().getSimpleName() + "_" + enumerator.getName());
            }
            catch (Exception e) {
                log.warn("No translation for {}_{} locale {} in {} ", new Object[]{enumerator.getClass().getSimpleName(), enumerator.getName(), Locale.getDefault(), Messages.class.getName()});
                return enumerator.getName();
            }
        }
        return "?";
    }

    private static String ensureUseOAddressTypefMessages() {
        return Messages.AddressType_SECONDARY_RESIDENCE + Messages.AddressType_HOLIDAY_HOME + Messages.AddressType_PRINCIPAL_RESIDENCE + Messages.AddressType_PLACE_OF_RESIDENCE + Messages.AddressType_EMPLOYER + Messages.AddressType_FAMILY_FRIENDS + Messages.AddressType_ATTACHMENT_FIGURE + Messages.AddressType_PRISON + Messages.AddressType_NURSING_HOME;
    }

    private static String ensureUseOfRelationShipMessages() {
        return Messages.Fall_Undefined + Messages.RelationshipType_BUSINESS_EMPLOYER + Messages.RelationshipType_BUSINESS_EMPLOYEE + Messages.RelationshipType_FAMILY_PARENT + Messages.RelationshipType_FAMILY_CHILD + Messages.RelationshipType_FAMILY_GUARDIAN + Messages.RelationshipType_FAMILY_ICE + Messages.RelationshipType_FAMILY_ALTERNATIVE + Messages.RelationshipType_WELFARE_GENERAL_PRACTITIONER + Messages.Core_Patient + Messages.Core_Doctor_Specialist + Messages.RelationshipType_WELFARE_INSURER + Messages.RelationshipType_WELFARE_INSUREE;
    }
}

