/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AddressType implements Enumerator
{
    PRINCIPAL_RESIDENCE(0, "PRINCIPAL_RESIDENCE", "PRINCIPAL_RESIDENCE"),
    SECONDARY_RESIDENCE(1, "SECONDARY_RESIDENCE", "SECONDARY_RESIDENCE"),
    HOLIDAY_HOME(2, "HOLIDAY_HOME", "HOLIDAY_HOME"),
    PLACE_OF_RESIDENCE(3, "PLACE_OF_RESIDENCE", "PLACE_OF_RESIDENCE"),
    EMPLOYER(4, "EMPLOYER", "EMPLOYER"),
    FAMILY_FRIENDS(5, "FAMILY_FRIENDS", "FAMILY_FRIENDS"),
    ATTACHMENT_FIGURE(6, "ATTACHMENT_FIGURE", "ATTACHMENT_FIGURE"),
    PRISON(7, "PRISON", "PRISON"),
    NURSING_HOME(8, "NURSING_HOME", "NURSING_HOME"),
    OTHER(9, "OTHER", "OTHER");

    public static final int PRINCIPAL_RESIDENCE_VALUE = 0;
    public static final int SECONDARY_RESIDENCE_VALUE = 1;
    public static final int HOLIDAY_HOME_VALUE = 2;
    public static final int PLACE_OF_RESIDENCE_VALUE = 3;
    public static final int EMPLOYER_VALUE = 4;
    public static final int FAMILY_FRIENDS_VALUE = 5;
    public static final int ATTACHMENT_FIGURE_VALUE = 6;
    public static final int PRISON_VALUE = 7;
    public static final int NURSING_HOME_VALUE = 8;
    public static final int OTHER_VALUE = 9;
    private static final AddressType[] VALUES_ARRAY;
    public static final List<AddressType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AddressType[]{PRINCIPAL_RESIDENCE, SECONDARY_RESIDENCE, HOLIDAY_HOME, PLACE_OF_RESIDENCE, EMPLOYER, FAMILY_FRIENDS, ATTACHMENT_FIGURE, PRISON, NURSING_HOME, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AddressType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddressType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddressType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AddressType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AddressType get(int value) {
        switch (value) {
            case 0: {
                return PRINCIPAL_RESIDENCE;
            }
            case 1: {
                return SECONDARY_RESIDENCE;
            }
            case 2: {
                return HOLIDAY_HOME;
            }
            case 3: {
                return PLACE_OF_RESIDENCE;
            }
            case 4: {
                return EMPLOYER;
            }
            case 5: {
                return FAMILY_FRIENDS;
            }
            case 6: {
                return ATTACHMENT_FIGURE;
            }
            case 7: {
                return PRISON;
            }
            case 8: {
                return NURSING_HOME;
            }
            case 9: {
                return OTHER;
            }
        }
        return null;
    }

    private AddressType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

