/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface ITextReplacementService {
    public static final String DONT_SHOW_REPLACEMENT_ERRORS = "*";
    public static final String MATCH_TEMPLATE = "\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]";
    public static final String MATCH_GENDERIZE = "\\[[*]?[a-zA-Z]+:mwn?:[^\\[]+\\]";
    public static final String MATCH_IDATACCESS = "\\[[*]?[-_a-zA-Z0-9]+:[-a-zA-Z0-9]+:[-a-zA-Z0-9\\.]+:[-a-zA-Z0-9\\.]:?[^\\]]*\\]";

    public List<ITextPlaceholderResolver> getResolvers();

    default public String performReplacement(IContext context, String template) {
        return this.performReplacement(context, template, System.lineSeparator());
    }

    public String performReplacement(IContext var1, String var2, String var3);

    public static String getPlaceholderType(String placeholder) {
        if (StringUtils.isNotBlank((CharSequence)placeholder)) {
            String ret = placeholder;
            if (ret.startsWith("[")) {
                ret = ret.substring(1);
            }
            if (ret.indexOf(".") > 1) {
                ret = ret.substring(0, ret.indexOf("."));
            }
            if (ret.indexOf(":") > 1) {
                ret = ret.substring(0, ret.indexOf(":"));
            }
            return ret;
        }
        return null;
    }
}

