/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.preferences;

import ch.elexis.core.services.IConfigService;
import ch.elexis.core.utils.CoreUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class PreferencesUtil {
    public static String getOsSpecificPreferenceName(CoreUtil.OS system, String defaultPreference) {
        switch (system) {
            case WINDOWS: {
                return defaultPreference + "_WINDOWS";
            }
            case MAC: {
                return defaultPreference + "_MAC";
            }
            case LINUX: {
                return defaultPreference + "_LINUX";
            }
        }
        return defaultPreference;
    }

    public static String getOsSpecificPreference(String defaultPreference, IConfigService configService) {
        CoreUtil.OS operatingSystem = CoreUtil.getOperatingSystemType();
        String osSpecificPreference = PreferencesUtil.getOsSpecificPreferenceName(operatingSystem, defaultPreference);
        String value = configService.get(osSpecificPreference, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            LoggerFactory.getLogger(PreferencesUtil.class).warn("No OS specific path set, reverting to generic setting");
            value = configService.get(defaultPreference, "");
        }
        return value;
    }
}

